from unittest import TestCase, skip
from PowerSimTool.types import Peptide, Spectrum, PROTON
from PowerSimTool.denovo import infer_tags
from PowerSimTool.search import cosine_similarity


class TestScore(TestCase):
    @skip("Need to adjust the expected scores")
    def test_score(self):
        peptide = Peptide('MLKCLSVEVQ', 'MLH3_HUMAN', '-', 'A')
        theo_peaks = peptide.theo_peaks
        peaks = [(peak, 1) for peak in theo_peaks]
        spectrum = Spectrum(0, peaks, peptide.mass + PROTON, 1)
        inferred = infer_tags(spectrum, [2, 3, 4, 5], 0.01)  # even we set 0.02, we may not guarantee the original
        s2 = cosine_similarity(inferred[0], peptide, 2)
        self.assertEqual(len(peptide.sequence) - 2 + 1, s2)
        s3 = cosine_similarity(inferred[1], peptide, 3)
        self.assertEqual(len(peptide.sequence) - 3 + 1, s3)
        s4 = cosine_similarity(inferred[2], peptide, 4)
        self.assertEqual(len(peptide.sequence) - 4 + 1, s4)
        s5 = cosine_similarity(inferred[3], peptide, 5)
        self.assertEqual(len(peptide.sequence) - 5 + 1, s5)
