from unittest import TestCase
from PowerSimTool.types import Peptide


class TestPeptide(TestCase):
    def test_gen_theo_peaks_1(self):
        sequence = 'PEPTLDE'
        peptide = Peptide(sequence, 'test_protein', 'n', 'c')
        theo_peaks = peptide.theo_peaks
        reference = [98.06009, 227.10268, 324.15544, 425.20312, 538.28718, 653.31413, 782.35672,
                     800.36728, 703.31452, 574.27193, 477.21916, 376.17149, 263.08742, 148.06048]
        reference = sorted(reference)
        self.assertEqual(len(reference), len(theo_peaks))
        for idx in range(0, len(reference)):
            self.assertAlmostEqual(round(reference[idx], 1), round(theo_peaks[idx], 1));

    def test_gen_theo_peaks_2(self):
        sequence = 'SELVEGVLV'
        peptide = Peptide(sequence, 'test_protein', 'n', 'c')
        theo_peaks = peptide.theo_peaks
        reference = [88.03935, 217.08194, 330.16601, 429.23442, 558.27701, 615.29848, 714.36689, 827.45095, 926.51937,
                     944.52993, 857.49790, 728.45531, 615.37125, 516.30283, 387.26024, 330.23878, 231.17036, 118.08630]
        reference = sorted(reference)
        self.assertEqual(len(reference), len(theo_peaks))
        for idx in range(0, len(reference)):
            self.assertAlmostEqual(round(reference[idx], 1), round(theo_peaks[idx], 1));

    def test_gen_theo_peaks_3(self):
        sequence = 'SELCVEGVLV'
        peptide = Peptide(sequence, 'test_protein', 'n', 'c')
        theo_peaks = peptide.theo_peaks
        reference = [88.03935, 217.08194,330.16601, 490.17519, 589.24361, 718.28620, 775.30766, 874.37608,987.46014, 1086.52855,
                     1104.53912, 1017.50709, 888.46450, 775.38043, 615.37125, 516.30283, 387.26024, 330.23878, 231.17036, 118.08630]
        reference = sorted(reference)
        self.assertEqual(len(reference), len(theo_peaks))
        for idx in range(0, len(reference)):
            self.assertAlmostEqual(round(reference[idx], 0), round(theo_peaks[idx], 0));

    def test_unsupported_amino_acid(self):
        with self.assertRaises(KeyError):
            peptide = Peptide('I', 'test_protein', 'n', 'c')
        with self.assertRaises(KeyError):
            peptide = Peptide('B', 'test_protein', 'n', 'c')
        with self.assertRaises(KeyError):
            peptide = Peptide('U', 'test_protein', 'n', 'c')
        with self.assertRaises(KeyError):
            peptide = Peptide('J', 'test_protein', 'n', 'c')
        with self.assertRaises(KeyError):
            peptide = Peptide('O', 'test_protein', 'n', 'c')
        with self.assertRaises(KeyError):
            peptide = Peptide('Z', 'test_protein', 'n', 'c')
        with self.assertRaises(KeyError):
            peptide = Peptide('X', 'test_protein', 'n', 'c')
