from unittest import TestCase
from PowerSimTool.denovo import infer_tags
from PowerSimTool.types import Peptide, Spectrum, PROTON


class TestInferTags(TestCase):
    def test_infer_tags(self):
        peptide = Peptide('MLKCLSVEVQ', 'MLH3_HUMAN', '-', 'A')
        theo_peaks = peptide.theo_peaks
        peaks = [(peak, 1) for peak in theo_peaks]
        spectrum = Spectrum(0, peaks, peptide.mass + PROTON, 1)
        inferred = infer_tags(spectrum, [2, 3, 4, 5], 0.01)  # even we set 0.02, we may not guarantee the original

        ref2 = ['LM', 'KL', 'CK', 'CL', 'LS', 'SV', 'EV', 'QV']
        self.assertEqual(len(ref2), len(inferred[0]))
        for tag in ref2:
            self.assertTrue(tag in inferred[0])

        ref3 = ['KLM', 'CKL', 'KCL', 'CLS', 'LSV', 'EVS', 'VEV', 'EVQ']
        self.assertEqual(len(ref3), len(inferred[1]))
        for tag in ref3:
            self.assertTrue(tag in inferred[1])

        ref4 = ['CKLM', 'LCKL', 'KCLS', 'CLSV', 'EVSL', 'SVEV', 'QVEV']
        self.assertEqual(len(ref4), len(inferred[2]))
        for tag in ref4:
            self.assertTrue(tag in inferred[2])

        ref5 = ['LCKLM', 'LKCLS', 'KCLSV', 'CLSVE', 'LSVEV', 'QVEVS']
        self.assertEqual(len(ref5), len(inferred[3]))
        for tag in ref5:
            self.assertTrue(tag in inferred[3])
