% MATLAB script to visualize test dataset

files = {
    '../../PST_CSV/PvN.Test.Part01.csv', ...
    '../../PST_CSV/PvN.Test.Part02.csv', ...
    '../../PST_CSV/PvN.Test.Part03.csv', ...
    '../../PST_CSV/PvN.Test.Part04.csv', ...
    ...%
};

OUTPUT = true;

% read data
data = [];
for cell = files
    filename = cell{1};
    disp(['Loading ' filename]);
    part = csvread(filename, 1, 0);
    data = [data; part];
end

% define model
a = -15.1281921242370;
b = 21.9060337576264;
c = 6.43839208315330;
d = -5.02335360283093;
e = -0.164557266572670;
f = 1.03660371839540;

% predict
mu = data(:,1); 
log_rho = log10(data(:,2)); 
lambda = data(:,3); 
prob = data(:,4);
% transform symbol
rs = 1 - mu;
log_rn = -log_rho;
pred = (e*lambda+f)./(1+exp(-(a+b*rs)))./(1+exp(-(c+d*log_rn)));

% separate test set
X = [rs, log_rn, lambda, prob, pred];
X1 = X( X(:,2) >= -1 ,:);
X2 = X( X(:,2) < -1 ,:);

% prediction within range
residual = X1(:,5) - X1(:,4);
abs_res = abs(residual);
[ff,xx] = ecdf(abs_res);
figure; hold on; grid on;
yyaxis left; ylabel('count');
histogram(abs_res, 'BinWidth', 0.02, 'EdgeColor', 'none');
yyaxis right; ylabel('cumulative distribution');
plot(xx, ff, 'LineWidth', 2); 
xlabel('absolute residuals'); xlim([-0.05 0.65]);
set(gca, 'FontSize', 20);

if OUTPUT
    print('test_in', '-depsc');
end

% prediction outside range
residual = X2(:,5) - X2(:,4);
abs_res = abs(residual);
[ff,xx] = ecdf(abs_res);
figure; hold on; grid on;
yyaxis left; ylabel('count');
histogram(abs_res, 'BinWidth', 0.02, 'EdgeColor', 'none');
yyaxis right; ylabel('cumulative distribution');
plot(xx, ff, 'LineWidth', 2); 
xlabel('absolute residuals'); xlim([-0.05 0.65]);
set(gca, 'FontSize', 20);

if OUTPUT
    print('test_out', '-depsc');
end