# Copyright (C) 2018 Jiaan Dai

"""Script for splitting line-delimited json data."""

import gzip
import argparse

parser = argparse.ArgumentParser(description=__doc__)
parser.add_argument('-i', required=True, help='input .dat file')
parser.add_argument('-o', required=True, help='output dir')
parser.add_argument('-n', type=int, required=True, help='size of each splitted file')
parser.add_argument('--prefix', required=True, help='prefix of splitted files')
args = parser.parse_args()

with gzip.open(args.i, 'rb') as library:
    file_no = 0
    filename = '{}.Part{:03d}.dat'.format(args.o + '/' + args.prefix, file_no)
    output = gzip.open(filename, 'wb')
    line_no = 0
    for line in library:
        output.write(line)
        line_no += 1
        if line_no >= args.n:
            output.close()
            file_no += 1
            filename = '{}.Part{:03d}.dat'.format(args.o + '/' + args.prefix, file_no)
            output = gzip.open(filename, 'wb')
            line_no = 0
    output.close()
