% MATLAB script for visualization

files = {
%     '../../PST_CSV/PvN.Part01.csv', ...
%     '../../PST_CSV/PvN.Part02.csv', ...
%     '../../PST_CSV/PvN.Part03.csv', ...
%     '../../PST_CSV/PvN.Part04.csv', ...
%     '../../PST_CSV/PvN.Part05.csv', ...
%     '../../PST_CSV/PvN.Part06.csv', ...
%     '../../PST_CSV/PvN.Part07.csv', ...
%     '../../PST_CSV/PvN.Part08.csv', ...
%     '../../PST_CSV/PvN.Dense.Part01.csv', ...
%     '../../PST_CSV/PvN.Dense.Part02.csv', ...
%     '../../PST_CSV/PvN.Dense.Part03.csv', ...
%     '../../PST_CSV/PvN.Dense.Part04.csv', ...
%     '../../PST_CSV/PvN.Dense.Part05.csv', ...
%     '../../PST_CSV/PvN.Dense.Part06.csv', ...
%     '../../PST_CSV/PvN.Dense.Part07.csv', ...
%     '../../PST_CSV/PvN.Dense.Part08.csv', ...
    ...%
%     'E:\Jiaan\TVS_RESULT\control\TvS.Tag.Part01.csv', ...
%     'E:\Jiaan\TVS_RESULT\control\TvS.Tag.Part02.csv', ...
%     'E:\Jiaan\TVS_RESULT\control\TvS.Tag.Part03.csv', ...
%     'E:\Jiaan\TVS_RESULT\control\TvS.Tag.Part04.csv', ...
%     'E:\Jiaan\TVS_RESULT\control\TvS.Tag.Part05.csv', ...
%     'E:\Jiaan\TVS_RESULT\control\TvS.Tag.Part06.csv', ...
%     'E:\Jiaan\TVS_RESULT\control\TvS.Tag.Part07.csv', ...
%     'E:\Jiaan\TVS_RESULT\control\TvS.Tag.Part08.csv', ...
%     'E:\Jiaan\TVS_RESULT\control\TvS.Tag.Part09.csv', ...
%     'E:\Jiaan\TVS_RESULT\control\TvS.Tag.Part10.csv', ...
%     'E:\Jiaan\TVS_RESULT\control\TvS.Tag.Part11.csv', ...
    'E:\Jiaan\TVS_RESULT\control\TvS.Spectrum.Part01.csv', ...
    'E:\Jiaan\TVS_RESULT\control\TvS.Spectrum.Part02.csv', ...
    'E:\Jiaan\TVS_RESULT\control\TvS.Spectrum.Part03.csv', ...
    'E:\Jiaan\TVS_RESULT\control\TvS.Spectrum.Part04.csv', ...
    'E:\Jiaan\TVS_RESULT\control\TvS.Spectrum.Part05.csv', ...
    'E:\Jiaan\TVS_RESULT\control\TvS.Spectrum.Part06.csv', ...
    'E:\Jiaan\TVS_RESULT\control\TvS.Spectrum.Part07.csv', ...
    'E:\Jiaan\TVS_RESULT\control\TvS.Spectrum.Part08.csv', ...
    'E:\Jiaan\TVS_RESULT\control\TvS.Spectrum.Part09.csv', ...
    'E:\Jiaan\TVS_RESULT\control\TvS.Spectrum.Part10.csv', ...
    'E:\Jiaan\TVS_RESULT\control\TvS.Spectrum.Part11.csv', ...
    ...%
};

DEBUG = false;
OUTPUT = false;

% read data
data = [];
for cell = files
    filename = cell{1};
    disp(['Loading ' filename]);
    part = csvread(filename, 1, 0);
    data = [data; part];
end

% filter
% data = data( log10(data(:,2)) <= 1 ,:);
% data = data( log10(data(:,2)) >= -2 ,:);

% loop
sep_fitresult = []; sep_residuals = [];
num_mods = 0:0.25:max(data(:,3));
for n = num_mods
    sub = data( data(:,3) == n ,:);
    log_rho = log10(sub(:,2));
    % transform symbols
    rs = 1 - sub(:,1);
    log_rn = -log_rho;
    % fit
    [xData, yData, zData] = prepareSurfaceData( rs, log_rn, sub(:,4) );
    ft = fittype( 'pmax * 1 / (1+exp(-(a+b*x))) * 1 / (1+exp(-(c+d*y)))', 'independent', {'x', 'y'}, 'dependent', 'z' );
    opts = fitoptions( 'Method', 'NonlinearLeastSquares', 'StartPoint', [0,0,0,0,0] );
    [fitresult, gof, output] = fit( [xData, yData], zData, ft, opts );
    % collect
    sep_fitresult = [sep_fitresult; fitresult.pmax, fitresult.a, fitresult.b, fitresult.c, fitresult.d, gof.sse];
    
    if DEBUG
        sep_residuals = [sep_residuals, output.residuals];
        figure; h = plot( fitresult, [xData, yData], zData );
        shading interp; alpha(0.7); h(2).MarkerEdgeColor = 'none'; h(2).MarkerFaceColor = [0.224 0.286 0.671];
        title(['separate mode, lambda ' num2str(n)]); xlabel('r_s'); ylabel('log_{10} r_n'); zlabel('p'); 
        set(gca, 'FontSize', 20); zlim([0 1.2]); view(210, 20); 
    end
end

% pmax trend
pmaxs = sep_fitresult(:,1)';
P = polyfit(num_mods, pmaxs, 1);
x = 0:0.01:max(num_mods); 
y = P(1) * x + P(2);
yy = P(1) * x + 1;

figure; hold on; grid on;
scatter(num_mods, pmaxs); plot(x, y); %plot(x, yy);
xlabel('\lambda'); ylabel('pmax'); legend('obs', 'fit');
set(gca, 'FontSize', 20);

if OUTPUT
    print('pmax_vs_lambda', '-depsc');
end

% other params' trend
if DEBUG
    for i = 2:5
        figure; scatter(num_mods, sep_fitresult(:,i)); grid on;
        titles = 'abcd'; title(titles(i-1)); xlabel('\lambda'); ylabel(titles(i-1));
    end
end

% unified model
mu = data(:,1); log_rho = log10(data(:,2)); lambda = data(:,3); prob = data(:,4);
% transform symbols
rs = 1 - mu;
log_rn = -log_rho;
% fit
e = P(1); f = P(2);
fun = @(r) (e*lambda+f)./(1+exp(-(r(1)+r(2)*rs)))./(1+exp(-(r(3)+r(4)*log_rn))) - prob;
[x,resnorm,residual,exitflag,output] = lsqnonlin(fun,[0,0,0,0]);

% residual comparison
if DEBUG
    figure; hold on;
    histogram(sep_residuals, 'BinWidth', 0.01);
    histogram(residual, 'BinWidth', 0.01);
    title('Residuals Histogram'); xlabel('error'); ylabel('count'); legend('Separate Models', 'Unified Model');
    set(gca, 'FontSize', 20);
end

% comparison
SSE = sum(sep_fitresult(:,6)); RMSE = sqrt(SSE / length(prob));
disp(['Separate Models: RMSE = ' num2str(RMSE) ', SSE = ' num2str(SSE)]);
SSE = resnorm; RMSE = sqrt(SSE / length(prob)); 
disp(['Unified Model: RMSE = ' num2str(RMSE) ', SSE = ' num2str(SSE)]);

% separate plots
fileidx = 1;
for n = num_mods
    sub = data( data(:,3) == n ,:);
    log_rho = log10(sub(:,2));
    % transform symbol
    rs = 1 - sub(:,1);
    log_rn = -log_rho;
    %
    [mumesh, logrhomesh] = meshgrid(0:0.01:1,min(log_rn):0.01:max(log_rn));
    pred_y = (e*n+f)./(1+exp(-(x(1)+x(2)*mumesh)))./(1+exp(-(x(3)+x(4)*logrhomesh)));
    figure; surf(mumesh, logrhomesh, pred_y);
    shading interp; alpha(0.7); hold on;
    scatter3(rs, log_rn, sub(:,4), 'filled');
    xlabel('r_s'); ylabel('log_{10} r_n'); zlabel('p');
    zlim([0 1.2]); set(gca, 'FontSize', 20); %view(210, 20); 
    view(240, 20); 
    
    if OUTPUT
        print(['pst_output_' num2str(fileidx)], '-depsc');
        fileidx = fileidx + 1;
    else
        title(['lambda ' num2str(n)]);
    end
    
    if DEBUG
        resi = (e*n+f)./(1+exp(-(x(1)+x(2)*rs)))./(1+exp(-(x(3)+x(4)*log_rn))) - sub(:,4);
        figure; scatter3(rs, log_rn, resi, 'filled'); title('Residual Plot'); view(210, 20); 
    end
end

% training residual analysis
[ff,xx] = ecdf(residual);
figure; hold on; grid on;
yyaxis left; ylabel('count'); 
histogram(residual, 'BinWidth', 0.02, 'EdgeColor', 'none');
yyaxis right; ylabel('cumulative distribution'); 
plot(xx, ff, 'LineWidth', 2); 
xlabel('residual'); set(gca, 'FontSize', 20);

% absolute training residual
abs_res = abs(residual);
[ff,xx] = ecdf(abs_res);
figure; hold on; grid on;
yyaxis left; ylabel('count');
histogram(abs_res, 'BinWidth', 0.02, 'EdgeColor', 'none');
yyaxis right; ylabel('cumulative distribution');
plot(xx, ff, 'LineWidth', 2); 
xlabel('absolute residuals'); xlim([-0.05 0.85]);
set(gca, 'FontSize', 20);

if OUTPUT
    print('train_abs_res', '-depsc');
end