function plot_separate(rs, log_rn, lambda, prob, debug_flag)

global pred;
[rs_mesh, logrn_mesh] = meshgrid(0:0.01:1, min(log_rn):0.01:max(log_rn));
pred_y = pred(rs_mesh, logrn_mesh, lambda);

figure;
surf(rs_mesh, logrn_mesh, pred_y);
shading interp;
alpha(0.7);
hold on;
scatter3(rs, log_rn, prob, 'filled');
xlabel('r_s');
ylabel('log_{10} r_n');
zlabel('p');
zlim([0 1.2]);
set(gca, 'FontSize', 20);
view(240, 20);  % view(210, 20);
title(['Unified \lambda = ' num2str(lambda)]);  % re-set title('') to remove the title

if debug_flag
    resi = pred(rs, log_rn, lambda) - prob;
    figure;
    scatter3(rs, log_rn, resi, 'filled');
    title('Residual Plot');
    view(210, 20);
end
