function plot_residual(residual, take_abs)

if take_abs
    residual = abs(residual);
end
[ff,xx] = ecdf(residual);

figure;
hold on;
grid on;
yyaxis left;
ylabel('count');
histogram(residual, 'BinWidth', 0.02, 'EdgeColor', 'none');
yyaxis right;
ylabel('cumulative distribution');
plot(xx, ff, 'LineWidth', 2);
xlabel('residuals');
set(gca, 'FontSize', 20);

if take_abs
    xlabel('absolute residuals');
    xlim([-0.05 0.85]);
end