function data = load_data(dataset_name)

tag_files = {
    'E:\Jiaan\TVS_RESULT\control\TvS.Tag.Part01.csv', ...
    'E:\Jiaan\TVS_RESULT\control\TvS.Tag.Part02.csv', ...
    'E:\Jiaan\TVS_RESULT\control\TvS.Tag.Part03.csv', ...
    'E:\Jiaan\TVS_RESULT\control\TvS.Tag.Part04.csv', ...
    'E:\Jiaan\TVS_RESULT\control\TvS.Tag.Part05.csv', ...
    'E:\Jiaan\TVS_RESULT\control\TvS.Tag.Part06.csv', ...
    'E:\Jiaan\TVS_RESULT\control\TvS.Tag.Part07.csv', ...
    'E:\Jiaan\TVS_RESULT\control\TvS.Tag.Part08.csv', ...
    'E:\Jiaan\TVS_RESULT\control\TvS.Tag.Part09.csv', ...
    'E:\Jiaan\TVS_RESULT\control\TvS.Tag.Part10.csv', ...
    'E:\Jiaan\TVS_RESULT\control\TvS.Tag.Part11.csv', ...
};

spec_files = {
    'E:\Jiaan\TVS_RESULT\control\TvS.Spectrum.Part01.csv', ...
    'E:\Jiaan\TVS_RESULT\control\TvS.Spectrum.Part02.csv', ...
    'E:\Jiaan\TVS_RESULT\control\TvS.Spectrum.Part03.csv', ...
    'E:\Jiaan\TVS_RESULT\control\TvS.Spectrum.Part04.csv', ...
    'E:\Jiaan\TVS_RESULT\control\TvS.Spectrum.Part05.csv', ...
    'E:\Jiaan\TVS_RESULT\control\TvS.Spectrum.Part06.csv', ...
    'E:\Jiaan\TVS_RESULT\control\TvS.Spectrum.Part07.csv', ...
    'E:\Jiaan\TVS_RESULT\control\TvS.Spectrum.Part08.csv', ...
    'E:\Jiaan\TVS_RESULT\control\TvS.Spectrum.Part09.csv', ...
    'E:\Jiaan\TVS_RESULT\control\TvS.Spectrum.Part10.csv', ...
    'E:\Jiaan\TVS_RESULT\control\TvS.Spectrum.Part11.csv', ...
};

tag_test_files = {
    'E:\Jiaan\TVS_RESULT\control\TvS.Test.Tag.Part01.csv', ...
    'E:\Jiaan\TVS_RESULT\control\TvS.Test.Tag.Part02.csv', ...
};

spec_test_files = {
    'E:\Jiaan\TVS_RESULT\control\TvS.Test.Spectrum.Part01.csv', ...
    'E:\Jiaan\TVS_RESULT\control\TvS.Test.Spectrum.Part02.csv', ...
};

tag_noise_test_files = {
    'E:\Jiaan\TVS_RESULT\control\TvS.Test.Tag.Part03.csv', ...
};

spec_noise_test_files = {
    'E:\Jiaan\TVS_RESULT\control\TvS.Test.Spectrum.Part03.csv', ...
};

data = [];

if strcmp(dataset_name, 'tag')
    filenames = tag_files;
elseif strcmp(dataset_name, 'spec')
    filenames = spec_files;
elseif strcmp(dataset_name, 'tag.test')
    filenames = tag_test_files;
elseif strcmp(dataset_name, 'spec.test')
    filenames = spec_test_files;
elseif strcmp(dataset_name, 'tag.test.noise')
    filenames = tag_noise_test_files;
elseif strcmp(dataset_name, 'spec.test.noise')
    filenames = spec_noise_test_files;
else
    return;
end

for cell = filenames
    filename = cell{1};
    disp(['Loading ' filename]);
    part = csvread(filename, 1, 0);
    data = [data; part];
end
