function fit_separate(rs, log_rn, lambda, prob, debug_flag)

global coef_names;
global coefs;
global metrics;
global residuals;
global eq;

[xData, yData, zData] = prepareSurfaceData( rs, log_rn, prob );
ft = fittype( eq, 'independent', {'x', 'y'}, 'dependent', 'z' );
opts = fitoptions( 'Method', 'NonlinearLeastSquares', 'StartPoint', [0,0,0,0,0] );
[fitresult, gof, output] = fit( [xData, yData], zData, ft, opts );

if isempty(coef_names)
    coef_names = coeffnames(fitresult)';
end

coefs = [coefs; coeffvalues(fitresult)];
metrics = [metrics; gof.sse];
residuals = [residuals, output.residuals'];

if debug_flag
    figure;
    h = plot( fitresult, [xData, yData], zData );
    shading interp;
    alpha(0.7);
    h(2).MarkerEdgeColor = 'none';
    h(2).MarkerFaceColor = [0.224 0.286 0.671];
    set(gca, 'FontSize', 20); zlim([0 1.2]); view(210, 20);
    title(['Separate \lambda = ' num2str(lambda)]);
    xlabel('r_s');
    ylabel('log_{10} r_n');
    zlabel('p');
end
