# Copyright (C) 2018 Jiaan Dai

"""echo .dat result file."""

import gzip
import sys
import argparse

parser = argparse.ArgumentParser(description=__doc__)
parser.add_argument('file', help='path to .dat file')
args = parser.parse_args()

with gzip.open(args.file, 'rb') as f:
    for line in f:
        sys.stdout.write(str(line, encoding='utf-8'))
        sys.stdout.write('=' * 72 + '\n')
