# PowerSimTool

A parallel simulation tool for evaluating open search methods in the
identification of peptides with post-translational modifications (PTMs).

## Usage

Please change the directory to the root of the package before starting simulations.

To run simulations using the tag-based open search, please use the following commands.
```bash
python3 scripts/run.py config/sample.json
python3 scripts/local_control.py output/Sample.Output.dat
```

To run simulations using the spectrum-based open search, please use the following commands.
```bash
python3 scripts/run_spec.py config/sample.spec.json
python3 scripts/local_control.py output/Sample.Spectrum.Output.dat
```

To view the content of the result file (.dat), please use
```bash
python3 scripts/echo.py output/Sample.Output.dat
```

## Publication

J. Dai\*, F. Yu\*, N. Li, and W. Yu.,
**"Is it feasible to only use tags in database search for PTM-invariant peptide identification? — A simulation-based study"**,
in The 21st Annual International Conference on Research in Computational Molecular Biology (RECOMB 2017 Poster).
\*Contributed equally to this work.

J. Dai\*, F. Yu\*, N. Li, and W. Yu.,
**"Understanding the limit of open search in the identification of peptides with post-translational modifications — A simulation-based study"**,
in preparation. \*Contributed equally to this work.

## License

BSD License