# Copyright (C) 2017 Jiaan Dai

"""Scoring and searching utilities."""

import bisect
from math import sqrt


def cosine_similarity(tags1, tags2):
    if len(tags1) == 0 or len(tags2) == 0:
        return 0
    intersect = tags1.intersection(tags2)
    numerator = len(intersect)
    denominator = sqrt(len(tags1)) * sqrt(len(tags2))
    norm_dot_prod = numerator / denominator
    return norm_dot_prod


def search(spectrum_tags, mass_array, tags_array,
           ms1tol, precursor_mass, score):
    left = bisect.bisect_left(mass_array, precursor_mass - ms1tol)
    right = bisect.bisect_right(mass_array, precursor_mass + ms1tol)

    max_score = score(spectrum_tags, tags_array[left])
    max_idx = left
    for i in range(left+1, right):
        current_score = score(spectrum_tags, tags_array[i])
        if current_score > max_score:
            max_score = current_score
            max_idx = i

    return max_score, max_idx

