# Copyright (C) 2017 Jiaan Dai

"""Logger for simulator."""

import os
import logging as _logging
from datetime import datetime as _datetime

_prefix = 'logs/'
if not os.path.exists(_prefix):
    os.makedirs(_prefix)

_logfmt = '%(asctime)s %(levelname)s [pid=%(process)d] \t %(message)s'
_datefmt = '%Y-%m-%d %I:%M:%S'
_filename = _datetime.now().strftime('PST_%Y-%m-%d.log')

_logging.basicConfig(filename=_prefix+_filename,
                     level=_logging.INFO,
                     format=_logfmt,
                     datefmt=_datefmt)

def info(msg):
    _logging.info(msg)

def error(msg):
    _logging.error(msg)

