::
:: GBOOST Startup Script for Windows
::
@echo off
cls
:: Set the memory usage for the java program
SET JVM_ARGS=-Xms256m -Xmx1024m
SET JVM_ARGS=%JVM_ARGS% 

:: Set Java Home Path manually if neccessary
SET JAVA_HOME=

:: Automatically detect and set JAVA_HOME
SET MinimumRequiredJavaVersion=1.6
if "%JAVA_HOME%" == "" (
	goto WithoutJavaHome
) ELSE (
	goto WithJavaHome
)

:WithJavaHome
echo Using a given Java home path to run Java
SET JAVA_EXE=%JAVA_HOME%\bin\java.exe
IF NOT EXIST "%JAVA_EXE%" goto TrySystemBin
"%JAVA_EXE%" -version 2>java_version.txt
:: Detect if the current java version fulfill minimum java runtime environment for the program
for /f "tokens=3" %%i in (java_version.txt) do (
	if %%i LEQ "%MinimumRequiredJavaVersion%" goto ERROR_MINIMUM_JAVA_VERSION
)
:: Get Current Java Version, extract the first token
for /f "tokens=3" %%i in (java_version.txt) do (
	SET CURRENT_VERSION=%%i
	goto START_JAVA_PROGRAM
)
goto START_JAVA_PROGRAM

:WithoutJavaHome
:: Set the registry path to find the java path
SET KeyName=HKLM\Software\JavaSoft\Java Runtime Environment
SET Cmd=reg query "%KeyName%" /s
echo Try to search for registry key of Java
:: Detect and set JAVA_HOME
FOR /f "tokens=2*" %%i in ('%Cmd% ^| find "JavaHome"') do SET JAVA_HOME=%%j
IF "%JAVA_HOME%" == "" (goto TrySystemBin)
FOR /f "tokens=2*" %%i in ('%Cmd% ^| find "CurrentVersion"') do SET CURRENT_VERSION=%%j
:: Detect if the current java version fulfill minimum java runtime environment for the program
IF /I %CURRENT_VERSION% GEQ %MinimumRequiredJavaVersion% (
	SET JAVA_EXE=%JAVA_HOME%\bin\java.exe
	IF NOT EXIST "%JAVA_EXE%" goto TrySystemBin
	goto START_JAVA_PROGRAM
	) ELSE (
	goto ERROR_MINIMUM_JAVA_VERSION
)
goto START_JAVA_PROGRAM

:TrySystemBin
echo Try System Bin to launch Java
SET JAVA_HOME=
SET JAVA_EXE=java.exe
"%JAVA_EXE%" -version 2>java_version.txt
:: Detect if the current java version fulfill minimum java runtime environment for the program
for /f "tokens=3" %%i in (java_version.txt) do (
	if %%i LEQ "%MinimumRequiredJavaVersion%" goto ERROR_MINIMUM_JAVA_VERSION
)
:: Get Current Java Version, extract the first token
for /f "tokens=3" %%i in (java_version.txt) do (
	SET CURRENT_VERSION=%%i
	goto START_JAVA_PROGRAM
)
goto START_JAVA_PROGRAM

:START_JAVA_PROGRAM
echo JavaHome : %JAVA_HOME%
echo Current Java Runtime Environment Version : %CURRENT_VERSION%

SET PROGRAM_HOME=.
SET MAIN_CLASS=gboost_gui.Main

SET OLD_PATH=%PATH%
SET PATH=%PROGRAM_HOME%;%PATH%

:: Setting Current Path
SET CLASS_PATH=%PROGRAM_HOME%\GBOOST_GUI.jar

:: Setting my doggy 1.4.2 class path
SET CLASS_PATH=%CLASS_PATH%;%PROGRAM_HOME%\lib\mydoggy-1.4.2\mydoggy-api-1.4.2.jar
SET CLASS_PATH=%CLASS_PATH%;%PROGRAM_HOME%\lib\mydoggy-1.4.2\mydoggy-plaf-1.4.2.jar
SET CLASS_PATH=%CLASS_PATH%;%PROGRAM_HOME%\lib\mydoggy-1.4.2\mydoggy-res-1.4.2.jar
SET CLASS_PATH=%CLASS_PATH%;%PROGRAM_HOME%\lib\mydoggy-1.4.2\TableLayout-20050920.jar

:: Setting jfreeChart 1.0.13 class path
SET CLASS_PATH=%CLASS_PATH%;%PROGRAM_HOME%\lib\jfreechart\jcommon-1.0.16.jar
SET CLASS_PATH=%CLASS_PATH%;%PROGRAM_HOME%\lib\jfreechart\jfreechart-1.0.13.jar

:: Setting JUNG class path
SET CLASS_PATH=%CLASS_PATH%;%PROGRAM_HOME%\lib\jung2-2_0_1\collections-generic-4.01.jar
SET CLASS_PATH=%CLASS_PATH%;%PROGRAM_HOME%\lib\jung2-2_0_1\colt-1.2.0.jar
SET CLASS_PATH=%CLASS_PATH%;%PROGRAM_HOME%\lib\jung2-2_0_1\concurrent-1.3.4.jar
SET CLASS_PATH=%CLASS_PATH%;%PROGRAM_HOME%\lib\jung2-2_0_1\j3d-core-1.3.1.jar
SET CLASS_PATH=%CLASS_PATH%;%PROGRAM_HOME%\lib\jung2-2_0_1\jung-3d-2.0.1.jar
SET CLASS_PATH=%CLASS_PATH%;%PROGRAM_HOME%\lib\jung2-2_0_1\jung-3d-demos-2.0.1.jar
SET CLASS_PATH=%CLASS_PATH%;%PROGRAM_HOME%\lib\jung2-2_0_1\jung-algorithms-2.0.1.jar
SET CLASS_PATH=%CLASS_PATH%;%PROGRAM_HOME%\lib\jung2-2_0_1\jung-api-2.0.1.jar
SET CLASS_PATH=%CLASS_PATH%;%PROGRAM_HOME%\lib\jung2-2_0_1\jung-graph-impl-2.0.1.jar
SET CLASS_PATH=%CLASS_PATH%;%PROGRAM_HOME%\lib\jung2-2_0_1\jung-io-2.0.1.jar
SET CLASS_PATH=%CLASS_PATH%;%PROGRAM_HOME%\lib\jung2-2_0_1\jung-jai-2.0.1.jar
SET CLASS_PATH=%CLASS_PATH%;%PROGRAM_HOME%\lib\jung2-2_0_1\jung-jai-samples-2.0.1.jar
SET CLASS_PATH=%CLASS_PATH%;%PROGRAM_HOME%\lib\jung2-2_0_1\jung-samples-2.0.1.jar
SET CLASS_PATH=%CLASS_PATH%;%PROGRAM_HOME%\lib\jung2-2_0_1\jung-visualization-2.0.1.jar
SET CLASS_PATH=%CLASS_PATH%;%PROGRAM_HOME%\lib\jung2-2_0_1\stax-api-1.0.1.jar
SET CLASS_PATH=%CLASS_PATH%;%PROGRAM_HOME%\lib\jung2-2_0_1\vecmath-1.3.1.jar
SET CLASS_PATH=%CLASS_PATH%;%PROGRAM_HOME%\lib\jung2-2_0_1\wstx-asl-3.2.6.jar

echo "%JAVA_EXE%" %JVM_ARGS% -cp "%CLASS_PATH%" %MAIN_CLASS% %*
"%JAVA_EXE%" %JVM_ARGS% -cp "%CLASS_PATH%" %MAIN_CLASS% %*

SET PATH=%OLD_PATH%

goto END
:ERROR_MINIMUM_JAVA_VERSION
	echo ERROR: cannot start GBOOST GUI.
	echo Please validate if Java Runtime Environment (Version: %MinimumRequiredJavaVersion%) is installed.
	echo You may get the latest version of Java at http://java.sun.com/javase/downloads/index.jsp
	pause
	goto END
:END
IF EXIST java_version.txt DEL java_version.txt