package gboost_gui.ToolPanel;

import Data.BOOST.BOOSTResultFile;
import Data.BOOST.BOOSTResultItem;
import Data.BOOST.Comparator.BOOSTResultItemComparator;
import gboost_gui.RuntimeVariables;
import info.clearthought.layout.TableLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.ListSelectionModel;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

/**
 *
 * @author timyung
 */
public class RawDataToolPanel extends JPanel implements ActionListener {

    public enum SORT_ORDER {
        SNPNAME1,
        SNPNAME2,
        BOOSTVALUE
    }

    private BOOSTResultFile parentFile = null;

    private List<BOOSTResultItem> filteredItemList = null;

    private JTextField currFilenameTextField = new JTextField();

    private JTextField filterValueTextfield = new JTextField();

    private JButton setFilterValueButton = null;

    private JTextField currNumberOfRawDataRecord = new JTextField();

    private JPanel dataListPanel = null;

    private JList dataList = null;

    private JRadioButton snpName1RadioButton = null;
    private JRadioButton snpName2RadioButton = null;
    private JRadioButton boostValueRadioButton = null;

    private JTextField selectNumTextField = new JTextField();
    private JButton selectNumButton = null;

    private JButton selectHighlightedButton = null;
    private JButton deselectHighlightedButton = null;
    private JButton selectAllButton = null;
    private JButton deselectAllButton = null;

    private JTextField searchTextField = new JTextField();
    private JButton searchButton = null;

    private JButton resetListSelectionButton = null;

    private JButton updateGraphButton = null;

    public RawDataToolPanel() {
        super();

        // table layout size
        double tableLayoutBorderSize = 10;
        int tableLayoutVGap = 2, tableLayoutHGap = 5;
        TableLayout tableLayout = null;
        int rowIndex = 0;

        // title border variable
        Border loweredetched = BorderFactory.createEtchedBorder(EtchedBorder.LOWERED);
        TitledBorder titleBorder = null;

        currFilenameTextField.setEditable(false);

        filterValueTextfield.setText(Double.toString(RuntimeVariables.RawDataFilterValue));
        setFilterValueButton = new JButton("Set");
        setFilterValueButton.addActionListener(this);

        setSelectedCount();
        currNumberOfRawDataRecord.setEditable(false);

        dataList = new JList();
        dataList.setModel(new DefaultListModel());
        dataList.setCellRenderer(new BOOSTResultItemListCellRenderer());
        dataList.setSelectionMode(ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);
        JScrollPane dataListScrollPane = new JScrollPane(dataList);
        dataListPanel = new JPanel();
        dataListPanel.setLayout(new BorderLayout());
        dataListPanel.add(dataListScrollPane, BorderLayout.CENTER);
        titleBorder = BorderFactory.createTitledBorder(loweredetched, "Data List");
        titleBorder.setTitleJustification(TitledBorder.LEFT);
        dataListPanel.setBorder(titleBorder);

        ButtonGroup sortByButtonGroup = new ButtonGroup();
        snpName1RadioButton = new JRadioButton("snpName1");
        snpName1RadioButton.addActionListener(this);
        snpName2RadioButton = new JRadioButton("snpName2");
        snpName2RadioButton.addActionListener(this);
        boostValueRadioButton = new JRadioButton("Boost value");
        boostValueRadioButton.addActionListener(this);
        sortByButtonGroup.add(snpName1RadioButton);
        sortByButtonGroup.add(snpName2RadioButton);
        sortByButtonGroup.add(boostValueRadioButton);

        switch( RuntimeVariables.RawDataSortOrder ) {
            case SNPNAME1:
                snpName1RadioButton.setSelected(true);
                break;
            case SNPNAME2:
                snpName2RadioButton.setSelected(true);
                break;
            case BOOSTVALUE:
                boostValueRadioButton.setSelected(true);
                break;
            default:
        }

        selectNumTextField.setText(Integer.toString(RuntimeVariables.SelectCount));
        selectNumButton = new JButton("Set");
        selectNumButton.addActionListener(this);

        selectHighlightedButton = new JButton("Select");
        selectHighlightedButton.addActionListener(this);
        deselectHighlightedButton = new JButton("Deselet");
        deselectHighlightedButton.addActionListener(this);
        selectAllButton = new JButton("Select All");
        selectAllButton.addActionListener(this);
        deselectAllButton = new JButton("Deselect All");
        deselectAllButton.addActionListener(this);

        resetListSelectionButton = new JButton("Reset");
        resetListSelectionButton.addActionListener(this);
        updateGraphButton = new JButton("Update");
        updateGraphButton.addActionListener(this);

        searchButton = new JButton("Search");
        searchButton.addActionListener(this);

        tableLayout = new TableLayout(
                new double[]{tableLayoutBorderSize, 0.37, 0.13, 0.13, 0.37, tableLayoutBorderSize},
                new double[]{0}
                );
        tableLayout.setHGap(tableLayoutHGap);
        tableLayout.setVGap(tableLayoutVGap);
        this.setLayout(tableLayout);
        rowIndex = 0;
        tableLayout.insertRow(++rowIndex, TableLayout.PREFERRED);
        tableLayout.insertRow(++rowIndex, TableLayout.PREFERRED);
        tableLayout.insertRow(++rowIndex, TableLayout.PREFERRED);
        tableLayout.insertRow(++rowIndex, TableLayout.FILL);
        tableLayout.insertRow(++rowIndex, TableLayout.PREFERRED);
        tableLayout.insertRow(++rowIndex, TableLayout.PREFERRED);
        tableLayout.insertRow(++rowIndex, TableLayout.PREFERRED);
        tableLayout.insertRow(++rowIndex, TableLayout.PREFERRED);
        tableLayout.insertRow(++rowIndex, TableLayout.PREFERRED);
        tableLayout.insertRow(++rowIndex, TableLayout.PREFERRED);
        tableLayout.insertRow(++rowIndex, TableLayout.PREFERRED);
        tableLayout.insertRow(++rowIndex, TableLayout.PREFERRED);

        this.add(new JLabel("Filename : "), "1,1");
        this.add(currFilenameTextField, "2,1,4,1");
        this.add(new JLabel("Filter value : "), "1,2");
        this.add(filterValueTextfield, "2,2,3,2");
        this.add(setFilterValueButton, "4,2");
        this.add(new JLabel("Count : "),"1,3");
        this.add(currNumberOfRawDataRecord, "2,3,4,3");
        this.add(dataListPanel, "1,4,4,4");
        
        this.add(new JLabel("Sort by : "), "1,5");
        this.add(snpName1RadioButton, "2,5, 4,5");
        this.add(snpName2RadioButton, "2,6,4,6");
        this.add(boostValueRadioButton, "2,7,4,7");

        this.add(new JLabel("Select Top : "), "1,8");
        this.add(selectNumTextField, "2,8,3,8");
        this.add(selectNumButton, "4,8");

        this.add(selectHighlightedButton, "1,9,2,9");
        this.add(deselectHighlightedButton, "3,9,4,9");
        this.add(selectAllButton, "1,10,2,10");
        this.add(deselectAllButton, "3,10,4,10");

        this.add(searchTextField, "1,11,3,11");
        this.add(searchButton, "4,11");

        this.add(resetListSelectionButton, "1,12,2,12");
        this.add(updateGraphButton, "3,12,4,12");

        // Disable all components
        for ( Component c : this.getComponents() ) {
            c.setEnabled(false);
        }
        dataList.setEnabled(false);
    }

    public BOOSTResultFile getFile() {
        return parentFile;
    }

    public void setFile(BOOSTResultFile file) {
        if ( file != null ) {
//            // Enable options
//            filterValueTextfield.setEnabled(true);
//            dataListPanel.setEnabled(true);
//            setFilterValueButton.setEnabled(true);
//            resetListSelectionButton.setEnabled(true);
//            updateGraphButton.setEnabled(true);
        
            this.parentFile = file;
            currFilenameTextField.setText(file.getBOOSTResultFilename());
            filteredItemList = parentFile.getFilteredResultItemList(RuntimeVariables.RawDataFilterValue);
            setSelectedCount();

            sortDataList(RuntimeVariables.RawDataSortOrder, true);

            // Enable all components
            for ( Component c : this.getComponents() ) {
                c.setEnabled(true);
            }
            dataList.setEnabled(true);
        }
    }

    public void resetDataList() {
        // Reset selected item
        if ( filteredItemList != null ) {
            selectListItem(filteredItemList.size(), false);
            setSelectedCount();

            boostValueRadioButton.setSelected(true);
            RuntimeVariables.RawDataSortOrder = SORT_ORDER.BOOSTVALUE;
            sortDataList(SORT_ORDER.BOOSTVALUE, true);
            searchTextField.setText("");
            RuntimeVariables.SelectCount = 50;
            selectNumTextField.setText("50");
        }
        if ( dataList != null ) {
            dataList.clearSelection();
        }
    }

    protected void setSelectedCount() {
        if ( filteredItemList != null ) {
            int selectedCount = 0;
            for ( BOOSTResultItem item : filteredItemList ) {
                if ( item.selected ) {
                    selectedCount++;
                }
            }
            currNumberOfRawDataRecord.setText(selectedCount+ " / " + filteredItemList.size());
        }
        else {
            currNumberOfRawDataRecord.setText("0 / 0");
        }
    }

    protected void updateThresholdValue(double value) {
        if ( parentFile != null ) {
            if ( filteredItemList != null ) {
                // Reset select in old file first
                for ( BOOSTResultItem item : filteredItemList) {
                    item.selected = false;
                }
            }

            filteredItemList = parentFile.getFilteredResultItemList(RuntimeVariables.RawDataFilterValue);
            setSelectedCount();

            sortDataList(RuntimeVariables.RawDataSortOrder, true);
        }
    }

    protected void sortDataList(SORT_ORDER sortOrder, boolean addToDataList) {
        if ( filteredItemList != null ) {
            //DefaultListModel listModel = new DefaultListModel();
            BOOSTResultItemComparator comparator = null;
            switch ( sortOrder ) {
                case SNPNAME1:
                    comparator = new BOOSTResultItemComparator(BOOSTResultItemComparator.SNPNAME1);
                    break;
                case SNPNAME2:
                    comparator = new BOOSTResultItemComparator(BOOSTResultItemComparator.SNPNAME2);
                    break;
                case BOOSTVALUE:
                    comparator = new BOOSTResultItemComparator(BOOSTResultItemComparator.BOOSTVALUE);
                    break;
                default:

            }

            Collections.sort(filteredItemList, comparator);
            if ( sortOrder == SORT_ORDER.BOOSTVALUE ) {
                // Reverse and Sort in descending order
                Collections.reverse(filteredItemList);
            }
            
            if ( addToDataList ) {
                DefaultListModel listModel = new DefaultListModel();
                for ( BOOSTResultItem item : filteredItemList ) {
                    listModel.addElement(item);
                }
                dataList.setModel(listModel);
            }
        }

    }

    protected void selectHighlightedListItem(boolean select) {
        if ( dataList != null ) {
            int[] selectedIndices = dataList.getSelectedIndices();
            for ( int index : selectedIndices ) {
                filteredItemList.get(index).selected = select;
            }
            setSelectedCount();
            dataListPanel.repaint();
        }
    }

    protected void selectListItem(int count, boolean select) {
        if ( filteredItemList != null ) {
            int selectCount = Math.min(filteredItemList.size(), count);
            for ( int i = 0; i < selectCount; i++ ) {
                filteredItemList.get(i).selected = select;
            }
            setSelectedCount();
            dataListPanel.repaint();
        }
    }

    protected boolean searchListItem(String searchString) {
        if ( filteredItemList != null ) {
            if ( dataList != null ) {
                int startIndex = 0;
                int[] indices = dataList.getSelectedIndices();
                if ( indices.length != 0 ) {
                    dataList.clearSelection();
                    startIndex = indices[0]+1;
                }
                else {
                    startIndex = 0;
                }
                for ( int i = startIndex; i < filteredItemList.size(); i++ ) {
                    if ( filteredItemList.get(i).toString().contains(searchString) ) {
                        dataList.setSelectedIndex(i);
                        dataList.ensureIndexIsVisible(i);
                        return true;
                    }
                }
            }
        }
        return false;
    }

    protected List<BOOSTResultItem> getSelectedItemList() {
        if ( filteredItemList != null ) {
            List<BOOSTResultItem> itemList = new Vector<BOOSTResultItem>();
            for ( BOOSTResultItem item : filteredItemList ) {
                if ( item.selected ) {
                    itemList.add(item);
                }
            }
            return itemList;
        }
        else {
            return null;
        }
    }

    public void actionPerformed(ActionEvent e) {
        AbstractButton source = (AbstractButton) e.getSource();

        if ( source == setFilterValueButton ) {
            try {
                double value = Double.parseDouble(filterValueTextfield.getText());
                RuntimeVariables.RawDataFilterValue = value;
                updateThresholdValue(value);
            }
            catch (NumberFormatException ex) {
                JOptionPane.showMessageDialog(null, "Unable to parse the filter value!", "Error Messages", JOptionPane.ERROR_MESSAGE);
                filterValueTextfield.setText(Double.toString(RuntimeVariables.RawDataFilterValue));
            }
        }
        else if ( source == snpName1RadioButton ) {
            if ( source.isSelected() ) {
                sortDataList(SORT_ORDER.SNPNAME1, true);
                RuntimeVariables.RawDataSortOrder = SORT_ORDER.SNPNAME1;
            }
        }
        else if ( source == snpName2RadioButton ) {
            if ( source.isSelected() ) {
                sortDataList(SORT_ORDER.SNPNAME2, true);
                RuntimeVariables.RawDataSortOrder = SORT_ORDER.SNPNAME2;
            }
        }
        else if ( source == boostValueRadioButton ) {
            if ( source.isSelected() ) {
                sortDataList(SORT_ORDER.BOOSTVALUE, true);
                RuntimeVariables.RawDataSortOrder = SORT_ORDER.BOOSTVALUE;
            }
        }
        else if ( source == selectNumButton ) {
            try {
                int value = Integer.parseInt(selectNumTextField.getText());
                RuntimeVariables.SelectCount = value;
                selectListItem(value, true);
            }
            catch (NumberFormatException ex) {
                JOptionPane.showMessageDialog(null, "Unable to parse the select num!", "Error Messages", JOptionPane.ERROR_MESSAGE);
                filterValueTextfield.setText(Double.toString(RuntimeVariables.RawDataFilterValue));
            }
        }
        else if ( source == selectHighlightedButton ) {
            selectHighlightedListItem(true);
        }
        else if ( source == deselectHighlightedButton ) {
            selectHighlightedListItem(false);
        }
        else if ( source == selectAllButton ) {
            if ( filteredItemList != null ) {
                selectListItem(filteredItemList.size(), true);
            }
        }
        else if ( source == deselectAllButton ) {
            if ( filteredItemList != null ) {
                selectListItem(filteredItemList.size(), false);
            }
        }
        else if ( source == searchButton ) {
            if ( !searchListItem(searchTextField.getText()) ) {
                JOptionPane.showMessageDialog(null, "Unable to find the string!","Information Messages", JOptionPane.INFORMATION_MESSAGE);
            }
        }
        else if ( source == resetListSelectionButton ) {
            resetDataList();
        }
        else if ( source == updateGraphButton ) {
            RuntimeVariables.PathwayGraphPanel.setGraph(getSelectedItemList());
        }
    }

    private class BOOSTResultItemListCellRenderer extends DefaultListCellRenderer implements ListCellRenderer {

        // This is the only method defined by ListCellRenderer.
        // We just reconfigure the JLabel each time we're called.

        @Override
        public Component getListCellRendererComponent(
            JList list,              // the list
            Object value,            // value to display
            int index,               // cell index
            boolean isSelected,      // is the cell selected
            boolean cellHasFocus)    // does the cell have focus
        {
            BOOSTResultItem item = (BOOSTResultItem) value;

            if ( item.selected ) {
                Component component = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                if ( isSelected ) {
                    setBackground(java.awt.Color.GRAY);
                    setForeground(list.getSelectionForeground());
                }
                else {
                    setBackground(java.awt.Color.LIGHT_GRAY);
                    setForeground(list.getForeground());
                }
                return component;
            }
            else {
                return super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            }
        }
    }

}
