package gboost_gui;

import Data.SNPPathWayDataFile;
import Graph.GraphPanel;
import Graph.Tool.GraphNodePropertyPanel;
import Graph.Tool.GraphOptionPanel;
import Plot.MarginalAssociationChartPanel;
import Utility.Magnifier.MagnifierAction;
import Utility.MemoryUsage.MemoryMonitorDockableDescriptor;
import gboost_gui.Dialog.GBOOSTTaskDialog;
import gboost_gui.ToolPanel.RawDataToolPanel;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.OceanTheme;
import org.noos.xing.mydoggy.AggregationPosition;
import org.noos.xing.mydoggy.Content;
import org.noos.xing.mydoggy.ContentManager;
import org.noos.xing.mydoggy.ContentManagerUIListener;
import org.noos.xing.mydoggy.DockedTypeDescriptor;
import org.noos.xing.mydoggy.MultiSplitConstraint;
import org.noos.xing.mydoggy.MultiSplitContentManagerUI;
import org.noos.xing.mydoggy.TabbedContentManagerUI;
import org.noos.xing.mydoggy.TabbedContentUI;
import org.noos.xing.mydoggy.ToolWindow;
import org.noos.xing.mydoggy.ToolWindowAnchor;
import org.noos.xing.mydoggy.ToolWindowGroup;
import org.noos.xing.mydoggy.ToolWindowType;
import org.noos.xing.mydoggy.event.ContentManagerUIEvent;
import org.noos.xing.mydoggy.plaf.MyDoggyToolWindowManager;
import org.noos.xing.mydoggy.plaf.ui.DockableDescriptor;
import org.noos.xing.mydoggy.plaf.ui.cmp.ExtendedTableLayout;
import org.noos.xing.mydoggy.plaf.ui.content.MyDoggyMultiSplitContentManagerUI;

/**
 *
 * @author timyung
 */
public class Main {

    private static MainFrame mainFrame = null;

    private static void createGui() {
        try {
	    // Set cross-platform Java L&F (also called "Metal")
            UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
            MetalLookAndFeel.setCurrentTheme(new OceanTheme());
        }
        catch (UnsupportedLookAndFeelException e) {
           // handle exception
        }
        catch (ClassNotFoundException e) {
           // handle exception
        }
        catch (InstantiationException e) {
           // handle exception
        }
        catch (IllegalAccessException e) {
           // handle exception
        }

        mainFrame = new MainFrame();
        mainFrame.setSize(new Dimension(1024,768));
        mainFrame.setLocationRelativeTo(null);
        mainFrame.setVisible(true);
    }

    protected static void initRuntimeVariables(MainFrame programMainFrame) {
        RuntimeVariables.ProgramMainFrame = programMainFrame;
        RuntimeVariables.RawDataPanel = programMainFrame.getRawDataToolPanel();
        RuntimeVariables.PathwayGraphPanel = programMainFrame.getPathwayGraphPanel();
        RuntimeVariables.NodePropertyPanel = programMainFrame.getNodePropertyPanel();
        RuntimeVariables.MarginalAssoicationPanel = programMainFrame.getMarginalAssoicationChartPanel();
        RuntimeVariables.snpPathWayDataFile = new SNPPathWayDataFile(Configuration.SNP_PATHWAY_FILE_PATH);
    }

    public static void main(String[] args) throws Exception {
        Main.createGui();
        initRuntimeVariables(mainFrame);
//        BOOSTResultFile file = new BOOSTResultFile(
//                "C:\\Documents and Settings\\timyung\\Desktop\\TestFolder\\outputInteractionRecords.txt",
//                "C:\\Documents and Settings\\timyung\\Desktop\\TestFolder\\filenamelist.txt");
//        //RuntimeVariables.PathwayGraphPanel.setGraph(file);
//        RuntimeVariables.RawDataPanel.setFile(file);
//        RuntimeVariables.MarginalAssoicationPanel.setMarginalAssociationPlot(
//                new BOOSTMarginalAssociationFile(
//                "C:\\Documents and Settings\\timyung\\Desktop\\TestFolder\\outputMarginalAssociation.txt",
//                "C:\\Documents and Settings\\timyung\\Desktop\\TestFolder\\filenamelist.txt"
//                ));

        
//        SwingUtilities.invokeLater(new Runnable() {
//            public void run() {
//
//            }
//        });
    }

}

class MainFrame extends JFrame implements ContentManagerUIListener {

    private JFrame framePointer = null;

    private ContentManager contentManager = null;

    private MyDoggyToolWindowManager toolWindowManager = null;

    private JPanel toolWindowPanel = null;

    private GraphPanel graphPanel = null;

    private MarginalAssociationChartPanel marginalAssociationChartPanel = null;

    private RawDataToolPanel rawDataToolPanel = null;

    private GraphNodePropertyPanel nodePropertyPanel = null;

    private GraphOptionPanel graphOptionPanel = null;

    public MainFrame() {
        super("GBoost GUI");
        framePointer = this;

        initMenuBar();

        initToolWindowPanel();
        contentManager = toolWindowManager.getContentManager();
        initContentManager();

        this.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        this.setLocationRelativeTo(null);
        this.getContentPane().add(toolWindowPanel);
        this.pack();
    }

    protected void initMenuBar() {
        JMenuBar programMenu = new JMenuBar();

        // File
        JMenu fileMenu = new JMenu("File");
        JMenuItem newGBOOSTTaskItem = new JMenuItem("New GBOOST task / Import BOOST result file...");
        newGBOOSTTaskItem.addActionListener(new ActionListener() {

            public void actionPerformed(ActionEvent e) {
                GBOOSTTaskDialog taskDialog = new GBOOSTTaskDialog();
            }

        });

        JMenuItem savePathwayGraph = new JMenuItem("Save Pathway Graph to bmp...");
        savePathwayGraph.addActionListener( new ActionListener() {

            public void actionPerformed(ActionEvent e) {
                JFileChooser fc = new JFileChooser();
                int returnVal = fc.showSaveDialog(null);

                if (returnVal == JFileChooser.APPROVE_OPTION) {
                    File file = fc.getSelectedFile();

                    int result = RuntimeVariables.PathwayGraphPanel.writeImage(file.getAbsolutePath(), "bmp");
                    if ( result == -1 ) {
                        JOptionPane.showMessageDialog(null, "Unable to save the Pathway Graph.", "Error Message", JOptionPane.ERROR_MESSAGE);
                    }
                    else {
                        JOptionPane.showMessageDialog(null, "Save Pathway Graph to " + file.getAbsolutePath(), "Info Message", JOptionPane.INFORMATION_MESSAGE);
                    }
                }
            }

        });

        JMenuItem saveMarginalAssociationPlot = new JMenuItem("Save Marginal Assoication Plot to bmp...");
        saveMarginalAssociationPlot.addActionListener(new ActionListener() {

            public void actionPerformed(ActionEvent e) {
                JFileChooser fc = new JFileChooser();
                int returnVal = fc.showSaveDialog(null);

                if (returnVal == JFileChooser.APPROVE_OPTION) {
                    File file = fc.getSelectedFile();

                    int result = RuntimeVariables.MarginalAssoicationPanel.writeImage(file.getAbsolutePath(), "bmp");
                    if ( result == -1 ) {
                        JOptionPane.showMessageDialog(null, "Unable to save the Marginal Assoication Plot.", "Error Message", JOptionPane.ERROR_MESSAGE);
                    }
                    else {
                        JOptionPane.showMessageDialog(null, "Save Marginal Assoication Plot to " + file.getAbsolutePath(), "Info Message", JOptionPane.INFORMATION_MESSAGE);
                    }
                }
            }

        });


        JMenuItem exitItem = new JMenuItem("Exit");
        exitItem.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                int result = JOptionPane.showConfirmDialog(framePointer, "Confirm to leave", "Exit...", JOptionPane.INFORMATION_MESSAGE);
                if ( result == JOptionPane.YES_OPTION ) {
                    System.exit(0);
                }
            }
        });

        // Add menu-items for file menu
        fileMenu.add(newGBOOSTTaskItem);
        fileMenu.add(savePathwayGraph);
        fileMenu.add(saveMarginalAssociationPlot);
        fileMenu.add(exitItem);
        
        // Mode
        JMenu toolMenu = new JMenu("Tool");
        MagnifierAction magnifier = new MagnifierAction(this);
        toolMenu.add(magnifier);
        
        // Add all menu items to the menu bar
        programMenu.add(fileMenu);
        programMenu.add(toolMenu);
        this.setJMenuBar(programMenu);
    }

    protected void initToolWindowPanel() {
        toolWindowManager = new MyDoggyToolWindowManager();
        toolWindowPanel = new JPanel();
        toolWindowPanel.setLayout(new ExtendedTableLayout(new double[][]{{0, -1, 0}, {0, -1, 0}}));
        toolWindowPanel.add(toolWindowManager, "1,1,");
        // Create main tool window group
        ToolWindowGroup mainGroup = toolWindowManager.getToolWindowGroup("main");

        //Usage: build a tool window
        //ToolWindow toolWindow = registerToolWindow(
        //        KEY,
        //        TITLE,
        //        ICON,
        //        COMPONENT,
        //        ANCHOR);

        // Register Dockable Raw Data Tool Panel
        rawDataToolPanel = new RawDataToolPanel();
        ToolWindow rawDataToolWindow = toolWindowManager.registerToolWindow(
                "DataToolWindow",
                "Data Tool Window",
                null,
                rawDataToolPanel,
                ToolWindowAnchor.LEFT
                );
        
        // Register Dockable Node Property Panel
        nodePropertyPanel = new GraphNodePropertyPanel();
        ToolWindow nodePropertyToolWindow = toolWindowManager.registerToolWindow(
                "NodeProperty",
                "Node Property",
                null,
                nodePropertyPanel,
                ToolWindowAnchor.RIGHT
                );
        RuntimeVariables.NodePropertyPanel = nodePropertyPanel;

        graphOptionPanel = new GraphOptionPanel();
        ToolWindow graphOptionToolWindow = toolWindowManager.registerToolWindow(
                "PathwayGraphOption",
                "Pathway Graph Option",
                null,
                graphOptionPanel,
                ToolWindowAnchor.RIGHT);

        // Register Dockable Memory Descriptor
        DockableDescriptor memoryMonitorDescriptor = new MemoryMonitorDockableDescriptor(toolWindowManager, ToolWindowAnchor.BOTTOM);
        memoryMonitorDescriptor.setAvailable(true);

        // Made all tools available and set their docked length
        for (ToolWindow window : toolWindowManager.getToolWindows()) {
            window.setAvailable(true);
            window.setType(ToolWindowType.DOCKED);
            ((DockedTypeDescriptor)window.getTypeDescriptor(ToolWindowType.DOCKED)).setDockLength(Configuration.DockedLength);
        }
    }

    /**
     * Initializes settings for content manager.
     */
    protected void initContentManager() {
        MultiSplitContentManagerUI contentManagerUI = new MyDoggyMultiSplitContentManagerUI();
        contentManager.setContentManagerUI(contentManagerUI);
        contentManagerUI.setShowAlwaysTab(true);
        contentManagerUI.setTabPlacement(TabbedContentManagerUI.TabPlacement.TOP);
        contentManagerUI.addContentManagerUIListener(this);

         try {
            graphPanel = new GraphPanel();
        } catch (SQLException ex) {
            Logger.getLogger(MainFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
        Content graphPanelContent = contentManager.addContent("PathwayGraph",
                                  "PathwayGraph",
                                  null,           // An icon
                                  graphPanel,
                                  null,
                                  new MultiSplitConstraint(AggregationPosition.DEFAULT)
                                  );

        marginalAssociationChartPanel = new MarginalAssociationChartPanel();
        contentManager.addContent("Marginal Association Chart",
                                  "Marginal Association Chart",
                                  null,           // An icon
                                  marginalAssociationChartPanel,
                                  null,
                                  new MultiSplitConstraint(graphPanelContent)
                                  );


        TabbedContentUI contentUI = contentManagerUI.getContentUI(contentManager.getContent(0));

        // For graph panel
        contentUI.setCloseable(false);
        contentUI.setDetachable(true);
        contentUI.setTransparentMode(true);
        contentUI.setTransparentRatio(0.7f);
        contentUI.setTransparentDelay(1000);

        // For Maginal assoication chart
        contentUI = contentManagerUI.getContentUI(contentManager.getContent(1));
        contentUI.setCloseable(false);
        contentUI.setDetachable(true);
        contentUI.setTransparentMode(true);
        contentUI.setTransparentRatio(0.7f);
        contentUI.setTransparentDelay(1000);
    }

    public boolean contentUIRemoving(ContentManagerUIEvent event) {
        return JOptionPane.showConfirmDialog(this, "Are you sure?") == JOptionPane.OK_OPTION;
    }

    public void contentUIDetached(ContentManagerUIEvent event) {
    }

    public RawDataToolPanel getRawDataToolPanel() {
        return rawDataToolPanel;
    }

    public GraphPanel getPathwayGraphPanel() {
        return graphPanel;
    }

    public GraphNodePropertyPanel getNodePropertyPanel() {
        return nodePropertyPanel;
    }

    public MarginalAssociationChartPanel getMarginalAssoicationChartPanel() {
        return marginalAssociationChartPanel;
    }



}