package gboost_gui.Dialog;

import Data.BOOST.BOOSTMarginalAssociationFile;
import Data.BOOST.BOOSTResultFile;
import Utility.Process.ProcessLauncher;
import gboost_gui.Configuration;
import gboost_gui.RuntimeVariables;
import info.clearthought.layout.TableLayout;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

/**
 *
 * @author timyung
 */
public class GBOOSTTaskDialog extends JDialog implements ActionListener {

    static final public String OPEN_INPUT_FILE_COMMAND = "OPEN_INPUT_FILE";

    static final public String EXECUTE_GBOOST_TASK_COMMAND = "EXECUTE_GBOOST";

    static final public String IMPORT_BOOST_FILE_COMMAND = "IMPORT_FILE";

    private TableLayout dialogTableLayout = null;

    private JPanel optionPanel = null;

    private JPanel programOptionPanel = null;
    private JTextField thresholdTextField = new JTextField(Double.toString(Configuration.GBOOST_Threshold));

    private JPanel infoPanel = null;

    private JPanel workModePanel = null;
    private JRadioButton cpuRadioButton = new JRadioButton("CPU");
    private JRadioButton gpuJRadioButton = new JRadioButton("GPU");

    private JPanel fileOptionPanel = null;
    private JTextField inputFilePath = new JTextField();
    private JTextField outputFilePath = new JTextField();
    private JTextField outputPrefix = new JTextField("output_");

    private JPanel logPanel = null;
    private JTextArea logTextArea = null;

    private JProgressBar progressBar = null;

    private JButton importButton = new JButton("Import");
    private JButton executeButton = new JButton("Execute");

    private ProcessLauncher launcher = null;

    public GBOOSTTaskDialog() {
        super(new JFrame(), "New GBOOST Task...", true);
        
        // table layout size
        double tableLayoutBorderSize = 10;
        double tableLayoutFillSize = TableLayout.FILL;
        double tableLayoutPreferredSize = TableLayout.PREFERRED;
        double tableLayoutVGap = 2;
        double tableLayoutHGap = 5;
        double tableLayoutEmptySpace = 10;
        TableLayout tableLayout = null;
        int rowIndex = 0;

        // title border variable
        Border loweredetched = BorderFactory.createEtchedBorder(EtchedBorder.LOWERED);
        TitledBorder titleBorder = null;

        // initialize system information panel
        infoPanel = new JPanel();
        tableLayout = new TableLayout(
                new double[]{tableLayoutBorderSize, TableLayout.FILL, tableLayoutBorderSize},
                new double[]{0}
                );
        infoPanel.setLayout(tableLayout);
        rowIndex = 0;
        tableLayout.insertRow(++rowIndex, tableLayoutPreferredSize);
        tableLayout.insertRow(++rowIndex, tableLayoutPreferredSize);
        infoPanel.add(new JLabel("Operating System : " + System.getProperty("os.name")), "1,1");
        infoPanel.add(new JLabel("Architecture : " + System.getProperty("os.arch")), "1,2");

        titleBorder = BorderFactory.createTitledBorder(loweredetched, "System Information");
        titleBorder.setTitleJustification(TitledBorder.LEFT);
        infoPanel.setBorder(titleBorder);

        // initialize work mode panel
        workModePanel = new JPanel();
        ButtonGroup workModeButtonGroup = new ButtonGroup();
        workModeButtonGroup.add(cpuRadioButton);
        workModeButtonGroup.add(gpuJRadioButton);
        cpuRadioButton.setSelected(true);
        tableLayout = new TableLayout(
                new double[]{tableLayoutBorderSize, 1.0 / 3.0, 1.0 / 3.0, TableLayout.FILL, tableLayoutBorderSize},
                new double[]{0}
                );
        workModePanel.setLayout(tableLayout);
        rowIndex = 0;
        tableLayout.insertRow(++rowIndex, tableLayoutPreferredSize);
        workModePanel.add(cpuRadioButton, "1, 1");
        workModePanel.add(gpuJRadioButton, "2, 1");

        titleBorder = BorderFactory.createTitledBorder(loweredetched, "Work Mode");
        titleBorder.setTitleJustification(TitledBorder.LEFT);
        workModePanel.setBorder(titleBorder);

        // initialize file option panel
        fileOptionPanel = new JPanel();
        JButton inputFileOpenButton = new JButton("Open");
        inputFileOpenButton.setActionCommand(OPEN_INPUT_FILE_COMMAND);
        inputFileOpenButton.addActionListener(this);
        inputFilePath.setEditable(false);
        outputFilePath.setEditable(false);

        tableLayout = new TableLayout(
                new double[]{tableLayoutBorderSize, 1.0 / 5.0, TableLayout.FILL, 1.0 / 5.0, tableLayoutBorderSize},
                new double[]{0}
                );
        fileOptionPanel.setLayout(tableLayout);
        rowIndex = 0;
        tableLayout.insertRow(++rowIndex, tableLayoutPreferredSize);
        tableLayout.insertRow(++rowIndex, tableLayoutPreferredSize);
        tableLayout.insertRow(++rowIndex, tableLayoutPreferredSize);

        fileOptionPanel.add(new JLabel("Input List File : "), "1, 1");
        fileOptionPanel.add(inputFilePath, "2, 1");
        fileOptionPanel.add(inputFileOpenButton, "3, 1");

        fileOptionPanel.add(new JLabel("Output File Path : "), "1, 2");
        fileOptionPanel.add(outputFilePath, "2, 2");

        fileOptionPanel.add(new JLabel("Output File Prefix : "), "1, 3");
        fileOptionPanel.add(outputPrefix, "2, 3");

        titleBorder = BorderFactory.createTitledBorder(loweredetched, "File Option");
        titleBorder.setTitleJustification(TitledBorder.LEFT);
        fileOptionPanel.setBorder(titleBorder);

        // initlalize program option panel
        programOptionPanel = new JPanel();
        tableLayout = new TableLayout(
                new double[]{tableLayoutBorderSize, 1.0 / 5.0, 1.0 / 5.0, TableLayout.FILL, tableLayoutBorderSize},
                new double[]{0}
                );
        programOptionPanel.setLayout(tableLayout);
        rowIndex = 0;
        tableLayout.insertRow(++rowIndex, tableLayoutPreferredSize);
        programOptionPanel.add(new JLabel("Threshold : "), "1,1");
        programOptionPanel.add(thresholdTextField, "2,1");
        titleBorder = BorderFactory.createTitledBorder(loweredetched, "GBOOST Program Option");
        titleBorder.setTitleJustification(TitledBorder.LEFT);
        programOptionPanel.setBorder(titleBorder);

        // initialize log panel
        logPanel = new JPanel();
        logTextArea = new JTextArea();
        logTextArea.setEditable(false);
        logTextArea.setColumns(60);
        logTextArea.setLineWrap(true);
        JScrollPane logScrollPane = new JScrollPane(logTextArea);
        progressBar = new JProgressBar(0, 100);
        progressBar.setValue(0);
        progressBar.setStringPainted(true);
        tableLayout = new TableLayout(
                new double[]{tableLayoutBorderSize, 1.0 / 5.0, TableLayout.FILL, tableLayoutBorderSize},
                new double[]{0}
                );
        logPanel.setLayout(tableLayout);
        rowIndex = 0;
        tableLayout.insertRow(++rowIndex, tableLayoutFillSize);
        tableLayout.insertRow(++rowIndex, tableLayoutPreferredSize);
        logPanel.add(logScrollPane, "1, 1, 2, 1");
        logPanel.add(new JLabel("Progress"), "1, 2");
        logPanel.add(progressBar, "2, 2");
        titleBorder = BorderFactory.createTitledBorder(loweredetched, "GBOOST Program Log");
        titleBorder.setTitleJustification(TitledBorder.LEFT);
        logPanel.setBorder(titleBorder);
        
        // Create the option panel and set up the table layout
        optionPanel = new JPanel();
        dialogTableLayout = new TableLayout(
                new double[]{tableLayoutBorderSize,TableLayout.FILL,tableLayoutBorderSize},
                new double[]{0}
                );
        optionPanel.setLayout(dialogTableLayout);
        rowIndex = 0;
        dialogTableLayout.insertRow(++rowIndex, tableLayoutPreferredSize);
        dialogTableLayout.insertRow(++rowIndex, tableLayoutPreferredSize);
        dialogTableLayout.insertRow(++rowIndex, tableLayoutPreferredSize);
        dialogTableLayout.insertRow(++rowIndex, tableLayoutPreferredSize);
        dialogTableLayout.insertRow(++rowIndex, tableLayoutFillSize);
        optionPanel.add(infoPanel, "1,1");
        optionPanel.add(workModePanel, "1,2");
        optionPanel.add(fileOptionPanel, "1,3");
        optionPanel.add(programOptionPanel, "1,4");
        optionPanel.add(logPanel, "1,5");

        // initialize execute panel
        JPanel executePanel = new JPanel();
        tableLayout = new TableLayout(
                new double[]{tableLayoutBorderSize, TableLayout.FILL, 1/5.0, 1.0 / 5.0, tableLayoutBorderSize},
                new double[]{0}
                );
        executePanel.setLayout(tableLayout);
        importButton.setActionCommand(IMPORT_BOOST_FILE_COMMAND);
        importButton.addActionListener(this);
        executeButton.setActionCommand(EXECUTE_GBOOST_TASK_COMMAND);
        executeButton.addActionListener(this);
        rowIndex = 0;
        tableLayout.insertRow(++rowIndex, tableLayoutPreferredSize);
        executePanel.add(importButton, "2,1");
        executePanel.add(executeButton, "3,1");

        // Create the main panel, set the frame size and display the frame
        this.setSize(new Dimension(640,480));
        this.setLayout(new BorderLayout());
        this.add(optionPanel, BorderLayout.CENTER);
        this.add(executePanel, BorderLayout.SOUTH);
        this.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();

        if ( OPEN_INPUT_FILE_COMMAND.equals(command) ) {
            JFileChooser fc = new JFileChooser();

            int returnVal = fc.showOpenDialog(null);
            if (returnVal == JFileChooser.APPROVE_OPTION) {
                inputFilePath.setText(fc.getSelectedFile().getAbsolutePath());
                outputFilePath.setText(fc.getCurrentDirectory().getAbsolutePath());
            }
        }
        else if ( EXECUTE_GBOOST_TASK_COMMAND.equals(command) ) {
            if ( !inputFilePath.getText().equals("") ) {
                List<String> commandStringList = new Vector<String>();
                File boostExecutable = new File(Configuration.GBOOST_EXECUTABLE_X64);
                if ( boostExecutable.exists() ) {
                    commandStringList.add(boostExecutable.getAbsolutePath());
                }
                commandStringList.add("-l");
                commandStringList.add(inputFilePath.getText());
                commandStringList.add("-m");
                if ( cpuRadioButton.isSelected() ) {
                    commandStringList.add("CPU");
                }
                else {
                    commandStringList.add("GPU");
                }
                commandStringList.add("-o");
                commandStringList.add(outputPrefix.getText());
                commandStringList.add("-t");
                commandStringList.add(thresholdTextField.getText());

                launcher = new ProcessLauncher(this, commandStringList, logTextArea,
                        new File(inputFilePath.getText()).getParentFile().getAbsolutePath());
                launcher.addPropertyChangeListener(new GBOOSTTaskProgressListener(this));

                progressBar.setIndeterminate(true);
                progressBar.setString("Initializing...");
                launcher.execute();

                this.executeButton.setEnabled(false);
            }
            else {
                JOptionPane.showMessageDialog(null, "No input list file is selected!", "Error Messages", JOptionPane.ERROR_MESSAGE);
            }
        }
        else if ( IMPORT_BOOST_FILE_COMMAND.equals(command) ) {
            if ( !inputFilePath.getText().equals("") ) {
                BOOSTResultFile interactionFile = new BOOSTResultFile(
                outputFilePath.getText()+"\\"+outputPrefix.getText()+"InteractionRecords.txt",
                inputFilePath.getText());
                BOOSTMarginalAssociationFile marginalAssociationFile = new BOOSTMarginalAssociationFile(
                        outputFilePath.getText()+"\\"+outputPrefix.getText()+"MarginalAssociation.txt",
                        inputFilePath.getText()
                        );

                RuntimeVariables.RawDataPanel.setFile(interactionFile);
                RuntimeVariables.MarginalAssoicationPanel.setMarginalAssociationPlot(marginalAssociationFile);
                this.dispose();
            }
            else {
                JOptionPane.showMessageDialog(null, "No input list file is selected!", "Error Messages", JOptionPane.ERROR_MESSAGE);
            }
        }

    }
    
    private class GBOOSTTaskProgressListener implements PropertyChangeListener {

        private JDialog parent = null;

        public GBOOSTTaskProgressListener(JDialog parent) {
            this.parent = parent;
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if ( "progress".equals(evt.getPropertyName()) ) {
                Integer newValue = (Integer)evt.getNewValue();
                if ( newValue >= 100 ) {
                    //parent.dispose();
                    executeButton.setEnabled(true);
                    if ( progressBar.isIndeterminate() ) {
                        progressBar.setIndeterminate(false);
                        progressBar.setString(null);
                    }
                    progressBar.setValue(100);

                    // complete the task and dispose the frame
                    if ( launcher.getExitCode() == 0 ) {
                        BOOSTResultFile interactionFile = new BOOSTResultFile(
                        outputFilePath.getText()+"\\"+outputPrefix.getText()+"InteractionRecords.txt",
                        inputFilePath.getText());
                        BOOSTMarginalAssociationFile marginalAssociationFile = new BOOSTMarginalAssociationFile(
                                outputFilePath.getText()+"\\"+outputPrefix.getText()+"MarginalAssociation.txt",
                                inputFilePath.getText()
                                );

                        RuntimeVariables.RawDataPanel.setFile(interactionFile);
                        RuntimeVariables.MarginalAssoicationPanel.setMarginalAssociationPlot(marginalAssociationFile);
                        ((JFrame) parent.getParent()).dispose();
                    }
                    else {
                        JOptionPane.showMessageDialog(null, "Encounter errors during GBOOST execution!", "Error Messages", JOptionPane.ERROR_MESSAGE);
                    }
                }
                else {
                    if ( progressBar.isIndeterminate() ) {
                        progressBar.setIndeterminate(false);
                        progressBar.setString(null);
                    }
                    progressBar.setValue((Integer)evt.getNewValue());
                }
            }
        }

    }

}

