package gboost_gui;

import java.awt.Dimension;

/**
 *
 * @author timyung
 */
public class Configuration {
    // Relative path for the db file used by GBOOST GUI
    public static final String DB_FILE_PATH = "./dbfile/INTERSNP_1.0.7_DB.mdb";

    // Relative path for the file of snp vs pathways
    public static final String SNP_PATHWAY_FILE_PATH = "./dbfile/KEGG_2_snp_b129.txt";

    // Relative path for the GBOOST executable
    public static final String GBOOST_EXECUTABLE_X64 = "./x64/GBOOST.exe";

    public enum GraphLayout {
        FRLayout,
        CircleLayout,
        SpringLayout
    }

    // Tool window configuration
    public static final int DockedLength = 250;

    // Graph Layout
    public static GraphLayout Layout = GraphLayout.SpringLayout;

    // Dimension for the graph layout
    public static Dimension GraphLayoutDimension = new Dimension(800, 600);

    // Sleep interval
    public static int SleepInterval = 10000;

    // Threshold for GBOOST
    public static double GBOOST_Threshold = 30.0;
}
