package Utility.Progress;

import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.ProgressMonitor;
import javax.swing.SwingWorker;

/**
 *
 * @author timyung
 */
public class ProgressDialog implements PropertyChangeListener {

    private String taskName = null;

    private ProgressSubDialog progressFrame = null;

    private ProgressMonitor progressMonitor = null;

    private SwingWorker worker = null;

    private boolean canCancel = false;

    public ProgressDialog(Component anchorComponenet, SwingWorker worker, String taskName, boolean canCancel) {
        this.worker = worker;
        this.taskName = taskName;
        this.canCancel = canCancel;

        // Add the property listener to the task
        worker.addPropertyChangeListener(this);

        if ( this.canCancel ) {
            progressMonitor = new ProgressMonitor(anchorComponenet, taskName, "", 0, 100);
            progressMonitor.setProgress(0);
            progressMonitor.setNote("Initializing...");
        }
        else {
            // Show progress without cancel option
            progressFrame = new ProgressSubDialog(anchorComponenet, taskName, 0, 100);
            progressFrame.setProgress(0);
            progressFrame.setNote("Initializing...");
        }
    }
    
    public String getTaskName() {
        return taskName;
    }

    public boolean canCancel() {
        return canCancel;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        // Check for progress variable in a given task
        if ("progress".equals(evt.getPropertyName()) ) {
            int progress = (Integer) evt.getNewValue();
            String message = String.format("Completed %d%%.\n", progress);

            if ( canCancel ) {
                progressMonitor.setProgress(progress);
                progressMonitor.setNote(message);

                // Detect if cancel button is click
                if ( canCancel && progressMonitor.isCanceled() ) {
                    Toolkit.getDefaultToolkit().beep();
                    worker.cancel(true);
                }
            }
            else {
                // Wait the task to be completed
                progressFrame.setProgress(progress);
                progressFrame.setNote(message);
            }
        }
    }

}

class ProgressSubDialog extends JDialog {

    private JProgressBar progressBar = null;

    private String note = "";

    private JLabel noteLabel = new JLabel("");

    private int min = 0;

    private int max = 100;

    public ProgressSubDialog(Component anchorComponenet, String taskName, int min, int max) {
        super(new JFrame(), "Progress...", false);
        this.setSize(new Dimension(160,120));

        double size[][] =
            {{10, TableLayout.FILL, 10},  // Columns
             {10, 0.35, TableLayout.FILL, 0.35, 10}}; // Rows

        JPanel panel = new JPanel();
        panel.setSize(new Dimension(160,120));
        panel.setLayout (new TableLayout(size));

        this.min = min;
        this.max = max;
        progressBar = new JProgressBar(min, max);

        panel.add(new JLabel(taskName), "1, 1");
        panel.add(progressBar,"1, 2");
        panel.add(noteLabel,"1, 3");
        panel.setVisible(true);

        // Disable close button in the dialog
        this.setDefaultCloseOperation(JFrame.DO_NOTHING_ON_CLOSE);
        this.setContentPane(panel);
        this.pack();
        this.setLocationRelativeTo(anchorComponenet);
        this.setVisible(true);
        this.requestFocus();
    }

    public void setProgress(int progress) {
        if (progress >= max) {
            this.setVisible(false);
            this.dispose();

        }
        else {
            if (progressBar != null) {
                progressBar.setValue(progress);
            }
        }
    }

    public void setNote(String note) {
        this.note = note;
        if ( noteLabel != null ) {
            noteLabel.setText(note);
        }
    }

}