package Utility.Process;

import java.io.*;
import java.util.*;
import javax.swing.JTextArea;
import javax.swing.SwingWorker;


/**
 *
 * @author timyung
 */
public class ProcessLauncher extends SwingWorker {

    private List<String> command = null;

    private JTextArea textArea = null;

    private String workingDirectory = null;

    static private Process process = null;

    private int exitCode = -1;

    public ProcessLauncher(List<String> command, JTextArea textArea, String workingDirectory) {
        this.command = command;
        this.textArea = textArea;
        this.workingDirectory = workingDirectory;
    }

    @Override
    protected Object doInBackground() throws Exception {
        ProcessBuilder builder = new ProcessBuilder(command);
        Map<String, String> environ = builder.environment();
        File currentDirectory = new File (".");
        builder.directory(new File(workingDirectory));

        int textAreaWidth = textArea.getColumns();
        for ( int i = 0; i < textAreaWidth; i++ ) {
            textArea.append("=");
        }
        textArea.append("\n");
        textArea.append("Current Directory : " + currentDirectory.getCanonicalPath()+"\n");

        // Redirect error stream and launch the process
        builder.redirectErrorStream(true);
        process = builder.start();

        // Create the stream gobbler
        StreamGobbler outputGobbler = new StreamGobbler(this, process.getInputStream(), textArea);
        outputGobbler.start();

        // Wait for process completion
        exitCode = process.waitFor();
        return "All Completed";
    }

    @Override
    protected void done() {
        super.done();
        textArea.append("Program completed!\n\n");
        this.setProgress(100);
    }

    public int getExitCode() {
        return exitCode;
    }

    private class StreamGobbler extends Thread
    {
        ProcessLauncher parent;
        InputStream is;
        OutputStream os;
        JTextArea textArea;

        public StreamGobbler(ProcessLauncher parent, InputStream is, JTextArea textArea)
        {
            this.parent = parent;
            this.is = is;
            this.textArea = textArea;
            this.os = null;
        }

        public StreamGobbler(ProcessLauncher parent, InputStream is, OutputStream redirect, JTextArea textArea)
        {
            this.parent = parent;
            this.is = is;
            this.os = redirect;
            this.textArea = textArea;
        }

        @Override
        public void run()
        {
            try
            {
                PrintWriter pw = null;
                if (os != null)
                    pw = new PrintWriter(os);

                InputStreamReader isr = new InputStreamReader(is);
                BufferedReader br = new BufferedReader(isr);
                String line=null;

                while ( (line = br.readLine()) != null)
                {
                    // parse specified string for current progress
                    if (line.contains("Progress")) {
                        StringTokenizer tokenizer = new StringTokenizer(line, ":");
                        // discard first token
                        tokenizer.nextToken();
                        // record the second token as progress
                        int progress = Integer.parseInt(new StringTokenizer(tokenizer.nextToken(),"%%").nextToken());
                        parent.setProgress(progress);
                    }
                    // Output the message to the textArea;
                    textArea.append(line + "\n");
                    
                    // Scroll to the last character
                    textArea.setCaretPosition(textArea.getDocument().getLength());
                }
                if (pw != null)
                    pw.flush();

                br.close();
                isr.close();
                is.close();
            }
            catch (IOException ioe)
            {
                ioe.printStackTrace();
            }
        }
    }

}