package Utility.MemoryUsage;

/**
 *
 * @author timyung
 */
public class MemoryMonitor {
    public static Runtime runtime = Runtime.getRuntime();
    
    public static long maxMemory() {
        return runtime.maxMemory();
    }
    
    public static long freeMemory() {
        return runtime.freeMemory();
    }
    
    public static long usedMemory() {
        return runtime.totalMemory() - runtime.freeMemory();
    }
    
    public static long totalFreeMemory() {
        return runtime.maxMemory() - usedMemory();
    }
    
    public static void printMemoryUsage() {
        StringBuilder sb = new StringBuilder();
        long freeMemory = freeMemory();
        long usedMemory = usedMemory();
        long maxMemory = maxMemory();
        long totalFreeMemory = totalFreeMemory();        
        
        sb.append("Free memory: " + freeMemory / 1024 / 1024 + " MB\n");
        sb.append("Used memory: " + usedMemory / 1024 / 1024 + " MB\n");
        sb.append("Max memory: " + maxMemory / 1024 / 1024 + " MB\n");
        sb.append("Total free memory: " + totalFreeMemory / 1024 / 1024 + " MB\n");
        System.out.print(sb.toString());
    }
}
