package Plot;

import Data.BOOST.BOOSTMarginalAssociationFile;
import Data.BOOST.BOOSTMarginalAssociationItem;
import java.util.List;
import java.util.Vector;
import org.jfree.data.xy.AbstractIntervalXYDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;

/**
 *
 * @author timyung
 */
public class MarginalAssociationDataset extends AbstractIntervalXYDataset implements XYDataset {

    private List<XYSeries> xySeriesList = null;

    public MarginalAssociationDataset(BOOSTMarginalAssociationFile inputFile) {
        xySeriesList = new Vector<XYSeries>();

        // Create 23 series for human chromesome
        for ( int i = 0; i < 23; i++) {
            xySeriesList.add(new XYSeries("Chr "+(i+1)));
        }

        List<BOOSTMarginalAssociationItem> itemList = inputFile.getItemList();
        for ( BOOSTMarginalAssociationItem item : itemList ) {
            xySeriesList.get(item.chr-1).add(item.location, item.value);
        }
    }

    @Override
    public int getSeriesCount() {
        return xySeriesList.size();
    }

    @Override
    public Comparable getSeriesKey(int series) {
        return xySeriesList.get(series).getKey();
    }

    public int getItemCount(int series) {
        return xySeriesList.get(series).getItemCount();
    }

    public Number getX(int series, int item) {
        return xySeriesList.get(series).getX(item);
    }

    public Number getY(int series, int item) {
        return xySeriesList.get(series).getY(item);
    }

    public Number getStartX(int series, int item) {
        return xySeriesList.get(series).getX(item);
    }

    public Number getEndX(int series, int item) {
        return xySeriesList.get(series).getX(item);
    }

    public Number getStartY(int series, int item) {
        return xySeriesList.get(series).getY(item);
    }

    public Number getEndY(int series, int item) {
        return xySeriesList.get(series).getY(item);
    }

}
