package Plot;

import Data.BOOST.BOOSTMarginalAssociationFile;
import info.clearthought.layout.TableLayout;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.io.File;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;

/**
 *
 * @author timyung
 */
public class MarginalAssociationChartPanel extends JPanel implements ChangeListener, ActionListener, ItemListener  {

    private static String SET_INTERVAL_COMMAND = "SET_INTERVAL";

    private int interval = 1000;

    private BOOSTMarginalAssociationFile file = null;

    private MarginalAssociationPlot plot = null;

    private JSlider slider = new JSlider();

    private JRadioButton fullRangeOptionButton = new JRadioButton();

    private JLabel displayFullIntervalLabel = new JLabel("Display Full Interval");

    private JRadioButton selectedRangeOptionButton = new JRadioButton();

    private JLabel intervalLabel = new JLabel("Interval");

    private JTextField intervalTextField = new JTextField();

    private JButton setButton = new JButton("Set");

    public MarginalAssociationChartPanel() {
        super();

        // initialize and disable some options
        slider.setEnabled(false);
        intervalTextField.setEnabled(false);
        intervalTextField.setEditable(false);
        setButton.setEnabled(false);
        intervalLabel.setEnabled(false);

        slider.setBorder(BorderFactory.createTitledBorder("Starting point of the marginal association plot"));
        slider.addChangeListener(this);

        intervalTextField = new JTextField();
        intervalTextField.setText(Integer.toString(interval));
        setButton.setActionCommand(SET_INTERVAL_COMMAND);
        setButton.addActionListener(this);

        ButtonGroup group = new ButtonGroup();
        group.add(fullRangeOptionButton);
        group.add(selectedRangeOptionButton);
        fullRangeOptionButton.setSelected(true);
        fullRangeOptionButton.addItemListener(this);
        selectedRangeOptionButton.addItemListener(this);
        
        JPanel optionPanel = new JPanel();
        TableLayout tableLayout = new TableLayout(
                new double[]{10, TableLayout.FILL, 0.05, 0.1, 0.1, 0.1, 10},
                new double[]{0}
                );
        optionPanel.setLayout(tableLayout);
        tableLayout.insertRow(1, TableLayout.PREFERRED);
        tableLayout.insertRow(2, TableLayout.PREFERRED);
        tableLayout.insertRow(3, TableLayout.PREFERRED);
        optionPanel.add(slider, "1,1,1,3");
        optionPanel.add(fullRangeOptionButton, "2,1");
        optionPanel.add(displayFullIntervalLabel, "3,1,4,1");
        optionPanel.add(selectedRangeOptionButton, "2,2");
        optionPanel.add(intervalLabel, "3,2");
        optionPanel.add(intervalTextField, "4,2");
        optionPanel.add(setButton, "5,2");

        // Create an empty JPanel
        JPanel tempPanel = new JPanel();

        this.setLayout(new BorderLayout());
        this.add(tempPanel, BorderLayout.CENTER);
        this.add(optionPanel, BorderLayout.SOUTH);
    }

    public void setMarginalAssociationPlot(BOOSTMarginalAssociationFile file) {
        this.file = file;

        // clear all component in current panel
        this.removeAll();
        
        plot = new MarginalAssociationPlot(file);

        int max = Math.max(0, file.getItemCount()-1 - interval);
        if ( max != 0 ) {
            int majorTicking = max/5;
            int minorTicking = majorTicking/4;
            slider.setMinimum(0);
            slider.setMaximum(file.getItemCount()-1);
            slider.setMajorTickSpacing(majorTicking);
            slider.setMinorTickSpacing(minorTicking);
        }
        slider.setPaintTicks(true);
        slider.setPaintLabels(true);

        // build the option panel
        JPanel optionPanel = new JPanel();
        TableLayout tableLayout = new TableLayout(
                new double[]{10, TableLayout.FILL, 0.05, 0.1, 0.1, 0.1, 10},
                new double[]{0}
                );
        optionPanel.setLayout(tableLayout);
        tableLayout.insertRow(1, TableLayout.PREFERRED);
        tableLayout.insertRow(2, TableLayout.PREFERRED);
        tableLayout.insertRow(3, TableLayout.PREFERRED);
        optionPanel.add(slider, "1,1,1,3");
        optionPanel.add(fullRangeOptionButton, "2,1");
        optionPanel.add(displayFullIntervalLabel, "3,1,4,1");
        optionPanel.add(selectedRangeOptionButton, "2,2");
        optionPanel.add(intervalLabel, "3,2");
        optionPanel.add(intervalTextField, "4,2");
        optionPanel.add(setButton, "5,2");
        
        // Reset the display range
        fullRangeOptionButton.setSelected(true);

        // Add all components
        this.add(plot, BorderLayout.CENTER);
        this.add(optionPanel, BorderLayout.SOUTH);

        this.getParent().validate();
    }

    public void stateChanged(ChangeEvent e) {
        JSlider source = (JSlider)e.getSource();
        if (!source.getValueIsAdjusting()) {
            if ( source.isEnabled() ) {
                int newValue = (int)source.getValue();
                if ( plot != null ) {
                    plot.setXRange(newValue, newValue+interval);
                }
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if ( e.getActionCommand().equals(SET_INTERVAL_COMMAND) ) {
            String value = intervalTextField.getText();
            try {
                double dbvalue = Double.parseDouble(value);
                interval = (int)dbvalue;
                intervalTextField.setText(Integer.toString(interval));

                if ( plot != null ) {
                    int start = slider.getValue();
                    plot.setXRange(start, start+interval);
                }
            } catch (java.lang.NumberFormatException ex) {
                intervalTextField.setText(Integer.toString(interval));
            }
        }
    }

    public void itemStateChanged(ItemEvent e) {        
        if ( fullRangeOptionButton.isSelected() ) {
            displayFullIntervalLabel.setEnabled(true);
            slider.setEnabled(false);
            intervalTextField.setEnabled(false);
            intervalTextField.setEditable(false);
            setButton.setEnabled(false);
            intervalLabel.setEnabled(false);

            if ( plot != null ) {
                plot.setXRange(0, file.getItemCount()-1);
            }
        }
        if ( selectedRangeOptionButton.isSelected() ) {
            displayFullIntervalLabel.setEnabled(false);
            slider.setEnabled(true);
            intervalTextField.setEnabled(true);
            intervalTextField.setEditable(true);
            setButton.setEnabled(true);
            intervalLabel.setEnabled(true);

            if ( plot != null ) {
                int start = slider.getValue();
                plot.setXRange(start, start+interval);
            }
        }
    }

    class MarginalAssociationPlot extends ChartPanel {

        private BOOSTMarginalAssociationFile file = null;

        private MarginalAssociationDataset dataset = null;

        private JFreeChart chart = null;

        public MarginalAssociationPlot(BOOSTMarginalAssociationFile inputFile) {
            super(null, true);
            this.file = inputFile;
            this.chart = null;

            // build the dataset
            constructDataset();

            // build the chart
            buildChart();
        }

        private void constructDataset() {
            dataset = new MarginalAssociationDataset(file);
        }

        protected void buildChart() {

            // Build the chart
            chart = ChartFactory.createScatterPlot("Marginal Association", "Location", "Value", dataset, PlotOrientation.VERTICAL, false, false, false);

    //        // Customization
    //        // Set axis
    //        NumberAxis xAxis = new NumberAxis("Intensity ( " + xFeature.getTitle() + " )");
    //        xAxis.setAutoRangeIncludesZero(true);
    //        xAxis.setLowerMargin(0.0);
    //        xAxis.setUpperMargin(0.0);
    //        //xAxis.setLowerBound(Configuration.MinIntensity);
    //        //xAxis.setUpperBound(Configuration.MaxIntensity);
    //
    //        FeatureEntity yFeature = featureList.get(yfeature);
    //        NumberAxis yAxis = new NumberAxis("Intensity ( " + yFeature.getTitle() + " )");
    //        yAxis.setAutoRangeIncludesZero(true);
    //        yAxis.setLowerMargin(0.0);
    //        yAxis.setUpperMargin(0.0);
    //        //yAxis.setLowerBound(Configuration.MinIntensity);
    //        //yAxis.setUpperBound(Configuration.MaxIntensity);
    //
    //        // Create XY Plot and set plot properties
    //        XYPlot plot = new XYPlot(dataset, xAxis, yAxis, renderer);
    //        plot.setBackgroundPaint(Color.white);
    //        plot.setDomainGridlinesVisible(false);
    //        plot.setRangeGridlinesVisible(false);
    //
    //        // Create chart and set chart properties
    //        chart = new JFreeChart(null, plot);
    //        chart.setBackgroundPaint(Color.white);

            // Disable chart entity to speed up
            this.getChartRenderingInfo().setEntityCollection(null);

            // Replace old chart
            this.setChart(chart);
        }

        public int getXMin() {
            return (int) chart.getXYPlot().getDomainAxis().getLowerBound();
        }

        public int getXMax() {
            return (int) chart.getXYPlot().getDomainAxis().getUpperBound();
        }

        public void setXRange(int lower, int upper) {
            chart.getXYPlot().getDomainAxis().setRange(lower, upper);
        }

    }

    public int writeImage(String filename, String type) {
        if ( plot != null ) {
            int width = plot.getWidth();
            int height = plot.getHeight();

            BufferedImage bi = new BufferedImage(width, height, BufferedImage.TYPE_INT_RGB);
            Graphics2D graphics = bi.createGraphics();
            plot.paint(graphics);
            graphics.dispose();

            try {
                ImageIO.write(bi, type, new File(filename));
            } catch (Exception e) {
                e.printStackTrace();
                return -1;
            }
            return 0;
        }
        else {
            return -1;
        }
    }

    public static void main(String[] args) throws Exception {
        MarginalAssociationChartPanel panel = new MarginalAssociationChartPanel();
        BOOSTMarginalAssociationFile file =
                new BOOSTMarginalAssociationFile(
                "C:\\Documents and Settings\\timyung\\Desktop\\TestFolder\\outputMarginalAssociation.txt",
                "C:\\Documents and Settings\\timyung\\Desktop\\TestFolder\\filenamelist.txt"
                );
        panel.setMarginalAssociationPlot(file);
        
        JFrame frame = new JFrame("Test Frame");
        frame.setSize(new Dimension(720,480));
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        frame.setLocationRelativeTo(null);
        frame.getContentPane().add(panel, BorderLayout.CENTER);
        frame.setVisible(true);
    }

}

