package Graph.Tool;

import Graph.GraphPanel.EDGE_SHAPE;
import edu.uci.ics.jung.visualization.control.ModalGraphMouse;
import gboost_gui.RuntimeVariables;
import info.clearthought.layout.TableLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

/**
 *
 * @author timyung
 */
public class GraphOptionPanel extends JPanel implements ActionListener {

    public static final String SET_FILTER_VERTICE_VALUE_COMMAND = "Set_FilterVerticeValue";

    public static final String SET_HIGHLIGHT_EDGE_VALUE_COMMAND = "Set_HighlightEdgeValue";

    // Command
    // Hide internal edge
    // Highlight edge
    // Graph character command
    // Size of node
    // Size of cluster

    private JRadioButton transformingButton = null;
    private JRadioButton pickingButton = null;
    private JRadioButton annotatingButton = null;

    private JToolBar annotationControlToolBar = null;

    private JPanel vertexOptionPanel = new JPanel();

    private JCheckBox showVertexDominantPathway = null;
    private JCheckBox showVertexNameButton = null;
    private JCheckBox showVertexValueButton = null;
    private JCheckBox highlightVertexButton = null;

    private JCheckBox filterVertexButton = null;
    private JTextField filterVerticeValueTextField = null;
    private JButton filterVerticeSetButton = null;

    private JPanel edgeOptionPanel = new JPanel();

    private JRadioButton lineEdgeShapeButton = null;
    private JRadioButton curveEdgeShapeButton = null;
    private JRadioButton orthogonalEdgeShapeButton = null;

    private JCheckBox showEdgeValueButton = null;

    private JCheckBox highlightEdgeButton = null;
    private JTextField highlightEdgeValueTextField = new JTextField();
    private JButton highlightEdgeValueSetButton = new JButton("Set");

    public GraphOptionPanel() {
        super();
        TableLayout tableLayout = null;
        double tableLayoutBorderSize = 10;
        int rowIndex = 0;
        TitledBorder titleBorder = null;
        Border loweredetched = BorderFactory.createEtchedBorder(EtchedBorder.LOWERED);

        // Working mode options
        ButtonGroup workingModeOptions = new ButtonGroup();
        transformingButton = new JRadioButton("Transforming");
        transformingButton.addActionListener(this);
        pickingButton = new JRadioButton("Picking");
        pickingButton.addActionListener(this);
        annotatingButton = new JRadioButton("Annotating");
        annotatingButton.addActionListener(this);

        workingModeOptions.add(transformingButton);
        workingModeOptions.add(pickingButton);
        workingModeOptions.add(annotatingButton);

        switch ( RuntimeVariables.WORKING_MODE ) {
            case TRANSFORMING:
                transformingButton.setSelected(true);
                break;
            case PICKING:
                pickingButton.setSelected(true);
                break;
            case ANNOTATING:
                annotatingButton.setSelected(true);
                break;
            default:
        }

        // Create vertices' option
        showVertexDominantPathway = new JCheckBox("Show vertex dominant pathway");
        showVertexDominantPathway.addActionListener(this);
        showVertexDominantPathway.setSelected(RuntimeVariables.ShowVertexDominantPathway);
        showVertexNameButton = new JCheckBox("Show vertex name");
        showVertexNameButton.addActionListener(this);
        showVertexNameButton.setSelected(RuntimeVariables.ShowVertexName);
        showVertexValueButton = new JCheckBox("Show vertex value");
        showVertexValueButton.addActionListener(this);
        showVertexValueButton.setSelected(RuntimeVariables.ShowVertexValue);
        highlightVertexButton = new JCheckBox("Highlight selected vertices and its neighbors");
        highlightVertexButton.addActionListener(this);
        highlightVertexButton.setSelected(RuntimeVariables.VertexStrokeHighlight);

        filterVertexButton = new JCheckBox("Filter vertices");
        filterVertexButton.addActionListener(this);
        filterVertexButton.setSelected(RuntimeVariables.FilterVertices);
        filterVerticeValueTextField = new JTextField();
        filterVerticeValueTextField.setText(Double.toString(RuntimeVariables.FilterVerticesValue));
        filterVerticeSetButton = new JButton("Set");
        filterVerticeSetButton.setActionCommand(SET_FILTER_VERTICE_VALUE_COMMAND);
        filterVerticeSetButton.addActionListener(this);
        filterVerticeValueTextField.setEnabled(filterVertexButton.isSelected());
        filterVerticeSetButton.setEnabled(filterVertexButton.isSelected());
        
        tableLayout = new TableLayout(
                new double[]{tableLayoutBorderSize, 0.5, TableLayout.FILL, tableLayoutBorderSize},
                new double[]{0}
                );

        // Add vertices' options and set the border
        vertexOptionPanel.setLayout(tableLayout);
        rowIndex = 0;
        tableLayout.insertRow(++rowIndex, TableLayout.PREFERRED);
        tableLayout.insertRow(++rowIndex, TableLayout.PREFERRED);
        tableLayout.insertRow(++rowIndex, TableLayout.PREFERRED);
        tableLayout.insertRow(++rowIndex, TableLayout.PREFERRED);
        tableLayout.insertRow(++rowIndex, TableLayout.PREFERRED);
        tableLayout.insertRow(++rowIndex, TableLayout.PREFERRED);

        vertexOptionPanel.add(showVertexDominantPathway, "1,1,2,1");
        vertexOptionPanel.add(showVertexNameButton, "1,2,2,2");
        vertexOptionPanel.add(showVertexValueButton,"1,3,2,3");
        vertexOptionPanel.add(highlightVertexButton, "1,4,2,4");
        vertexOptionPanel.add(filterVertexButton, "1,5,2,5");
        vertexOptionPanel.add(filterVerticeValueTextField, "1,6");
        vertexOptionPanel.add(filterVerticeSetButton, "2,6");

        titleBorder = BorderFactory.createTitledBorder(loweredetched, "Vertices' Option");
        titleBorder.setTitleJustification(TitledBorder.LEFT);
        vertexOptionPanel.setBorder(titleBorder);

        // Create edges' option
        ButtonGroup edgeShapeButtonGroup = new ButtonGroup();
        lineEdgeShapeButton = new JRadioButton("Line");
        curveEdgeShapeButton = new JRadioButton("Curve");
        orthogonalEdgeShapeButton = new JRadioButton("Orthogonal");

        edgeShapeButtonGroup.add(lineEdgeShapeButton);
        edgeShapeButtonGroup.add(curveEdgeShapeButton);
        edgeShapeButtonGroup.add(orthogonalEdgeShapeButton);

        switch ( RuntimeVariables.EdgeShape ) {
            case LINE:
                lineEdgeShapeButton.setSelected(true);
                break;
            case CURVE:
                curveEdgeShapeButton.setSelected(true);
                break;
            case ORTHOGONAL:
                orthogonalEdgeShapeButton.setSelected(true);
                break;
            default:

        }

        lineEdgeShapeButton.addActionListener(this);
        curveEdgeShapeButton.addActionListener(this);
        orthogonalEdgeShapeButton.addActionListener(this);

        JPanel edgeShapeOptionPanel = new JPanel();
        tableLayout = new TableLayout(
                new double[]{0.5, 0.5},
                new double[]{0}
                );
        edgeShapeOptionPanel.setLayout(tableLayout);
        tableLayout.insertRow(1, TableLayout.PREFERRED);
        tableLayout.insertRow(2, TableLayout.PREFERRED);
        edgeShapeOptionPanel.add(lineEdgeShapeButton, "0,1");
        edgeShapeOptionPanel.add(curveEdgeShapeButton, "1,1");
        edgeShapeOptionPanel.add(orthogonalEdgeShapeButton, "0,2,1,2");

        titleBorder = BorderFactory.createTitledBorder(loweredetched, "Edge Shape");
        titleBorder.setTitleJustification(TitledBorder.LEFT);
        edgeShapeOptionPanel.setBorder(titleBorder);

        showEdgeValueButton = new JCheckBox("Show edge value");
        showEdgeValueButton.addActionListener(this);
        showEdgeValueButton.setSelected(RuntimeVariables.ShowEdgeValue);

        highlightEdgeButton = new JCheckBox("Hightlight Edge");
        highlightEdgeButton.addActionListener(this);
        highlightEdgeButton.setSelected(RuntimeVariables.HighlightEdge);

        highlightEdgeValueTextField = new JTextField();
        highlightEdgeValueTextField.setText(Double.toString(RuntimeVariables.HighlightEdgeValue));
        highlightEdgeValueSetButton = new JButton("Set");
        highlightEdgeValueSetButton.setActionCommand(SET_HIGHLIGHT_EDGE_VALUE_COMMAND);
        highlightEdgeValueSetButton.addActionListener(this);
        highlightEdgeValueTextField.setEnabled(highlightEdgeButton.isSelected());
        highlightEdgeValueSetButton.setEnabled(highlightEdgeButton.isSelected());        

        // Add edges' options and set the border
        tableLayout = new TableLayout(
                new double[]{tableLayoutBorderSize, TableLayout.FILL, 0.5, tableLayoutBorderSize},
                new double[]{0}
                );
        edgeOptionPanel.setLayout(tableLayout);
        rowIndex = 0;
        tableLayout.insertRow(++rowIndex, TableLayout.PREFERRED);
        tableLayout.insertRow(++rowIndex, TableLayout.PREFERRED);
        tableLayout.insertRow(++rowIndex, TableLayout.PREFERRED);
        tableLayout.insertRow(++rowIndex, TableLayout.PREFERRED);

        edgeOptionPanel.add(edgeShapeOptionPanel, "1, 1, 2, 1");
        edgeOptionPanel.add(showEdgeValueButton, "1, 2, 2, 2");
        edgeOptionPanel.add(highlightEdgeButton, "1, 3, 2, 3");
        edgeOptionPanel.add(highlightEdgeValueTextField, "1, 4");
        edgeOptionPanel.add(highlightEdgeValueSetButton, "2, 4");

        titleBorder = BorderFactory.createTitledBorder(loweredetched, "Edges' Option");
        titleBorder.setTitleJustification(TitledBorder.LEFT);
        edgeOptionPanel.setBorder(titleBorder);

        // Add the option panels to the main panel
        tableLayout = new TableLayout(
                new double[]{tableLayoutBorderSize,TableLayout.FILL,tableLayoutBorderSize},
                new double[]{0}
                );
        this.setLayout(tableLayout);
        rowIndex = 0;
        tableLayout.insertRow(++rowIndex, TableLayout.PREFERRED);
        tableLayout.insertRow(++rowIndex, TableLayout.PREFERRED);
        tableLayout.insertRow(++rowIndex, TableLayout.PREFERRED);
        tableLayout.insertRow(++rowIndex, TableLayout.PREFERRED);
        tableLayout.insertRow(++rowIndex, TableLayout.PREFERRED);
        tableLayout.insertRow(++rowIndex, TableLayout.PREFERRED);
        tableLayout.insertRow(++rowIndex, TableLayout.PREFERRED);
        this.add(new JLabel("Working Mode :"), "1,1");
        this.add(transformingButton, "1,2");
        this.add(pickingButton, "1,3");
        this.add(annotatingButton, "1,4");
        this.add(vertexOptionPanel, "1,6");
        this.add(edgeOptionPanel, "1,7");
    }

    public void actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        AbstractButton source = (AbstractButton)e.getSource();

        if ( source == transformingButton ) {
            if ( source.isSelected() ) {
                RuntimeVariables.WORKING_MODE = ModalGraphMouse.Mode.TRANSFORMING;
                RuntimeVariables.PathwayGraphPanel.setGraphMouse(ModalGraphMouse.Mode.TRANSFORMING);
            }
        }
        else if ( source == pickingButton ) {
            if ( source.isSelected() ) {
                RuntimeVariables.WORKING_MODE = ModalGraphMouse.Mode.PICKING;
                RuntimeVariables.PathwayGraphPanel.setGraphMouse(ModalGraphMouse.Mode.PICKING);
            }
        }
        else if ( source == annotatingButton ) {
            if ( source.isSelected() ) {
                RuntimeVariables.WORKING_MODE = ModalGraphMouse.Mode.ANNOTATING;
                RuntimeVariables.PathwayGraphPanel.setGraphMouse(ModalGraphMouse.Mode.ANNOTATING);
//                GraphMouse gm = RuntimeVariables.PathwayGraphPanel.getGraphMouse();
//                if ( gm != null ) {
//                    AnnotationControls annotationControls = new AnnotationControls(((EditingModalGraphMouse)gm).getAnnotatingPlugin());
//                    if ( annotationControlToolBar != null ) {
//                        this.remove(annotationControlToolBar);
//                    }
//                    annotationControlToolBar = annotationControls.getAnnotationsToolBar();
//                    this.add(annotationControls.getAnnotationsToolBar(), "1,5");
//                    this.getParent().repaint();
//                }
            }
        }
        else if ( source == highlightVertexButton ) {
            RuntimeVariables.VertexStrokeHighlight = source.isSelected();
            RuntimeVariables.PathwayGraphPanel.setVertexStokeHighlight(source.isSelected());
        }
        else if ( source == showVertexDominantPathway ) {
            RuntimeVariables.ShowVertexDominantPathway = source.isSelected();
            RuntimeVariables.PathwayGraphPanel.showVertexLabel(
                    RuntimeVariables.ShowVertexDominantPathway
                    || RuntimeVariables.ShowVertexName
                    || RuntimeVariables.ShowVertexValue);
        }
        else if ( source == showVertexNameButton ) {
            RuntimeVariables.ShowVertexName = source.isSelected();
            RuntimeVariables.PathwayGraphPanel.showVertexLabel(
                    RuntimeVariables.ShowVertexDominantPathway
                    || RuntimeVariables.ShowVertexName
                    || RuntimeVariables.ShowVertexValue);
        }
        else if ( source == showVertexValueButton ) {
            RuntimeVariables.ShowVertexValue = source.isSelected();
            RuntimeVariables.PathwayGraphPanel.showVertexLabel(
                    RuntimeVariables.ShowVertexDominantPathway
                    || RuntimeVariables.ShowVertexName
                    || RuntimeVariables.ShowVertexValue);
        }
        else if ( source == filterVertexButton ) {
            RuntimeVariables.FilterVertices = source.isSelected();
            filterVerticeValueTextField.setEnabled(filterVertexButton.isSelected());
            filterVerticeSetButton.setEnabled(filterVertexButton.isSelected());

            try
            {
                double value = Double.parseDouble(filterVerticeValueTextField.getText());
                RuntimeVariables.FilterVerticesValue = value;
                RuntimeVariables.PathwayGraphPanel.setVertexPredicate(RuntimeVariables.FilterVertices,value);
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(null, "Unable to parse the edge value!", "Error Messages", JOptionPane.ERROR_MESSAGE);
                filterVerticeValueTextField.setText(Double.toString(RuntimeVariables.FilterVerticesValue));
            }
        }
        else if ( source == lineEdgeShapeButton ) {
            if ( lineEdgeShapeButton.isSelected() ) {
                RuntimeVariables.EdgeShape = EDGE_SHAPE.LINE;
                RuntimeVariables.PathwayGraphPanel.setEdgeShape(EDGE_SHAPE.LINE);
            }
        }
        else if ( source == curveEdgeShapeButton ) {
            if ( curveEdgeShapeButton.isSelected() ) {
                RuntimeVariables.EdgeShape = EDGE_SHAPE.CURVE;
                RuntimeVariables.PathwayGraphPanel.setEdgeShape(EDGE_SHAPE.CURVE);
            }
        }
        else if ( source == orthogonalEdgeShapeButton ) {
            if ( orthogonalEdgeShapeButton.isSelected() ) {
                RuntimeVariables.EdgeShape = EDGE_SHAPE.ORTHOGONAL;
                RuntimeVariables.PathwayGraphPanel.setEdgeShape(EDGE_SHAPE.ORTHOGONAL);
            }
        }
        else if ( source == showEdgeValueButton ) {
            RuntimeVariables.ShowEdgeValue = source.isSelected();
            RuntimeVariables.PathwayGraphPanel.showEdgeValue(source.isSelected());
        }
        else if ( source == highlightEdgeButton ) {
            RuntimeVariables.HighlightEdge = source.isSelected();
            highlightEdgeValueTextField.setEnabled(highlightEdgeButton.isSelected());
            highlightEdgeValueSetButton.setEnabled(highlightEdgeButton.isSelected());

            if ( RuntimeVariables.HighlightEdge ) {
                try
                {
                    double value = Double.parseDouble(highlightEdgeValueTextField.getText());
                    RuntimeVariables.HighlightEdgeValue = value;
                    RuntimeVariables.PathwayGraphPanel.setEdgeWeight(true, value);
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(null, "Unable to parse the edge value!", "Error Messages", JOptionPane.ERROR_MESSAGE);
                    highlightEdgeValueTextField.setText(Double.toString(RuntimeVariables.HighlightEdgeValue));
                }
            }
        }

        // Check action command
        if ( SET_FILTER_VERTICE_VALUE_COMMAND.equals(actionCommand) ) {
            try
            {
                double value = Double.parseDouble(filterVerticeValueTextField.getText());
                RuntimeVariables.FilterVerticesValue = value;
                RuntimeVariables.PathwayGraphPanel.setVertexPredicate(RuntimeVariables.FilterVertices,value);
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(null, "Unable to parse the edge value!", "Error Messages", JOptionPane.ERROR_MESSAGE);
                filterVerticeValueTextField.setText(Double.toString(RuntimeVariables.FilterVerticesValue));
            }
        }
        else if ( SET_HIGHLIGHT_EDGE_VALUE_COMMAND.equals(actionCommand) ) {
            try
            {
                double value = Double.parseDouble(highlightEdgeValueTextField.getText());
                RuntimeVariables.HighlightEdgeValue = value;
                RuntimeVariables.PathwayGraphPanel.setEdgeWeight(true, value);
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(null, "Unable to parse the edge value!", "Error Messages", JOptionPane.ERROR_MESSAGE);
                highlightEdgeValueTextField.setText(Double.toString(RuntimeVariables.HighlightEdgeValue));
            }
        }
    }



}
