package Graph.Tool;

import Data.Record;
import Graph.Element.GraphVertex;
import info.clearthought.layout.TableLayout;
import java.awt.BorderLayout;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableModel;

/**
 *
 * @author timyung
 */
public class GraphNodePropertyPanel extends JPanel {

    private GraphVertex currentVertex = null;

    private JPanel vertexInfoPanel = null;
    private JLabel vertexNameLabel = new JLabel();
    private JLabel vertexValueLabel = new JLabel();
    private JLabel dominentPathwayLabel = new JLabel();
    private JPanel pathwayListPanel = null;
    private JList pathwayList = null;

    private JPanel tablePanel = null;
    private JScrollPane tableScrollPanel = null;
    private DefaultTableModel tableModel = null;
    private JTable propertyTable = null;

    public GraphNodePropertyPanel() {
        super();

        // table layout size
        double tableLayoutBorderSize = 10;
        int tableLayoutVGap = 2, tableLayoutHGap = 5;
        TableLayout tableLayout = null;
        int rowIndex = 0;

        // title border variable
        Border loweredetched = BorderFactory.createEtchedBorder(EtchedBorder.LOWERED);
        TitledBorder titleBorder = null;

        // initialize the list
        pathwayList = new JList();
        JScrollPane pathwayListScrollPane = new JScrollPane(pathwayList);
        pathwayListPanel = new JPanel();
        pathwayListPanel.setLayout(new BorderLayout());
        pathwayListPanel.add(pathwayListScrollPane, BorderLayout.CENTER);
        titleBorder = BorderFactory.createTitledBorder(loweredetched, "Pathway List");
        titleBorder.setTitleJustification(TitledBorder.LEFT);
        pathwayListPanel.setBorder(titleBorder);

        vertexInfoPanel = new JPanel();
        tableLayout = new TableLayout(
                new double[]{tableLayoutBorderSize, 0.6, TableLayout.FILL, tableLayoutBorderSize},
                new double[]{0}
                );
        vertexInfoPanel.setLayout(tableLayout);
        rowIndex = 0;
        tableLayout.insertRow(++rowIndex, TableLayout.PREFERRED);
        tableLayout.insertRow(++rowIndex, TableLayout.PREFERRED);
        tableLayout.insertRow(++rowIndex, TableLayout.PREFERRED);
        tableLayout.insertRow(++rowIndex, TableLayout.PREFERRED);

        vertexInfoPanel.add(new JLabel("Vertex Name : "), "1,1");
        vertexInfoPanel.add(vertexNameLabel, "2,1");
        vertexInfoPanel.add(new JLabel("Vertex Value : "), "1,2");
        vertexInfoPanel.add(vertexValueLabel, "2,2");
        vertexInfoPanel.add(new JLabel("Dominent Pathway : "), "1,3");
        vertexInfoPanel.add(dominentPathwayLabel, "2,3");
        vertexInfoPanel.add(pathwayListPanel, "1,4,2,4");

        titleBorder = BorderFactory.createTitledBorder(loweredetched, "Graph Vertex Info");
        titleBorder.setTitleJustification(TitledBorder.LEFT);
        vertexInfoPanel.setBorder(titleBorder);

        // Build the table model and the table
        tableModel = new DefaultTableModel();
        tableModel.setColumnIdentifiers(new String[]{"Field Name", "Value"});
        
        propertyTable = new JTable(tableModel);
        propertyTable.setColumnSelectionAllowed(false);
        
        tableScrollPanel = new JScrollPane(propertyTable);
        tablePanel = new JPanel();
        tablePanel.setLayout(new BorderLayout());
        tablePanel.add(tableScrollPanel, BorderLayout.CENTER);

        titleBorder = BorderFactory.createTitledBorder(loweredetched, "Database Vertex Info");
        titleBorder.setTitleJustification(TitledBorder.LEFT);
        tablePanel.setBorder(titleBorder);

        tableLayout = new TableLayout(
                new double[]{tableLayoutBorderSize, TableLayout.FILL, tableLayoutBorderSize},
                new double[]{0}
                );
        this.setLayout(tableLayout);
        rowIndex = 0;
        tableLayout.insertRow(++rowIndex, TableLayout.PREFERRED);
        tableLayout.insertRow(++rowIndex, TableLayout.PREFERRED);

        this.add(vertexInfoPanel, "1,1");
        this.add(tablePanel,"1,2");
        this.setVisible(true);
    }

    public void setCurrentNode(GraphVertex vertex) {
        // update vertex and reset the table
        currentVertex = vertex;

        if ( currentVertex != null ) {
            // Get the vertex information
            vertexNameLabel.setText(currentVertex.getVertexLabel());
            vertexValueLabel.setText(Double.toString(currentVertex.getVertexValue()));
            dominentPathwayLabel.setText(currentVertex.getDomainPathWay());
            
            // clear the list
            pathwayList.setModel(new DefaultListModel());
            DefaultListModel model = (DefaultListModel) pathwayList.getModel();
            
            if ( currentVertex.getPathWayList() != null ) {
                for ( String s : currentVertex.getPathWayList()) {
                    model.addElement(s);
                }
            }

            // Get the corresponding database information
            tableModel.setRowCount(0);
            Record record = Record.getRecord(vertex.getVertexLabel());
            if ( record != null ) {
                for ( int i = 0; i < Record.attributeNameArray.length; i++ ) {
                    tableModel.addRow(new String[]{Record.attributeNameArray[i], record.getAttributeObject(i).toString()});
                }
            }
        }
    }

    public GraphVertex getCurrentVertex() {
        return currentVertex;
    }

}
