package Graph;

import Data.BOOST.BOOSTResultFile;
import Data.BOOST.BOOSTResultItem;
import Graph.Element.GraphEdge;
import Graph.Element.GraphVertex;
import Data.Record;
import Data.SNPPathWayDataFile;
import Graph.CustomRenderContext.VertexStrokeHighlight;
import Graph.CustomRenderContext.EdgeWeightStrokeFunction;
import Graph.CustomRenderContext.VertexDisplayPredicate;
import Graph.CustomRenderContext.VertexFillPaint;
import SearchUitlity.AccessJDBCUtil;
import edu.uci.ics.jung.algorithms.layout.AggregateLayout;
import edu.uci.ics.jung.algorithms.layout.CircleLayout;
import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.algorithms.layout.StaticLayout;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.SparseMultigraph;
import edu.uci.ics.jung.graph.util.Pair;
import edu.uci.ics.jung.visualization.DefaultVisualizationModel;
import edu.uci.ics.jung.visualization.RenderContext;
import edu.uci.ics.jung.visualization.VisualizationModel;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.VisualizationViewer.GraphMouse;
import edu.uci.ics.jung.visualization.control.CrossoverScalingControl;
import edu.uci.ics.jung.visualization.control.EditingModalGraphMouse;
import edu.uci.ics.jung.visualization.control.GraphMouseListener;
import edu.uci.ics.jung.visualization.control.ModalGraphMouse;
import edu.uci.ics.jung.visualization.control.ScalingControl;
import edu.uci.ics.jung.visualization.decorators.EdgeShape;
import edu.uci.ics.jung.visualization.decorators.ToStringLabeller;
import edu.uci.ics.jung.visualization.picking.PickedState;
import edu.uci.ics.jung.visualization.renderers.Renderer.VertexLabel.Position;
import gboost_gui.Configuration;
import gboost_gui.RuntimeVariables;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.apache.commons.collections15.Factory;
import org.apache.commons.collections15.Transformer;
import org.apache.commons.collections15.functors.ConstantTransformer;



/**
 *
 * @author timyung
 */
public class GraphPanel extends JPanel implements GraphMouseListener {

    public enum EDGE_SHAPE {
        LINE,
        CURVE,
        ORTHOGONAL
    };

    public static Transformer NULL_TRANSFORMER = new ConstantTransformer(null);

    private class VertexFactory implements Factory<GraphVertex> {
    	
        public GraphVertex create() {
            return new GraphVertex("",0.0);
        }
    }
    
    private class EdgeFactory implements Factory<GraphEdge> {
        
        public GraphEdge create() {
            return new GraphEdge(0.0);
        }
    }

    private Graph<GraphVertex, GraphEdge> graph = null;
    
    //private Layout<GraphVertex, GraphEdge> graphLayout = null;

    private AggregateLayout<GraphVertex, GraphEdge> graphLayout = null;
    
    private VisualizationViewer visViewer = null;

    private PickedState<GraphVertex> pickState = null;

    private GraphMouse graphMouse = null;

    // For storing tentative graph
    private Hashtable<String, GraphVertex> vertexHashtable = new Hashtable<String, GraphVertex>();

    private List<GraphEdge> edgeList = new Vector<GraphEdge>();

    private double threshold = 40.0;
    
    public GraphPanel() throws SQLException {
        // Create new graph
        graph = new SparseMultigraph<GraphVertex, GraphEdge>();

        // Build default graph layout
        graphLayout = new AggregateLayout<GraphVertex,GraphEdge>(new StaticLayout<GraphVertex,GraphEdge>(graph));
        graphLayout.setSize(Configuration.GraphLayoutDimension);
        
        // Build the visualization model
        VisualizationModel<GraphVertex,GraphEdge> visualizationModel = new DefaultVisualizationModel<GraphVertex,GraphEdge>(graphLayout, Configuration.GraphLayoutDimension);
        visViewer = new VisualizationViewer<GraphVertex, GraphEdge>(visualizationModel, Configuration.GraphLayoutDimension);

        pickState = visViewer.getPickedVertexState();

//        // Build vis server
//        visViewer = new VisualizationViewer<GraphVertex, GraphEdge>(graphLayout);
//        visViewer.setPreferredSize(Configuration.GraphLayoutDimension);

//        // Build layout
//        switch ( Configuration.Layout ) {
//            case FRLayout:
//                graphLayout = new FRLayout(graph);
//                graphLayout.setSize(Configuration.GraphLayoutDimension);
//                break;
//            case CircleLayout:
//                graphLayout = new CircleLayout(graph);
//                graphLayout.setSize(Configuration.GraphLayoutDimension);
//                break;
//            case SpringLayout:
//                graphLayout = new SpringLayout(graph);
//                graphLayout.setSize(Configuration.GraphLayoutDimension);
//                break;
//            default:
//                graphLayout = new SpringLayout(graph);
//                graphLayout.setSize(Configuration.GraphLayoutDimension);
//                break;
//        }

        // Build vertices and edges
        // createdTentativeGraph();

        // Set graph paint styple
        setupPaintStyle();

        // Create a graph mouse and add it to the visualization component
        createAndSetGraphMouse();

        // Add the new graph
        this.setLayout(new BorderLayout());
        this.add(visViewer, BorderLayout.CENTER);

        visViewer.addGraphMouseListener(this);
    }

    protected void createAndSetGraphMouse() {
        if ( visViewer != null ) {
            graphMouse = new EditingModalGraphMouse<GraphVertex,GraphEdge>(
                    visViewer.getRenderContext(),
                    new VertexFactory(), new EdgeFactory());
            ((EditingModalGraphMouse)graphMouse).setMode(RuntimeVariables.WORKING_MODE);
            visViewer.setGraphMouse(graphMouse);
            visViewer.addGraphMouseListener(this);
        }
    }

//    protected void createdTentativeGraph() throws SQLException {
//        String queryStatement = null;
//        ResultSet rs = null;
//        Connection conn = AccessJDBCUtil.getAccessDBConnection(Configuration.DB_FILE_PATH);
//        Statement statement = conn.createStatement();
//
//        List<GraphVertex> firstVertexList = new Vector<GraphVertex>();
//        List<GraphVertex> secondVertexList = new Vector<GraphVertex>();
//        List<GraphVertex> thirdVertexList = new Vector<GraphVertex>();
//
//        String stringValue = null;
//        boolean queryResult = false;
//        ResultSetMetaData metaData = null;
//        int cols = Record.attributeNameArray.length;
//
//        ////// Add vertices /////
//        Record record = null;
//        GraphVertex vertex = null;
//
//        // query for gene_symbol='KIAA0859'
//        queryStatement = String.format("Select * From List Where gene_symbol='KIAA0859'");
//        queryResult = statement.execute(queryStatement);
//        rs = statement.getResultSet();
//
//        metaData = rs.getMetaData();
//        cols = metaData.getColumnCount();
//
//        while ( rs.next() ) {
//            record = new Record();
//            for(int i = 1;i <= cols;i++) {
//                stringValue = rs.getString(i);
//                record.setAttributeObject(i-1, stringValue);
//            }
//            //vertex = new GraphVertex(record);
//            graph.addVertex(vertex);
//            firstVertexList.add(vertex);
//        }
//
//        // query for gene_symbol='ANKRD20A2'
//        queryStatement = String.format("Select * From List Where gene_symbol='ANKRD20A2'");
//        queryResult = statement.execute(queryStatement);
//        rs = statement.getResultSet();
//
//        metaData = rs.getMetaData();
//        cols = metaData.getColumnCount();
//
//        while ( rs.next() ) {
//            record = new Record();
//            for(int i = 1;i <= cols;i++) {
//                stringValue = rs.getString(i);
//                record.setAttributeObject(i-1, stringValue);
//            }
//            //vertex = new GraphVertex(record);
//            graph.addVertex(vertex);
//            secondVertexList.add(vertex);
//        }
//
//        // query for gene_symbol='PABPC3'
//        queryStatement = String.format("Select * From List Where gene_symbol='PABPC3'");
//        queryResult = statement.execute(queryStatement);
//        rs = statement.getResultSet();
//
//        metaData = rs.getMetaData();
//        cols = metaData.getColumnCount();
//
//        while ( rs.next() ) {
//            record = new Record();
//            for(int i = 1;i <= cols;i++) {
//                stringValue = rs.getString(i);
//                record.setAttributeObject(i-1, stringValue);
//            }
//            //vertex = new GraphVertex(record);
//            graph.addVertex(vertex);
//            thirdVertexList.add(vertex);
//        }
//
//        // Add edges
//        GraphEdge edge = null;
//
//        // Two edges for each graph
//        edge = new GraphEdge(1);
//        graph.addEdge(edge, firstVertexList.get(0) , secondVertexList.get(1));
//        edge = new GraphEdge(1);
//        graph.addEdge(edge, firstVertexList.get(1) , thirdVertexList.get(2));
//        edge = new GraphEdge(1);
//        graph.addEdge(edge, secondVertexList.get(2) , thirdVertexList.get(0));
//
//        // Set the initial layout and set sub layout
//        // First SubGraph
//        Graph<GraphVertex, GraphEdge> subGraph = null;
//        try {
//            subGraph = graph.getClass().newInstance();
//        } catch (InstantiationException ex) {
//            Logger.getLogger(GraphPanel.class.getName()).log(Level.SEVERE, null, ex);
//        } catch (IllegalAccessException ex) {
//            Logger.getLogger(GraphPanel.class.getName()).log(Level.SEVERE, null, ex);
//        }
//        for ( GraphVertex v : firstVertexList) {
//            subGraph.addVertex(v);
//            Collection<GraphEdge> incidentEdges = graph.getIncidentEdges(vertex);
//            for(GraphEdge e : incidentEdges) {
//                Pair<GraphVertex> endpoints = graph.getEndpoints(e);
////                if(picked.containsAll(endpoints)) {
////                    // put this edge into the subgraph
////                    subGraph.addEdge(edge, endpoints.getFirst(), endpoints.getSecond());
////                }
//            }
//        }
//        Layout<GraphVertex,GraphEdge> subLayout = new CircleLayout<GraphVertex,GraphEdge>(subGraph);
//        subLayout.setInitializer(visViewer.getGraphLayout());
//        subLayout.setSize(new Dimension(200,200));
//        graphLayout.put(subLayout,new Point2D.Double(300, 300));
//
//        // Set the initial layout and set sub layout
//        subGraph = null;
//        try {
//            subGraph = graph.getClass().newInstance();
//        } catch (InstantiationException ex) {
//            Logger.getLogger(GraphPanel.class.getName()).log(Level.SEVERE, null, ex);
//        } catch (IllegalAccessException ex) {
//            Logger.getLogger(GraphPanel.class.getName()).log(Level.SEVERE, null, ex);
//        }
//        for ( GraphVertex v : secondVertexList) {
//            subGraph.addVertex(v);
//            Collection<GraphEdge> incidentEdges = graph.getIncidentEdges(vertex);
//            for(GraphEdge e : incidentEdges) {
//                Pair<GraphVertex> endpoints = graph.getEndpoints(e);
////                if(picked.containsAll(endpoints)) {
////                    // put this edge into the subgraph
////                    subGraph.addEdge(edge, endpoints.getFirst(), endpoints.getSecond());
////                }
//            }
//        }
//
//        subLayout = new CircleLayout<GraphVertex,GraphEdge>(subGraph);
//        subLayout.setInitializer(visViewer.getGraphLayout());
//        subLayout.setSize(new Dimension(200,200));
//        graphLayout.put(subLayout,new Point2D.Double(300, 700));
//
//        // Set the initial layout and set sub layout
//        subGraph = null;
//        try {
//            subGraph = graph.getClass().newInstance();
//        } catch (InstantiationException ex) {
//            Logger.getLogger(GraphPanel.class.getName()).log(Level.SEVERE, null, ex);
//        } catch (IllegalAccessException ex) {
//            Logger.getLogger(GraphPanel.class.getName()).log(Level.SEVERE, null, ex);
//        }
//        for ( GraphVertex v : thirdVertexList) {
//            subGraph.addVertex(v);
//            Collection<GraphEdge> incidentEdges = graph.getIncidentEdges(vertex);
//            for(GraphEdge e : incidentEdges) {
//                Pair<GraphVertex> endpoints = graph.getEndpoints(e);
////                if(picked.containsAll(endpoints)) {
////                    // put this edge into the subgraph
////                    subGraph.addEdge(edge, endpoints.getFirst(), endpoints.getSecond());
////                }
//            }
//        }
//
//        subLayout = new CircleLayout<GraphVertex,GraphEdge>(subGraph);
//        subLayout.setInitializer(visViewer.getGraphLayout());
//        subLayout.setSize(new Dimension(200,200));
//        graphLayout.put(subLayout,new Point2D.Double(500, 500));
//        visViewer.setGraphLayout(graphLayout);
//
//        statement.close();
//        conn.close();
//    }

    protected void setupPaintStyle() {
        // Setup different transformer

        // set vertex label transformer
        showVertexLabel(
                    RuntimeVariables.ShowVertexDominantPathway
                    || RuntimeVariables.ShowVertexName
                    || RuntimeVariables.ShowVertexValue);

        // set vertex value transformer
        //showVertexValue(RuntimeVariables.ShowVertexValue);

        // set vertex stoke transformer
        setVertexStokeHighlight(RuntimeVariables.VertexStrokeHighlight);

        // set vertex predicate
        setVertexPredicate(RuntimeVariables.FilterVertices,RuntimeVariables.FilterVerticesValue);

        // set edge label transformer
        showEdgeValue(RuntimeVariables.ShowEdgeValue);

        // set edge shape transformer
        setEdgeShape(RuntimeVariables.EdgeShape);

        // highlight edge transformer
        setEdgeWeight(RuntimeVariables.HighlightEdge, RuntimeVariables.HighlightEdgeValue);

//        // Setup up a new vertex to paint transformer...
//        Transformer<GraphVertex, Paint> vertexPaint = new Transformer<GraphVertex,Paint>() {
//            public Paint transform(GraphVertex v) {
//                if ( v.vertexType == GraphVertex.DieseaseVertex ) {
//                    return Color.GREEN;
//                }
//                else if ( v.vertexType == GraphVertex.FeatureVertex ) {
//                    return Color.RED;
//                }
//                else {
//                    return Color.BLACK;
//                }
//            }
//        };
//        visViewer.getRenderContext().setVertexFillPaintTransformer(vertexPaint);

//        // Set up a new stroke Transformer for the edges
//        float dash[] = {10.0f};
//        final Stroke edgeStroke = new BasicStroke(1.0f, BasicStroke.CAP_BUTT, BasicStroke.JOIN_MITER, 10.0f, dash, 0.0f);
//        final Stroke highlightedEdgeStroke = new BasicStroke(3);
//        Transformer<GraphEdge, Stroke> edgeStrokeTransformer = new Transformer<GraphEdge, Stroke>() {
//            public Stroke transform(GraphEdge e) {
//                if ( e.significantEdge ) {
//                    return highlightedEdgeStroke;
//                }
//                else {
//                    return edgeStroke;
//                }
//            }
//        };
//        visViewer.getRenderContext().setEdgeStrokeTransformer(edgeStrokeTransformer);

//        // Emphasis different edge
//        Transformer<GraphEdge, Paint> edgePaint = new Transformer<GraphEdge, Paint>() {
//            public Paint transform(GraphEdge e) {
//                if ( e.significantEdge ) {
//                    return Color.BLUE;
//                }
//                else {
//                    return Color.BLACK;
//                }
//            }
//        };
//        visViewer.getRenderContext().setEdgeDrawPaintTransformer(edgePaint);
    }

    public VisualizationViewer getVisualizationViewer() {
        return visViewer;
    }

    public void graphClicked(Object v, MouseEvent e) {
        // Empty
    }

    public void graphPressed(Object v, MouseEvent e) {
        // Empty
    }

    public void graphReleased(Object v, MouseEvent e) {
        // Is picking mode
        if ( RuntimeVariables.WORKING_MODE == ModalGraphMouse.Mode.PICKING ) {
            EditingModalGraphMouse gm = (EditingModalGraphMouse) visViewer.getGraphMouse();
            Collection<GraphVertex> pickedVertices = pickState.getPicked();

            if ( pickedVertices.size() == 1 ) {
                GraphVertex[] vertices = new GraphVertex[1];
                pickedVertices.toArray(vertices);
                RuntimeVariables.NodePropertyPanel.setCurrentNode(vertices[0]);
                RuntimeVariables.NodePropertyPanel.invalidate();
            }
        }
    }

//    public void setGraph(BOOSTResultFile boostResultFile) {
//        // Clear old elements and rebuild the graph
//        vertexHashtable.clear();
//        edgeList.clear();
//
//        ////////////////////////////////////////////////////////////////////////
//        // Rebuild the graph again
//        // Create new graph
//        graph = new SparseMultigraph<GraphVertex, GraphEdge>();
//
//        // Build default graph layout
//        graphLayout = new AggregateLayout<GraphVertex,GraphEdge>(new StaticLayout<GraphVertex,GraphEdge>(graph));
//        graphLayout.setSize(Configuration.GraphLayoutDimension);
//
//        // Build the visualization model
//        VisualizationModel<GraphVertex,GraphEdge> visualizationModel = new DefaultVisualizationModel<GraphVertex,GraphEdge>(graphLayout, Configuration.GraphLayoutDimension);
//        visViewer = new VisualizationViewer<GraphVertex, GraphEdge>(visualizationModel, Configuration.GraphLayoutDimension);
//
//        pickState = visViewer.getPickedVertexState();
//
//        // Set graph paint styple
//        setupPaintStyle();
//
//        // Create a graph mouse and add it to the visualization component
//        createAndSetGraphMouse();
//
//        // Add the new graph
//        this.removeAll();
//        this.setLayout(new BorderLayout());
//        this.add(visViewer, BorderLayout.CENTER);
//
//        visViewer.addGraphMouseListener(this);
//
//        ////////////////////////////////////////////////////////////////////////
//
//        // Add vertex for each snp (each item may has at most two snp records, use snpname as the search key)
//        List<BOOSTResultItem> itemList = boostResultFile.getBOOSTResultItemList();
//        GraphVertex vertex = null;
//
//        for ( BOOSTResultItem item : itemList ) {
//            if ( item.boostValue > threshold ) {
//                // Add the first vertex
//                if ( !vertexHashtable.containsKey(item.snpName1) ) {
//                    vertex = new GraphVertex(item.snpName1, item.snpValue1);
//                    vertexHashtable.put(item.snpName1, vertex);
//                    graph.addVertex(vertex);
//                }
//                // Add the secord vertex
//                if ( !vertexHashtable.containsKey(item.snpName2) ) {
//                    vertex = new GraphVertex(item.snpName2, item.snpValue2);
//                    vertexHashtable.put(item.snpName2, vertex);
//                    graph.addVertex(vertex);
//                }
//            }
//        }
//
//        // For each vertex
//        Hashtable<String, SparseMultigraph<GraphVertex, GraphEdge>> subGraphHashtable = new Hashtable<String, SparseMultigraph<GraphVertex, GraphEdge>>();
//        SparseMultigraph<GraphVertex, GraphEdge> subGraph = null;
//        SparseMultigraph<GraphVertex, GraphEdge> subGraphWithUnknownPathway = new SparseMultigraph<GraphVertex, GraphEdge>();
//
//        SNPPathWayDataFile snpPathWayDataFile = RuntimeVariables.snpPathWayDataFile;
//        Hashtable<String, Integer> snpPathwayCountTable = new Hashtable();
//        List<String> pathWayList = null;
//        Enumeration<GraphVertex> vertexSet = vertexHashtable.elements();
//        snpPathwayCountTable.put("UnKnownPathWay", 0);
//
//        String dominentPathway = null;
//
//        // Assign the pathwaylist and count for occurrance
//        while(vertexSet.hasMoreElements()){
//            vertex = vertexSet.nextElement();
//            pathWayList = snpPathWayDataFile.getPathwayList(vertex.getVertexLabel());
//
//            if ( pathWayList != null ) {
//                vertex.setPathWayList(pathWayList);
//                for ( String s : pathWayList ) {
//                    if ( !snpPathwayCountTable.containsKey(s) ) {
//                        // Create a new entry
//                        snpPathwayCountTable.put(s, 1);
//                    }
//                    else {
//                        // Increment an existed entry
//                        int count = (Integer) snpPathwayCountTable.get(s);
//                        snpPathwayCountTable.put(s, count + 1);
//                    }
//                }
//            }
//            else {
//                int count = (Integer) snpPathwayCountTable.get("UnKnownPathWay");
//                snpPathwayCountTable.put("UnKnownPathWay", count + 1);
//            }
//        }
//
//        // Reset the vertexset
//        vertexSet = vertexHashtable.elements();
//
//        // Assign the domain pathway in each vertex
//        while(vertexSet.hasMoreElements()){
//            vertex = vertexSet.nextElement();
//            pathWayList = vertex.getPathWayList();
//
//            if ( pathWayList != null ) {
//                int max = -1, curr = 0;
//                int index = 0;
//                int dominentIndex = -1;
//                for ( String s : pathWayList ) {
//                    curr = snpPathwayCountTable.get(s);
//                    if ( max < curr ) {
//                        max = curr;
//                        dominentIndex = index;
//                    }
//
//                    // update the index
//                    index++;
//                }
//                dominentPathway = pathWayList.get(dominentIndex);
//                vertex.setDominantPathWay(dominentPathway);
//
//                if ( !subGraphHashtable.containsKey(dominentPathway) ) {
//                    subGraph = new SparseMultigraph<GraphVertex, GraphEdge>();
//                    subGraph.addVertex(vertex);
//                    subGraphHashtable.put(dominentPathway, subGraph);
//                }
//                else {
//                    subGraph = subGraphHashtable.get(dominentPathway);
//                    subGraph.addVertex(vertex);
//                }
//            }
//            else {
//                vertex.setDominantPathWay("UnknownPathWay");
//                subGraphWithUnknownPathway.addVertex(vertex);
//            }
//        }
//
//        // add neccessary graph edge accordingly
//        boolean removeUnwantedVerticesAndEdges = true;
//        boolean removeZeroEdgeVertices = true;
//
//        GraphEdge edge = null;
//        GraphVertex start = null, end = null;
//        for ( BOOSTResultItem item : itemList ) {
//            if ( item.boostValue > threshold ) {
//                // Create edge for each snp pair
//                start = vertexHashtable.get(item.snpName1);
//                end = vertexHashtable.get(item.snpName2);
//                if ( removeUnwantedVerticesAndEdges ) {
//                    if (!start.getDomainPathWay().equals("UnknownPathWay") || !end.getDomainPathWay().equals("UnknownPathWay")) {
//                        edge = new GraphEdge(item);
//                        graph.addEdge(edge, start, end);
//                    }
//                    else {
//                        // Skip and do not add edge
//                    }
//                }
//                else {
//                    edge = new GraphEdge(item);
//                    graph.addEdge(edge, start, end);
//                }
//            }
//        }
//
//        if ( removeZeroEdgeVertices ) {
//            Collection<GraphVertex> vertexCollection = null;
//            vertexSet = vertexHashtable.elements();
//
//            // for each vertex
//            while(vertexSet.hasMoreElements()){
//                vertex = vertexSet.nextElement();
//                vertexCollection = graph.getNeighbors(vertex);
//
//                // Vertex without neighbor
//                if ( vertexCollection != null && vertexCollection.size() == 0 ) {
//                    //graph.removeVertex(vertex);
//                    subGraphWithUnknownPathway.removeVertex(vertex);
//                }
//            }
//        }
//
//        int pathwayDrawSize = 200;
//        Dimension pathwayDrawDimension = new Dimension(pathwayDrawSize,pathwayDrawSize);
//        int numberOfPathwayOn2DPlane = (int) Math.floor(Math.sqrt(snpPathwayCountTable.size()));
//        if ( numberOfPathwayOn2DPlane % 2 == 0 ) {
//            numberOfPathwayOn2DPlane = numberOfPathwayOn2DPlane+1;
//        }
//        // i.e. Starting center should be (pathwayDrawSize*centerX, pathwayDrawSize*centerY)
//        int centerX = numberOfPathwayOn2DPlane / 2, centerY = numberOfPathwayOn2DPlane / 2;
//        graphLayout.setSize(new Dimension(numberOfPathwayOn2DPlane*pathwayDrawSize, numberOfPathwayOn2DPlane*pathwayDrawSize));
//
//        Layout<GraphVertex,GraphEdge> subLayout = null;
//
//        // place the unknownpathway subgraph in the center
//        subLayout = new CircleLayout<GraphVertex,GraphEdge>(subGraphWithUnknownPathway);
//        subLayout.setInitializer(visViewer.getGraphLayout());
//        subLayout.setSize(pathwayDrawDimension);
//        graphLayout.put(subLayout, new Point2D.Double(centerX*pathwayDrawSize+pathwayDrawSize/2, centerY*pathwayDrawSize+pathwayDrawSize/2));
//
//        if ( subGraphHashtable.size() != 0 ) {
//            // for each subgraph
//            //Enumeration<SparseMultigraph<GraphVertex, GraphEdge>> subGraphSet =  subGraphHashtable.elements();
//            ArrayList<SparseMultigraph<GraphVertex, GraphEdge>> subGraphSetList = new ArrayList<SparseMultigraph<GraphVertex, GraphEdge>>();
//            for ( Enumeration<SparseMultigraph<GraphVertex, GraphEdge>> e = subGraphHashtable.elements(); e.hasMoreElements(); ) {
//                subGraphSetList.add(e.nextElement());
//            }
//            Collections.sort(subGraphSetList, new GraphComparator());
//
//            // determine the four corner
//            int upperLeftX = centerX-1, upperLeftY = centerY-1;
//            int upperRightX = centerX+1, upperRightY = centerY-1;
//            int lowerLeftX = centerX-1, lowerLeftY = centerY+1;
//            int lowerRightX = centerX+1, lowerRightY = centerY+1;
//
//            // 0 East, 1 South, 2 West, 3 North
//            int direction = 0;
//            int currX = centerX, currY = centerY-1;
//            int count = 0;
//            //while ( subGraphSet.hasMoreElements() ) {
//            for ( SparseMultigraph<GraphVertex, GraphEdge> g : subGraphSetList ) {
//                System.out.println("Count : " + (count+1) + ",X : " + currX + ",Y : " + currY);
//                //subGraph = subGraphSet.nextElement();
//                subGraph = g;
//                subLayout = new CircleLayout<GraphVertex,GraphEdge>(subGraph);
//                subLayout.setInitializer(visViewer.getGraphLayout());
//                subLayout.setSize(pathwayDrawDimension);
//                graphLayout.put(subLayout,new Point2D.Double(currX*pathwayDrawSize+pathwayDrawSize/2, currY*pathwayDrawSize+pathwayDrawSize/2));
//
//                // hit the upper left corner
//                if ( currX == upperLeftX && currY == upperLeftY ) {
//                    direction = 0;
//                    upperLeftX--; upperLeftY--;
//                    upperRightX++; upperRightY--;
//                    lowerLeftX--; lowerLeftY++;
//                    lowerRightX++; lowerRightY++;
//
//                    // to the next position
//                    currY--;
//                }
//                else {
//                    // if we are now on other corner points
//                    if (  (currX == upperRightX && currY == upperRightY)
//                        || (currX == lowerRightX && currY == lowerRightY)
//                        || (currX == lowerLeftX && currY == lowerLeftY)) {
//                        direction++;
//                    }
//
//                    // update the position
//                    switch ( direction ) {
//                        case 0:
//                            currX++;
//                            break;
//                        case 1:
//                            currY++;
//                            break;
//                        case 2:
//                            currX--;
//                            break;
//                        case 3:
//                            currY--;
//                            break;
//                        default:
//                    }
//                }
//
//                count++;
//            }
//        }
//
//        // adjust to appropicate scale
//        ScalingControl scaler = new CrossoverScalingControl();
//        visViewer.scaleToLayout(scaler);
//
//        // update the final layout
//        visViewer.setGraphLayout(graphLayout);
//    }

    public void setGraph(List<BOOSTResultItem> itemList) {
        // Clear old elements and rebuild the graph
        vertexHashtable.clear();
        edgeList.clear();

        ////////////////////////////////////////////////////////////////////////
        // Rebuild the graph again
        // Create new graph
        graph = new SparseMultigraph<GraphVertex, GraphEdge>();

        // Build default graph layout
        graphLayout = new AggregateLayout<GraphVertex,GraphEdge>(new StaticLayout<GraphVertex,GraphEdge>(graph));
        graphLayout.setSize(Configuration.GraphLayoutDimension);
//        graphLayout.removeAll();
//        graphLayout.reset();
//        graphLayout.setGraph(graph);
//        graphLayout.setSize(Configuration.GraphLayoutDimension);

        // Build the visualization model
        visViewer.setGraphLayout(graphLayout);
        VisualizationModel<GraphVertex,GraphEdge> visualizationModel = new DefaultVisualizationModel<GraphVertex,GraphEdge>(graphLayout, Configuration.GraphLayoutDimension);
        visViewer = new VisualizationViewer<GraphVertex, GraphEdge>(visualizationModel, Configuration.GraphLayoutDimension);

        pickState = visViewer.getPickedVertexState();

        // Set graph paint styple
        setupPaintStyle();

        // Create a graph mouse and add it to the visualization component
        createAndSetGraphMouse();

        // Add the new graph
        this.removeAll();
        this.setLayout(new BorderLayout());
        this.add(visViewer, BorderLayout.CENTER);

        ////////////////////////////////////////////////////////////////////////

        // Add vertex for each snp (each item may has at most two snp records, use snpname as the search key)
        GraphVertex vertex = null;
        for ( BOOSTResultItem item : itemList ) {
            // Add the first vertex
            if ( !vertexHashtable.containsKey(item.snpName1) ) {
                vertex = new GraphVertex(item.snpName1, item.snpValue1);
                vertexHashtable.put(item.snpName1, vertex);
                graph.addVertex(vertex);
            }
            // Add the secord vertex
            if ( !vertexHashtable.containsKey(item.snpName2) ) {
                vertex = new GraphVertex(item.snpName2, item.snpValue2);
                vertexHashtable.put(item.snpName2, vertex);
                graph.addVertex(vertex);
            }
        }

        // For each vertex
        Hashtable<String, SparseMultigraph<GraphVertex, GraphEdge>> subGraphHashtable = new Hashtable<String, SparseMultigraph<GraphVertex, GraphEdge>>();
        SparseMultigraph<GraphVertex, GraphEdge> subGraph = null;
        SparseMultigraph<GraphVertex, GraphEdge> subGraphWithUnknownPathway = new SparseMultigraph<GraphVertex, GraphEdge>();

        SNPPathWayDataFile snpPathWayDataFile = RuntimeVariables.snpPathWayDataFile;
        Hashtable<String, Integer> snpPathwayCountTable = new Hashtable();
        List<String> pathWayList = null;
        Enumeration<GraphVertex> vertexSet = vertexHashtable.elements();
        snpPathwayCountTable.put("UnKnownPathWay", 0);

        String dominentPathway = null;

        // Assign the pathwaylist and count for occurrance
        while(vertexSet.hasMoreElements()){
            vertex = vertexSet.nextElement();
            pathWayList = snpPathWayDataFile.getPathwayList(vertex.getVertexLabel());

            if ( pathWayList != null ) {
                vertex.setPathWayList(pathWayList);
                for ( String s : pathWayList ) {
                    if ( !snpPathwayCountTable.containsKey(s) ) {
                        // Create a new entry
                        snpPathwayCountTable.put(s, 1);
                    }
                    else {
                        // Increment an existed entry
                        int count = (Integer) snpPathwayCountTable.get(s);
                        snpPathwayCountTable.put(s, count + 1);
                    }
                }
            }
            else {
                int count = (Integer) snpPathwayCountTable.get("UnKnownPathWay");
                snpPathwayCountTable.put("UnKnownPathWay", count + 1);
            }
        }

        // Reset the vertexset
        vertexSet = vertexHashtable.elements();

        // Assign the domain pathway in each vertex
        while(vertexSet.hasMoreElements()){
            vertex = vertexSet.nextElement();
            pathWayList = vertex.getPathWayList();

            if ( pathWayList != null ) {
                int max = -1, curr = 0;
                int index = 0;
                int dominentIndex = -1;
                for ( String s : pathWayList ) {
                    curr = snpPathwayCountTable.get(s);
                    if ( max < curr ) {
                        max = curr;
                        dominentIndex = index;
                    }

                    // update the index
                    index++;
                }
                dominentPathway = pathWayList.get(dominentIndex);
                vertex.setDominantPathWay(dominentPathway);

                if ( !subGraphHashtable.containsKey(dominentPathway) ) {
                    subGraph = new SparseMultigraph<GraphVertex, GraphEdge>();
                    subGraph.addVertex(vertex);
                    subGraphHashtable.put(dominentPathway, subGraph);
                }
                else {
                    subGraph = subGraphHashtable.get(dominentPathway);
                    subGraph.addVertex(vertex);
                }
            }
            else {
                vertex.setDominantPathWay("UnknownPathWay");
                subGraphWithUnknownPathway.addVertex(vertex);
            }
        }

        // add all graph edge
        GraphEdge edge = null;
        GraphVertex start = null, end = null;
        for ( BOOSTResultItem item : itemList ) {
            // Create edge for each snp pair
            start = vertexHashtable.get(item.snpName1);
            end = vertexHashtable.get(item.snpName2);
            edge = new GraphEdge(item);
            graph.addEdge(edge, start, end);
        }

//        // add neccessary graph edge accordingly
//        boolean removeUnwantedVerticesAndEdges = true;
//        boolean removeZeroEdgeVertices = true;
//
//        GraphEdge edge = null;
//        GraphVertex start = null, end = null;
//        for ( BOOSTResultItem item : itemList ) {
//            // Create edge for each snp pair
//            start = vertexHashtable.get(item.snpName1);
//            end = vertexHashtable.get(item.snpName2);
//            if ( removeUnwantedVerticesAndEdges ) {
//                if (!start.getDomainPathWay().equals("UnknownPathWay") || !end.getDomainPathWay().equals("UnknownPathWay")) {
//                    edge = new GraphEdge(item);
//                    graph.addEdge(edge, start, end);
//                }
//                else {
//                    // Skip and do not add edge
//                }
//            }
//            else {
//                edge = new GraphEdge(item);
//                graph.addEdge(edge, start, end);
//            }
//        }

//        if ( removeZeroEdgeVertices ) {
//            Collection<GraphVertex> vertexCollection = null;
//            vertexSet = vertexHashtable.elements();
//
//            // for each vertex
//            while(vertexSet.hasMoreElements()){
//                vertex = vertexSet.nextElement();
//                vertexCollection = graph.getNeighbors(vertex);
//
//                // Vertex without neighbor
//                if ( vertexCollection != null && vertexCollection.size() == 0 ) {
//                    //graph.removeVertex(vertex);
//                    subGraphWithUnknownPathway.removeVertex(vertex);
//                }
//            }
//        }

        int pathwayDrawSize = 200;
        Dimension pathwayDrawDimension = new Dimension(pathwayDrawSize,pathwayDrawSize);
        int numberOfPathwayOn2DPlane = (int) Math.floor(Math.sqrt(snpPathwayCountTable.size()));
        if ( numberOfPathwayOn2DPlane % 2 == 0 ) {
            numberOfPathwayOn2DPlane = numberOfPathwayOn2DPlane+1;
        }
        // i.e. Starting center should be (pathwayDrawSize*centerX, pathwayDrawSize*centerY)
        int centerX = numberOfPathwayOn2DPlane / 2, centerY = numberOfPathwayOn2DPlane / 2;
        graphLayout.setSize(new Dimension(numberOfPathwayOn2DPlane*pathwayDrawSize, numberOfPathwayOn2DPlane*pathwayDrawSize));

        Layout<GraphVertex,GraphEdge> subLayout = null;
        // place the unknownpathway subgraph in the center
        if ( subGraphWithUnknownPathway.getVertexCount() != 0 ) {
            subLayout = new CircleLayout<GraphVertex,GraphEdge>(subGraphWithUnknownPathway);
            subLayout.setInitializer(visViewer.getGraphLayout());
            subLayout.setSize(pathwayDrawDimension);
            graphLayout.put(subLayout, new Point2D.Double(centerX*pathwayDrawSize+pathwayDrawSize/2, centerY*pathwayDrawSize+pathwayDrawSize/2));
        }

        if ( subGraphHashtable.size() != 0 ) {
            // for each subgraph
            //Enumeration<SparseMultigraph<GraphVertex, GraphEdge>> subGraphSet =  subGraphHashtable.elements();
            ArrayList<SparseMultigraph<GraphVertex, GraphEdge>> subGraphSetList = new ArrayList<SparseMultigraph<GraphVertex, GraphEdge>>();
            for ( Enumeration<SparseMultigraph<GraphVertex, GraphEdge>> e = subGraphHashtable.elements(); e.hasMoreElements(); ) {
                subGraphSetList.add(e.nextElement());
            }
            Collections.sort(subGraphSetList, new GraphComparator());

            // determine the four corner
            int upperLeftX = centerX-1, upperLeftY = centerY-1;
            int upperRightX = centerX+1, upperRightY = centerY-1;
            int lowerLeftX = centerX-1, lowerLeftY = centerY+1;
            int lowerRightX = centerX+1, lowerRightY = centerY+1;

            // 0 East, 1 South, 2 West, 3 North
            int direction = 0;
            int currX = centerX, currY = centerY-1;
            int count = 0;
            //while ( subGraphSet.hasMoreElements() ) {
            for ( SparseMultigraph<GraphVertex, GraphEdge> g : subGraphSetList ) {
                //System.out.println("Count : " + (count+1) + ",X : " + currX + ",Y : " + currY);
                //subGraph = subGraphSet.nextElement();
                subGraph = g;
                subLayout = new CircleLayout<GraphVertex,GraphEdge>(subGraph);
                subLayout.setInitializer(visViewer.getGraphLayout());
                subLayout.setSize(pathwayDrawDimension);
                graphLayout.put(subLayout,new Point2D.Double(currX*pathwayDrawSize+pathwayDrawSize/2, currY*pathwayDrawSize+pathwayDrawSize/2));

                // hit the upper left corner
                if ( currX == upperLeftX && currY == upperLeftY ) {
                    direction = 0;
                    upperLeftX--; upperLeftY--;
                    upperRightX++; upperRightY--;
                    lowerLeftX--; lowerLeftY++;
                    lowerRightX++; lowerRightY++;

                    // to the next position
                    currY--;
                }
                else {
                    // if we are now on other corner points
                    if (  (currX == upperRightX && currY == upperRightY)
                        || (currX == lowerRightX && currY == lowerRightY)
                        || (currX == lowerLeftX && currY == lowerLeftY)) {
                        direction++;
                    }

                    // update the position
                    switch ( direction ) {
                        case 0:
                            currX++;
                            break;
                        case 1:
                            currY++;
                            break;
                        case 2:
                            currX--;
                            break;
                        case 3:
                            currY--;
                            break;
                        default:
                    }
                }

                count++;
            }
        }

        // adjust to appropicate scale
        ScalingControl scaler = new CrossoverScalingControl();
        visViewer.scaleToLayout(scaler);

        // update the final layout
        visViewer.setGraphLayout(graphLayout);

        // Trigger relayout event
        this.getParent().validate();
    }

//    public void setViewPoint(Point2D p, Dimension d) {
//        if ( visViewer != null ) {
//            MutableTransformer viewTransformer = visViewer.getRenderContext().getMultiLayerTransformer().getTransformer(Layer.VIEW);
//            Point2D center = visViewer.getCenter();
//            Dimension visDimension = visViewer.getSize(null);
//            double scaleX = visDimension.getWidth()/d.getWidth(), scaleY = visDimension.getHeight()/d.getHeight();
//            //viewTransformer.translate(center.getX()-p.getX(), center.getY()-p.getY());
//            viewTransformer.scale(scaleX, scaleY, p);
//            //scaler.scale(vv.getServer(), in, mouse);
//        }
//    }

    public RenderContext getRenderContext() {
        if ( visViewer != null ) {
            return visViewer.getRenderContext();
        }
        else {
            return null;
        }
    }

//    public () {
//        AnnotatingModalGraphMouse gm = null;
//        gm.get
//    }

    public GraphMouse getGraphMouse() {
        if ( visViewer != null ) {
            return visViewer.getGraphMouse();
        }
        else {
            return null;
        }
    }

    public void setGraphMouse(ModalGraphMouse.Mode mode) {
        if ( visViewer != null ) {
            ModalGraphMouse gm = (ModalGraphMouse) visViewer.getGraphMouse();
            gm.setMode(mode);
//            switch ( mode ) {
//                case TRANSFORMING:
//                case PICKING:
//                    //gm = new DefaultModalGraphMouse();
//                    //break;
//                case ANNOTATING:
//                    AnnotatingGraphMousePlugin<GraphVertex, GraphEdge> agmp = new AnnotatingGraphMousePlugin<GraphVertex, GraphEdge>(visViewer.getRenderContext());
//                    gm = new AnnotatingModalGraphMouse<GraphVertex, GraphEdge>(visViewer.getRenderContext(), agmp);
//                    break;
//                default:
//            }
//            gm.setMode(mode);
//
//            visViewer.setGraphMouse(gm);
        }
    }

    public double getThreshold() {
        return threshold;
    }

    public void setThreshold(double threshold) {
        this.threshold = threshold;
    }

    public void setVertexStokeHighlight(boolean isVertexStokeHighlight) {
        if ( visViewer != null ) {
            VertexStrokeHighlight<GraphVertex,GraphEdge> vsh = new VertexStrokeHighlight<GraphVertex,GraphEdge>(graph, visViewer.getPickedVertexState());
            VertexFillPaint<GraphVertex,GraphEdge> vfp = new VertexFillPaint<GraphVertex,GraphEdge>(graph, visViewer.getPickedVertexState());
            vsh.setHighlight(isVertexStokeHighlight);
            vfp.setHighlight(isVertexStokeHighlight);
            visViewer.getRenderContext().setVertexStrokeTransformer(vsh);
            visViewer.getRenderContext().setVertexFillPaintTransformer(vfp);
            repaint();
        }
    }

    public void showVertexLabel(boolean showVertexLabel) {
        if ( visViewer != null ) {
            if ( showVertexLabel ) {
                visViewer.getRenderContext().setVertexLabelTransformer(new ToStringLabeller());
                visViewer.getRenderer().getVertexLabelRenderer().setPosition(Position.S);
            }
            else {
                visViewer.getRenderContext().setVertexLabelTransformer(NULL_TRANSFORMER);
            }
            repaint();
        }
    }

    public void showVertexValue(boolean showVertexValue) {
        if ( visViewer != null ) {
            if ( showVertexValue ) {
                visViewer.getRenderContext().setVertexLabelTransformer(new ToStringLabeller());
                visViewer.getRenderer().getVertexLabelRenderer().setPosition(Position.S);
            }
            else {
                visViewer.getRenderContext().setVertexLabelTransformer(NULL_TRANSFORMER);
            }
            repaint();
        }
    }

    public void setEdgeShape(EDGE_SHAPE edgeShape) {
        if ( visViewer != null ) {
            switch ( edgeShape ) {
                case LINE:
                    visViewer.getRenderContext().setEdgeShapeTransformer(new EdgeShape.Line<GraphVertex, GraphEdge>());
                    break;
                case CURVE:
                    visViewer.getRenderContext().setEdgeShapeTransformer(new EdgeShape.QuadCurve<GraphVertex, GraphEdge>());
                    break;
                case ORTHOGONAL:
                    visViewer.getRenderContext().setEdgeShapeTransformer(new EdgeShape.Orthogonal<GraphVertex, GraphEdge>());
                    break;
                default:
                    visViewer.getRenderContext().setEdgeShapeTransformer(new EdgeShape.Line<GraphVertex, GraphEdge>());
                    break;
            }
            repaint();
        }
    }

    public void showEdgeValue(boolean showEdgeValue) {
        if ( visViewer != null ) {
            if ( showEdgeValue ) {
                visViewer.getRenderContext().setEdgeLabelTransformer(new ToStringLabeller());
            }
            else {
                visViewer.getRenderContext().setEdgeLabelTransformer(NULL_TRANSFORMER);
            }
            repaint();
        }
    }

    public void setEdgeWeight(boolean weighted, double value) {
        if ( visViewer != null ) {
            if ( weighted ) {
                visViewer.getRenderContext().setEdgeStrokeTransformer(
                    new EdgeWeightStrokeFunction<GraphEdge>(weighted, value));
            }
            else {
                visViewer.getRenderContext().setEdgeStrokeTransformer(NULL_TRANSFORMER);
            }
            repaint();
        }
    }

    public void setVertexPredicate(boolean filterVertexValue, double value) {
        if ( visViewer != null ) {
            visViewer.getRenderContext().setVertexIncludePredicate(
                    new VertexDisplayPredicate(filterVertexValue, value, false, 1));
            repaint();
        }
    }

    public int writeImage(String filename, String type) {
        if ( visViewer != null ) {
            int width = visViewer.getWidth();
            int height = visViewer.getHeight();

            BufferedImage bi = new BufferedImage(width, height, BufferedImage.TYPE_INT_RGB);
            Graphics2D graphics = bi.createGraphics();
            visViewer.paint(graphics);
            graphics.dispose();

            try {
                ImageIO.write(bi, type, new File(filename));
            } catch (Exception e) {
                e.printStackTrace();
                return -1;
            }
            return 0;
        }
        else {
            return -1;
        }
    }

//    public static void main(String[] args) throws Exception {
//        GraphPanel graphPanel = new GraphPanel();
//        RuntimeVariables.snpPathWayDataFile = new SNPPathWayDataFile(Configuration.SNP_PATHWAY_FILE_PATH);
//        BOOSTResultFile file = new BOOSTResultFile(
//                "C:\\Documents and Settings\\timyung\\Desktop\\TestFolder\\outputInteractionRecords.txt",
//                "C:\\Documents and Settings\\timyung\\Desktop\\TestFolder\\filenamelist.txt");
//        graphPanel.setGraph(file);
//
//        JFrame frame = new JFrame();
//        frame.setSize(800, 600);
//        frame.setLayout(new BorderLayout());
//        frame.getContentPane().add(graphPanel, BorderLayout.CENTER);
//        frame.setLocationRelativeTo(null);
//        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
//        frame.setVisible(true);
//    }

}
class GraphComparator implements Comparator {

    public int compare(Object o1, Object o2) {
        SparseMultigraph<GraphVertex, GraphEdge> graph1 = (SparseMultigraph<GraphVertex, GraphEdge>) o1;
        SparseMultigraph<GraphVertex, GraphEdge> graph2 = (SparseMultigraph<GraphVertex, GraphEdge>) o2;

        int edgeWithUnknownPathway1 = 0;
        int edgeWithUnknownPathway2 = 0;

        for ( GraphVertex v :  graph1.getVertices() ) {
            for ( GraphVertex neighborVertex : graph1.getNeighbors(v) ) {
                if ( neighborVertex.getDomainPathWay().equals("UnknownPathway") ) {
                    edgeWithUnknownPathway1++;
                }
            }
        }

        for ( GraphVertex v :  graph2.getVertices() ) {
            for ( GraphVertex neighborVertex : graph2.getNeighbors(v) ) {
                if ( neighborVertex.getDomainPathWay().equals("UnknownPathway") ) {
                    edgeWithUnknownPathway2++;
                }
            }
        }

        return edgeWithUnknownPathway1 - edgeWithUnknownPathway2;
    }

}