package Graph.Element;

import gboost_gui.RuntimeVariables;
import java.util.List;

/**
 *
 * @author timyung
 */
public class GraphVertex {

    //private Record record = null;

    private String vertexLabel = null;
    
    private double vertexValue = 0.0;

    private List<String> pathwayList = null;

    private String dominantPathWay = null;

    public GraphVertex(String vertexLabel, double value) {
        this.vertexLabel = vertexLabel;
        this.vertexValue = value;
    }

//    public GraphVertex(Record record) {
//        this.record = record;
//        this.vertexLabel = (String) record.getAttributeObject(0);
//    }

//    public Record getRecord() {
//        return record;
//    }
//
//    public void setRecord(Record record) {
//        this.record = record;
//    }

    public String getVertexLabel() {
        return vertexLabel;
    }

    public void setVertexLabel(String label) {
        this.vertexLabel = label;
    }

    public double getVertexValue() {
        return this.vertexValue;
    }

    public void setVertexValue(double value) {
        this.vertexValue = value;
    }

    public String getDomainPathWay() {
        return this.dominantPathWay;
    }

    public void setDominantPathWay(String dominantPathWay) {
        this.dominantPathWay = dominantPathWay;
    }
    
    public List<String> getPathWayList() {
        return this.pathwayList;
    }

    public void setPathWayList(List<String> pathWayList) {
        this.pathwayList = pathWayList;
    }

    @Override
    public String toString() {
//        if ( this.dominantPathWay != null ) {
//            // Get the name of this vertex
//            return this.dominantPathWay + " : " + vertexLabel;
//        }
//        else {
//            return vertexLabel;
//        }
        String returnString = "";

        if ( RuntimeVariables.ShowVertexDominantPathway ) {
            if ( dominantPathWay != null ) {
                returnString = returnString.concat(dominantPathWay);
            }
            else {
                returnString = returnString.concat(" ");
            }
        }

        if ( RuntimeVariables.ShowVertexDominantPathway && (RuntimeVariables.ShowVertexName || RuntimeVariables.ShowVertexValue) ) {
            returnString = returnString.concat(" : ");
        }

        if ( RuntimeVariables.ShowVertexName ) {
            returnString = returnString.concat(vertexLabel);
        }

        if ( RuntimeVariables.ShowVertexName && RuntimeVariables.ShowVertexValue ) {
            returnString = returnString.concat(" : ");
        }

        if ( RuntimeVariables.ShowVertexValue ) {
            returnString = returnString.concat(Double.toString(vertexValue));
        }

        return returnString;
    }
}
