package Graph.Element;

import Data.BOOST.BOOSTResultItem;

/**
 *
 * @author timyung
 */
public class GraphEdge implements Comparable {

    private final static float AcceptableError = 0.0000001f;

    private double edgeWeight;

    private boolean significantEdge = false;

    private BOOSTResultItem item = null;

    public GraphEdge(double edgeWidght) {
        this.edgeWeight = edgeWidght;
    }

    public GraphEdge(BOOSTResultItem item) {
        this.edgeWeight = item.boostValue;
        this.item = item;
    }

    public double getEdgeWeight() {
        return edgeWeight;
    }
    
    public void setEdgeWeight(double edgeWeight) {
        this.edgeWeight = edgeWeight;
    }

    public void setBOOSTResultItem(BOOSTResultItem item) {
        this.item = item;
    }

    public BOOSTResultItem getBOOSTResultItem() {
        return this.item;
    }

    public boolean isSignificantEdge() {
        return this.significantEdge;
    }

    public void setSignificantEdge(boolean significantEdge) {
        this.significantEdge = significantEdge;
    }

    @Override
    public String toString() {
        return String.format("%.2f", edgeWeight);
    }

    public int compareTo(Object o) {
        GraphEdge e = (GraphEdge) o;

        double diff = this.edgeWeight - e.edgeWeight;

        if ( Math.abs(diff) < AcceptableError ) {
            return 0;
        }
        else if ( diff < 0 ) {
            return -1;
        }
        else {
            return 1;
        }
    }
}