package Graph.CustomRenderContext;

import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.visualization.decorators.AbstractVertexShapeTransformer;
import java.awt.Shape;
import org.apache.commons.collections15.Transformer;

/**
 *
 * @author Joshua O'Madadhain
 *
 * Amended by timyung, 24/11/2010
 */
public class VertexShapeSize<V,E> extends AbstractVertexShapeTransformer <V> implements Transformer<V,Shape>  {

    protected boolean stretch = false;
    protected boolean scale = false;
    protected boolean funny_shapes = false;
    protected Transformer<V,Double> voltages;
    protected Graph<V,E> graph;

    public VertexShapeSize(Graph<V,E> graphIn, Transformer<V,Double> voltagesIn)
    {
        this.graph = graphIn;
        this.voltages = voltagesIn;

        setSizeTransformer(new Transformer<V,Integer>() {

            public Integer transform(V v) {
                if (scale)
                    return (int)(voltages.transform(v) * 30) + 20;
                else
                    return 20;
            }

        });

    }

    public void setScaling(boolean scale)
    {
        this.scale = scale;
    }

    public void useFunnyShapes(boolean use)
    {
        this.funny_shapes = use;
    }

    public Shape transform(V v)
    {
        if (funny_shapes)
        {
            if (graph.degree(v) < 5)
            {
                int sides = Math.max(graph.degree(v), 3);
                return factory.getRegularPolygon(v, sides);
            }
            else
                return factory.getRegularStar(v, graph.degree(v));
        }
        else
            return factory.getEllipse(v);
    }
}