/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package Graph.CustomRenderContext;

import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.visualization.picking.PickedInfo;
import java.awt.Color;
import java.awt.Paint;
import org.apache.commons.collections15.Transformer;

/**
 *
 * @author timyung
 */
public class VertexFillPaint<V,E> implements Transformer<V,Paint> {

    protected boolean highlight = false;
    protected Paint selected = Color.YELLOW;
    protected Paint selected_neighbor = Color.GREEN;
    protected Paint others = Color.RED;
    protected PickedInfo<V> pi;
    protected Graph<V,E> graph;

    public VertexFillPaint(Graph<V,E> graph, PickedInfo<V> pi)
    {
        this.graph = graph;
        this.pi = pi;
    }

    public void setHighlight(boolean highlight)
    {
        this.highlight = highlight;
    }

    public Paint transform(V v) {
        if (highlight)
        {
            if (pi.isPicked(v))
                return selected;
            else
            {
                for(V w : graph.getNeighbors(v)) {
                    //                    for (Iterator iter = graph.getNeighbors(v)v.getNeighbors().iterator(); iter.hasNext(); )
                    //                    {
                    //                        Vertex w = (Vertex)iter.next();
                    if (pi.isPicked(w))
                        return selected_neighbor;
                }
                return others;
            }
        }
        else
            return others;
    }

}