package Graph.CustomRenderContext;

import Graph.Element.GraphVertex;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.util.Context;
import org.apache.commons.collections15.Predicate;

/**
 *
 * @author timyung
 */
public class VertexDisplayPredicate<V,E> implements Predicate<Context<Graph<V,E>,V>> {

    protected boolean filterVertexValue;

    protected double filterValue;

    protected boolean filterVertexDegree;

    protected int minDegree = 0;

    public VertexDisplayPredicate(boolean filterVertexValue, double filterValue, boolean filterVertexDegree, int minDegree)
    {
        this.filterVertexValue = filterVertexValue;
        this.filterValue = filterValue;
        this.filterVertexDegree = filterVertexDegree;
        this.minDegree = minDegree;
    }

    public boolean isFilterVertexValue() {
        return filterVertexValue;
    }

    public void setFilterVertexValue(boolean filterVertexValue)
    {
        this.filterVertexValue = filterVertexValue;
    }

    public boolean isFilterVertexDegree() {
        return filterVertexDegree;
    }

    public void setFilterVertexDegree(boolean filterVertexDegree)
    {
        this.filterVertexDegree = filterVertexDegree;
    }

    public double getFilterValue() {
        return filterValue;
    }

    public void setFilterValue(double filterValue) {
        this.filterValue = filterValue;
    }

    public int getMinDegree() {
        return this.minDegree;
    }

    public void setMinDegree(int minDegree) {
        this.minDegree = minDegree;
    }

    public boolean evaluate(Context<Graph<V,E>,V> context) {
        Graph<V,E> graph = context.graph;
        GraphVertex v = (GraphVertex) context.element;

        boolean result = true;

        if ( filterVertexValue ) {
            result = result && (v.getVertexValue() >= filterValue);
        }
        else {
            result = result && true;
        }
        
        if ( filterVertexDegree ) {
            result = result && ( graph.degree(context.element) >= minDegree );
        }
        else {
            result = result && true;
        }

        return result;

//        if ( filterVertexValue ) {
//            if ( v.getVertexValue() < filterValue )
//                return false;
//            else {
//                if ( graph.degree(context.element) < minDegree ) {
//                    return false;
//                }
//                else
//                    return true;
//            }
//        }
//        else {
//            return true;
//        }
    }
}
