package Graph.CustomRenderContext;

import Graph.Element.GraphEdge;
import edu.uci.ics.jung.visualization.RenderContext;
import java.awt.BasicStroke;
import java.awt.Stroke;
import org.apache.commons.collections15.Transformer;

/**
 *
 * @author timyung
 */
public class EdgeWeightStrokeFunction<E> implements Transformer<E,Stroke> {

    protected static final Stroke basic = new BasicStroke(1);
    protected static final Stroke heavy = new BasicStroke(3);
    protected static final Stroke dotted = RenderContext.DOTTED;

    protected boolean weighted = false;
    protected double edgeValue;

    public EdgeWeightStrokeFunction(boolean weighted, double edgeValue)
    {
        this.weighted = weighted;
        this.edgeValue = edgeValue;
    }

    public boolean isWeighted() {
        return weighted;
    }

    public void setWeighted(boolean weighted)
    {
        this.weighted = weighted;
    }

    public double getEdgeValue() {
        return edgeValue;
    }

    public void setEdgeValue(double edgeValue) {
        this.edgeValue = edgeValue;
    }

    public Stroke transform(E e)
    {
        if (weighted)
        {
            if (drawHeavy(e))
                return heavy;
            else
                return dotted;
        }
        else
            return basic;
    }

    protected boolean drawHeavy(E e)
    {
        GraphEdge edge = (GraphEdge) e;
        
        if (edge.getEdgeWeight() > edgeValue)
            return true;
        else
            return false;
        }
    }