package Data;

import Utility.Progress.ProgressDialog;
import gboost_gui.RuntimeVariables;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.util.Collections;
import java.util.List;
import java.util.Scanner;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingWorker;

/**
 *
 * @author timyung
 */
public class SNPPathWayDataFile {

    private String filename = null;

    private List<PathwayList> snpPathwayList= new Vector<PathwayList>();

    public SNPPathWayDataFile(String filename) {
        this.filename = filename;
        LoadSNPPathWayDataFileTask task = new LoadSNPPathWayDataFileTask(this);
        ProgressDialog pd = new ProgressDialog(RuntimeVariables.ProgramMainFrame, task, "Load SNP Pathway data file", false);
        task.addPropertyChangeListener(pd);
        task.execute();
        
        // Wait for task completion
        while ( !task.isDone() && !task.isCancelled() ) {
            try {
                Thread.sleep(1000);
            } catch (InterruptedException ex) {
                Logger.getLogger(SNPPathWayDataFile.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public String getFilename() {
        return filename;
    }

    public List<PathwayList> getFullSNPPathwayList() {
        return snpPathwayList;
    }

    public PathwayList getPathwayList(String snpName) {
        PathwayList pathwayList = new PathwayList(snpName);
        PathwayListComparator comparator = new PathwayListComparator();
        int foundIndex = Collections.binarySearch(snpPathwayList, pathwayList, comparator);

        if ( foundIndex < 0 ) {
            return null;
        }
        else {
            return snpPathwayList.get(foundIndex);
        }
    }

}

class LoadSNPPathWayDataFileTask extends SwingWorker {

    private SNPPathWayDataFile parentFile = null;

    public LoadSNPPathWayDataFileTask(SNPPathWayDataFile file) {
        this.parentFile = file;
    }

    @Override
    protected Object doInBackground() throws Exception {
        FileReader reader = null;
        Scanner scanner = null;
        try {
            List<PathwayList> snpPathwayList = parentFile.getFullSNPPathwayList();
            String filename = parentFile.getFilename();
            reader = new FileReader(filename);
            scanner = new Scanner(reader);
            String line = null;
            PathwayList pathwayList = null;
            StringTokenizer tokenizer = null;
            String token = null;
            int numberOfLine = 0, currLine = 0;
            while (scanner.hasNextLine()) {
                scanner.nextLine();
                numberOfLine++;
            }

            // Reset to the start of a file
            reader = new FileReader(filename);
            scanner = new Scanner(reader);
            while (scanner.hasNextLine()) {
                // return immediately if the work is cancel
                if ( isCancelled() ) {
                    // clear up if the task is cancelled;
                    snpPathwayList.clear();
                    return null;
                }

                // Update the progress
                if ( currLine % 100000 == 0 ) {
                    this.setProgress((int)((currLine / ((double)numberOfLine)) * 100));
                }

                // Scan line by line
                line = scanner.nextLine();
                tokenizer = new StringTokenizer(line, ",");
                token = tokenizer.nextToken();
                pathwayList = new PathwayList(token);
                while (tokenizer.hasMoreTokens()) {
                    pathwayList.add(tokenizer.nextToken());
                }
                snpPathwayList.add(pathwayList);
                currLine++;
            }
            Collections.sort(snpPathwayList);
            this.setProgress(100);
        }
        catch (FileNotFoundException ex)
        {
            Logger.getLogger(LoadSNPPathWayDataFileTask.class.getName()).log(Level.SEVERE, null, ex);
        }
        
        return "All Completed";
    }

    @Override
    protected void done() {
        super.done();
        this.setProgress(100);
    }

}