package Data;

import java.util.Comparator;

/**
 *
 * @author timyung
 */
public class RecordComparator implements Comparator {

    static public final double DEL = 0.000001;

    private int comparingIndex = 0;

    public RecordComparator(int comparingIndex) {
        this.comparingIndex = comparingIndex;
    }

    public int compare(Object o1, Object o2) {
        Object item1 = ((Record) o1).getAttributeObject(comparingIndex);
        Object item2 = ((Record) o2).getAttributeObject(comparingIndex);

        if ( item1 instanceof String && item2 instanceof String ) {
            return ((String)item1).compareTo((String)item2);
        }
        else if ( item1 instanceof Double && item2 instanceof Double)
        {
            double absValue = Math.abs((Double)item1 - (Double)item2);
            if ( absValue < DEL ) {
                return 0;
            }
            else if ( absValue > 0 ) {
                return 1;
            }
            else {
                return -1;
            }
        }

        // Assume to be the same for all other cases
        return 0;
    }


}
