package Data;

import SearchUitlity.AccessJDBCUtil;
import gboost_gui.Configuration;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 *
 * @author timyung
 */
public class Record {
    static public final String[] attributeNameArray =
    {"name","chr","coordinate","genome_build","gene_symbol",
     "gene_id","accession","location","location_relative_to_gene","coding_status",
     "amino_acid_change","id_with_mouse","phast_conservation"};

    public static String getAttributeName(int attributeIndex) {
        if ( attributeIndex >=0 && attributeIndex < attributeNameArray.length ) {
            return attributeNameArray[attributeIndex];
        }
        else
            return null;
    }

    public static Record getRecord(String snpName) {
        try {
            Connection conn = AccessJDBCUtil.getAccessDBConnection(Configuration.DB_FILE_PATH);
            Statement statement = conn.createStatement();

            ResultSet rs = null;
            ResultSetMetaData metaData = null;
            boolean queryResult = false;
            Record record = null;
            String stringValue = null;

            // query for gene with specified name
            String queryStatement = String.format("Select * From List Where gene_symbol='"+snpName+"'");
            queryResult = statement.execute(queryStatement);
            rs = statement.getResultSet();

            // If an unique record is found
            if ( rs.next() ) {
                int cols = Record.attributeNameArray.length;
                record = new Record();
                for(int i = 1;i <= cols;i++) {
                    stringValue = rs.getString(i);
                    record.setAttributeObject(i-1, stringValue);
                }

                statement.close();
                conn.close();
                return record;
            }
            else {
                statement.close();
                conn.close();
                return null;
            }
        } catch (SQLException ex) {
            Logger.getLogger(Record.class.getName()).log(Level.SEVERE, null, ex);
        }
        return null;
    }

    public static Record getRecord(String snpName, Statement statement) {
        try {
            ResultSet rs = null;
            ResultSetMetaData metaData = null;
            boolean queryResult = false;
            Record record = null;
            String stringValue = null;

            // query for gene with specified name
            String queryStatement = String.format("Select * From List Where gene_symbol='"+snpName+"'");
            queryResult = statement.execute(queryStatement);
            rs = statement.getResultSet();

            // If an unique record is found
            if ( rs.next() ) {
                int cols = Record.attributeNameArray.length;
                record = new Record();
                for(int i = 1;i <= cols;i++) {
                    stringValue = rs.getString(i);
                    record.setAttributeObject(i-1, stringValue);
                }
                return record;
            }
            else
                return null;
        } catch (SQLException ex) {
            Logger.getLogger(Record.class.getName()).log(Level.SEVERE, null, ex);
        }
        return null;
    }

    private String[] objectArray = null;

    public Record() {
        objectArray = new String[attributeNameArray.length];
    }

//    public Record(String dataLine) {
//        objectArray = new String[13];
//
//        // Read the attributes' name in the first line
//        StringTokenizer tokenizer = new StringTokenizer(dataLine,";");
//        int currAttributeIndex = 0;
//
//        while ( tokenizer.hasMoreTokens() ) {
//            setAttributeObject(currAttributeIndex, new String(tokenizer.nextToken()));
//            currAttributeIndex++;
//        }
//    }

    public Object getAttributeObject(int attributeIndex) {
        if ( attributeIndex >=0 && attributeIndex < attributeNameArray.length ) {
            return objectArray[attributeIndex];
        }
        else {
            return null;
        }
    }

    public Object setAttributeObject(int attributeIndex, Object object) {
        if ( attributeIndex >=0 && attributeIndex < attributeNameArray.length ) {
            Object oldObject = objectArray[attributeIndex];
            objectArray[attributeIndex] = (String) object;
            return oldObject;
        }
        else {
            return null;
        }
    }
    
}
