package Data;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;

/**
 *
 * @author timyung
 */
public class INTERSNPDataFile {

    private List<Record> recordList = new Vector<Record>();

    private int sortItemIndex = 0;

    public INTERSNPDataFile(String interSNP_DataFilename) {
        int totalNumber = 0;
        int currLine = 0;
        int totalMemoryUsed = 0;
        Record tempRecord = null;
        String dataLine = null;

        try{
            // Write to
            FileWriter fileWriter = new FileWriter(".\\temp.csv");

            // Open the file that is the first 
            FileInputStream fstream = new FileInputStream(interSNP_DataFilename);
            
            // Get the object of DataInputStream
            DataInputStream in = new DataInputStream(fstream);
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            
            HashMap hm = new HashMap();
            String token = null;

            //Read data in the file -- Line By Line
            while ((dataLine = br.readLine()) != null)   {
                StringTokenizer tokenizer = new StringTokenizer(dataLine,";");
                token = tokenizer.nextToken();
                if ( !hm.containsKey(token) ) {
                    hm.put(token, currLine);
                }
                else {
                    // to the forth token
                    tokenizer.nextToken();
                    tokenizer.nextToken();

                    // the version information
                    token = tokenizer.nextToken();

                    if ( token.equals("36.2") ) {
                        hm.put(token, currLine);
                    }
                }

                currLine++;

//                if ( currLine % 100000 == 0 ) {
//                    System.out.println("CurrentLine : " + currLine);
//                    System.out.println("CurrentFree Memory : " + Runtime.getRuntime().freeMemory() / 1024 / 1024);
//
//                    totalMemoryUsed = 0;
//
//                    for ( int i = 0; i < recordList.size(); i++ ) {
//                        for ( int j = 0; j < Record.attributeNameArray.length; j++ ) {
//                            totalMemoryUsed += ((String)recordList.get(i).getAttributeObject(j)).length();
//                        }
//                    }
//
//                    System.out.println("Current Used Memory : " +  totalMemoryUsed / 1024 / 1024);
//                }
//                currLine++;

                //tempRecord = new Record(dataLine);
                //recordList.add(new Record(dataLine));

//                StringTokenizer tokenizer = new StringTokenizer(dataLine,";");
//                String token = null;
//                while ( tokenizer.hasMoreTokens() ) {
//                    token = tokenizer.nextToken();
//
//                    // Reach the last one
//                    if ( !tokenizer.hasMoreTokens() ) {
//                        if ( token.equals("NULL") ) {
//                            fileWriter.write("\"-1\"");
//                        }
//                        else {
//                            fileWriter.write("\""+token+"\"");
//                        }
//                    }
//                    else {
//                        if ( token.equals("NULL") ) {
//                            fileWriter.write("\"-1\",");
//                        }
//                        else {
//                            fileWriter.write("\""+token+"\",");
//                        }
//                    }
//
//                }
//                fileWriter.write("\n");
            }
            in.close();

            // reset buffer reader
            fstream = new FileInputStream(interSNP_DataFilename);
            in = new DataInputStream(fstream);
            br = new BufferedReader(new InputStreamReader(in));

            currLine = 0;
            
            //Read data in the file -- Line By Line
            while ((dataLine = br.readLine()) != null)   {
                StringTokenizer tokenizer = new StringTokenizer(dataLine,";");
                token = tokenizer.nextToken();
                //System.out.println(currLine);
                if ( (Integer)hm.get(token) == currLine ) {
                    // write the name first 
                    fileWriter.write("\""+token+"\",");
                    while ( tokenizer.hasMoreTokens() ) {
                        token = tokenizer.nextToken();

                        // Reach the last one
                        if ( !tokenizer.hasMoreTokens() ) {
                            if ( token.equals("NULL") ) {
                                fileWriter.write("\"-1\"");
                            }
                            else {
                                fileWriter.write("\""+token+"\"");
                            }
                        }
                        else {
                            if ( token.equals("NULL") ) {
                                fileWriter.write("\"-1\",");
                            }
                            else {
                                fileWriter.write("\""+token+"\",");
                            }
                        }

                    }
                    fileWriter.write("\n");
                }
                currLine++;
            }
           
            //Close the input stream
            in.close();

            fileWriter.close();
        }catch (Exception e){//Catch exception if any
            System.err.println("Reading Error: " + e.getMessage());
        }

        sortRecords(0);
        System.out.println("ReadFile Complete!");

    }

    public  List<Record> getRecordList() {
        return recordList;
    }

    public int getSortIndex() {
        return sortItemIndex;
    }

    public int sortRecords(int sortItemIndex) {
        if ( sortItemIndex >= 0 && sortItemIndex < Record.attributeNameArray.length ) {
            this.sortItemIndex = sortItemIndex;
            RecordComparator comparator = new RecordComparator(sortItemIndex);
            Collections.sort(recordList, comparator);
            return 0;
        }
        else {
            return -1;
        }
    }

}
