package Data.BOOST;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Hashtable;
import java.util.List;
import java.util.Scanner;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 *
 * @author timyung
 */
public class SNPNameHashtable {

    private Hashtable snpNameHashtable = new Hashtable();

    private List<Integer> lastSNPNameIndexList = new Vector<Integer>();

    public SNPNameHashtable(String inputListFilename) throws FileNotFoundException {

        // Scan the filename
        List<String> snpnameFilenameList = new Vector<String>();
        FileReader reader = null;
        Scanner scanner = null;
        String line = null;
        int index = 0;

        reader = new FileReader(inputListFilename);
        scanner = new Scanner(reader);

        while ( scanner.hasNextLine() ) {
            line = scanner.nextLine();

            // add snpname to the end of the file
            snpnameFilenameList.add(line.replace(".txt", "snpname.txt"));
        }
        scanner.close();
        try {
            reader.close();
        } catch (IOException ex) {
            Logger.getLogger(SNPNameHashtable.class.getName()).log(Level.SEVERE, null, ex);
        }

        // build the hashtable
        File workingDirectory = new File(inputListFilename);
        String workingDirectoryPath = workingDirectory.getParent();

        for ( String snpnameFilename : snpnameFilenameList ) {
            reader = new FileReader(workingDirectoryPath+"\\"+snpnameFilename);
            scanner = new Scanner(reader);

            while ( scanner.hasNext() ) {
                snpNameHashtable.put(index, scanner.next());
                index++;
            }
            lastSNPNameIndexList.add(index);
            scanner.close();
            try {
                reader.close();
            } catch (IOException ex) {
                Logger.getLogger(SNPNameHashtable.class.getName()).log(Level.SEVERE, null, ex);
            }
        }

    }
    
    public Hashtable getSNPNameHastable() {
        return snpNameHashtable;
    }
    
    public String getSNPName(int key) {
        return (String) snpNameHashtable.get(key);
    }

    public int getChr(int index) {
        int i = 0;
        for ( i = 0; i < lastSNPNameIndexList.size(); i++ ) {
            if ( index <= lastSNPNameIndexList.get(i) ) {
                return i+1;
            }
        }
        return i+1;
    }

}
