package Data.BOOST.Comparator;

import Data.BOOST.BOOSTResultItem;
import java.util.Comparator;

/**
 *
 * @author timyung
 */
public class BOOSTResultItemComparator implements Comparator {

    public static int SNPNAME1 = 0;
    public static int SNPNAME2 = 1;
    public static int BOOSTVALUE = 2;

    private int sortOrder = SNPNAME1;

    public BOOSTResultItemComparator(int sortOrder) {
        this.sortOrder = sortOrder;
    }

    public int compare(Object o1, Object o2) {
        BOOSTResultItem item1 = (BOOSTResultItem) o1;
        BOOSTResultItem item2 = (BOOSTResultItem) o2;

        if ( sortOrder == BOOSTVALUE ) {
            return Double.compare(item1.boostValue,item2.boostValue);
        }
        else {
            if ( sortOrder == SNPNAME1 ) {
                return item1.snpName1.compareTo(item2.snpName1);
            }
            else {
                return item1.snpName2.compareTo(item2.snpName2);
            }
        }
    }

}
