package Data.BOOST;

import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.List;
import java.util.Scanner;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 *
 * @author timyung
 */
public class BOOSTResultFile {

    private String BOOSTResultFilename = null;
    
    private String snpnameListFilename = null;

    private int numberOfItem = 0;
    
    private List<BOOSTResultItem> itemList = null;
    
    private SNPNameHashtable snpNameHastable = null;

    public BOOSTResultFile(String BOOSTResultFilename, String snpnameListFilename) {
        this.BOOSTResultFilename = BOOSTResultFilename;
        this.snpnameListFilename = snpnameListFilename;

        try {
            // build the snp name hashtable for recovering the snp name from index
            snpNameHastable = new SNPNameHashtable(snpnameListFilename);

            // open the BOOST result file and store all items
            buildBOOSTResultItemList();
        } catch (FileNotFoundException ex) {
            Logger.getLogger(BOOSTResultFile.class.getName()).log(Level.SEVERE, null, ex);
        } catch (IOException ex) {
            Logger.getLogger(BOOSTResultFile.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    protected void buildBOOSTResultItemList() throws FileNotFoundException, IOException {
        itemList = new Vector<BOOSTResultItem>();

        FileReader reader = null;
        Scanner scanner = null;
        StringTokenizer tokenizer = null;
        BOOSTResultItem item = null;

        reader = new FileReader(BOOSTResultFilename);
        scanner = new Scanner(reader);

        while ( scanner.hasNextLine() ) {
            tokenizer = new StringTokenizer(scanner.nextLine());
            item = new BOOSTResultItem();

            // Each line should has 7 tokens
            // Discard first token
            tokenizer.nextToken();

            item.snpIndex1 = Integer.parseInt(tokenizer.nextToken());
            item.snpName1 = snpNameHastable.getSNPName((Integer)item.snpIndex1);
            item.snpIndex2 = Integer.parseInt(tokenizer.nextToken());
            item.snpName2 = snpNameHastable.getSNPName((Integer)item.snpIndex2);

            item.snpValue1 = Double.parseDouble(tokenizer.nextToken());
            item.snpValue2 = Double.parseDouble(tokenizer.nextToken());
            item.boostValue = Double.parseDouble(tokenizer.nextToken());
            item.zValue = Double.parseDouble(tokenizer.nextToken());

            itemList.add(item);

            numberOfItem++;
        }

        scanner.close();
        reader.close();
    }

    public String getBOOSTResultFilename() {
        return BOOSTResultFilename;
    }

    public String getSNPNameListFilename() {
        return snpnameListFilename;
    }

    public int getTotalNumberOfItem() {
        return numberOfItem;
    }
    
    public BOOSTResultItem getBOOSTResultItem(int index) {
        return itemList.get(index);
    }
    
    public List<BOOSTResultItem> getBOOSTResultItemList() {
        return itemList;
    }

    public List<BOOSTResultItem> getFilteredResultItemList(double thresholdValue) {
        List<BOOSTResultItem> filteredItemList = new Vector();

        for ( BOOSTResultItem item : itemList ) {
            if ( item.boostValue > thresholdValue ) {
                filteredItemList.add(item);
            }
        }

        return filteredItemList;
    }

}
