package Data.BOOST;

import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.List;
import java.util.Scanner;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 *
 * @author timyung
 */
public class BOOSTMarginalAssociationFile {

    private String filename = null;

    private List<BOOSTMarginalAssociationItem> itemList = null;

    public BOOSTMarginalAssociationFile(String BOOSTMarginalAssoicationFilename, String snpnameListFilename) {
        this.filename = BOOSTMarginalAssoicationFilename;
        this.itemList = new Vector<BOOSTMarginalAssociationItem>();

        // for loading the file
        SNPNameHashtable snpNameHastable = null;
        try {
            snpNameHastable = new SNPNameHashtable(snpnameListFilename);
        } catch (FileNotFoundException ex) {
            Logger.getLogger(BOOSTMarginalAssociationFile.class.getName()).log(Level.SEVERE, null, ex);
        }
        FileReader reader = null;
        Scanner scanner = null;
        String line = null;
        StringTokenizer tokenizer = null;
        BOOSTMarginalAssociationItem item = null;
        int index = 0;
        try {
            reader = new FileReader(BOOSTMarginalAssoicationFilename);
        } catch (FileNotFoundException ex) {
            Logger.getLogger(BOOSTMarginalAssociationFile.class.getName()).log(Level.SEVERE, null, ex);
        }
        scanner = new Scanner(reader);

        while ( scanner.hasNextLine() ) {
            line = scanner.nextLine();
            tokenizer = new StringTokenizer(line);
            
            // add snpname to the end of the file
            item = new BOOSTMarginalAssociationItem();
            item.snpName = snpNameHastable.getSNPName(Integer.parseInt(tokenizer.nextToken()));
            item.value = Double.parseDouble(tokenizer.nextToken());
            item.location = index+1;
            item.chr = snpNameHastable.getChr(index);
            index++;

            itemList.add(item);
        }
        scanner.close();
        try {
            reader.close();
        } catch (IOException ex) {
            Logger.getLogger(SNPNameHashtable.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
    
    public String getFilename() {
        return filename;
    }

    public List<BOOSTMarginalAssociationItem> getItemList() {
        return itemList;
    }

    public BOOSTMarginalAssociationItem getItem(int index) {
        if ( index >= 0 && index < itemList.size() )
            return itemList.get(index);
        else 
            return null;
    }

    public int getItemCount() {
        return itemList.size();
    }

    public static void main(String[] args) throws Exception {
        BOOSTMarginalAssociationFile file =
                new BOOSTMarginalAssociationFile(
                "C:\\Documents and Settings\\timyung\\Desktop\\TestFolder\\outputMarginalAssociation.txt",
                "C:\\Documents and Settings\\timyung\\Desktop\\TestFolder\\filenamelist.txt"
                );

    }

}
