/*
 * Decompiled with CFR 0.152.
 */
package gboost_gui.ToolPanel;

import Data.BOOST.BOOSTResultFile;
import Data.BOOST.BOOSTResultItem;
import Data.BOOST.Comparator.BOOSTResultItemComparator;
import gboost_gui.RuntimeVariables;
import info.clearthought.layout.TableLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RawDataToolPanel
extends JPanel
implements ActionListener {
    private BOOSTResultFile parentFile = null;
    private List<BOOSTResultItem> filteredItemList = null;
    private JTextField currFilenameTextField = new JTextField();
    private JTextField filterValueTextfield = new JTextField();
    private JButton setFilterValueButton = null;
    private JTextField currNumberOfRawDataRecord = new JTextField();
    private JPanel dataListPanel = null;
    private JList dataList = null;
    private JRadioButton snpName1RadioButton = null;
    private JRadioButton snpName2RadioButton = null;
    private JRadioButton boostValueRadioButton = null;
    private JTextField selectNumTextField = new JTextField();
    private JButton selectNumButton = null;
    private JButton selectHighlightedButton = null;
    private JButton deselectHighlightedButton = null;
    private JButton selectAllButton = null;
    private JButton deselectAllButton = null;
    private JTextField searchTextField = new JTextField();
    private JButton searchButton = null;
    private JButton resetListSelectionButton = null;
    private JButton updateGraphButton = null;

    public RawDataToolPanel() {
        double tableLayoutBorderSize = 10.0;
        int tableLayoutVGap = 2;
        int tableLayoutHGap = 5;
        TableLayout tableLayout = null;
        int rowIndex = 0;
        Border loweredetched = BorderFactory.createEtchedBorder(1);
        TitledBorder titleBorder = null;
        this.currFilenameTextField.setEditable(false);
        this.filterValueTextfield.setText(Double.toString(RuntimeVariables.RawDataFilterValue));
        this.setFilterValueButton = new JButton("Set");
        this.setFilterValueButton.addActionListener(this);
        this.setSelectedCount();
        this.currNumberOfRawDataRecord.setEditable(false);
        this.dataList = new JList();
        this.dataList.setModel(new DefaultListModel());
        this.dataList.setCellRenderer(new BOOSTResultItemListCellRenderer());
        this.dataList.setSelectionMode(2);
        JScrollPane dataListScrollPane = new JScrollPane(this.dataList);
        this.dataListPanel = new JPanel();
        this.dataListPanel.setLayout(new BorderLayout());
        this.dataListPanel.add((Component)dataListScrollPane, "Center");
        titleBorder = BorderFactory.createTitledBorder(loweredetched, "Data List");
        titleBorder.setTitleJustification(1);
        this.dataListPanel.setBorder(titleBorder);
        ButtonGroup sortByButtonGroup = new ButtonGroup();
        this.snpName1RadioButton = new JRadioButton("snpName1");
        this.snpName1RadioButton.addActionListener(this);
        this.snpName2RadioButton = new JRadioButton("snpName2");
        this.snpName2RadioButton.addActionListener(this);
        this.boostValueRadioButton = new JRadioButton("Boost value");
        this.boostValueRadioButton.addActionListener(this);
        sortByButtonGroup.add(this.snpName1RadioButton);
        sortByButtonGroup.add(this.snpName2RadioButton);
        sortByButtonGroup.add(this.boostValueRadioButton);
        switch (RuntimeVariables.RawDataSortOrder) {
            case SNPNAME1: {
                this.snpName1RadioButton.setSelected(true);
                break;
            }
            case SNPNAME2: {
                this.snpName2RadioButton.setSelected(true);
                break;
            }
            case BOOSTVALUE: {
                this.boostValueRadioButton.setSelected(true);
                break;
            }
        }
        this.selectNumTextField.setText(Integer.toString(RuntimeVariables.SelectCount));
        this.selectNumButton = new JButton("Set");
        this.selectNumButton.addActionListener(this);
        this.selectHighlightedButton = new JButton("Select");
        this.selectHighlightedButton.addActionListener(this);
        this.deselectHighlightedButton = new JButton("Deselet");
        this.deselectHighlightedButton.addActionListener(this);
        this.selectAllButton = new JButton("Select All");
        this.selectAllButton.addActionListener(this);
        this.deselectAllButton = new JButton("Deselect All");
        this.deselectAllButton.addActionListener(this);
        this.resetListSelectionButton = new JButton("Reset");
        this.resetListSelectionButton.addActionListener(this);
        this.updateGraphButton = new JButton("Update");
        this.updateGraphButton.addActionListener(this);
        this.searchButton = new JButton("Search");
        this.searchButton.addActionListener(this);
        tableLayout = new TableLayout(new double[]{tableLayoutBorderSize, 0.37, 0.13, 0.13, 0.37, tableLayoutBorderSize}, new double[]{0.0});
        tableLayout.setHGap(tableLayoutHGap);
        tableLayout.setVGap(tableLayoutVGap);
        this.setLayout((LayoutManager)tableLayout);
        rowIndex = 0;
        tableLayout.insertRow(++rowIndex, -2.0);
        tableLayout.insertRow(++rowIndex, -2.0);
        tableLayout.insertRow(++rowIndex, -2.0);
        tableLayout.insertRow(++rowIndex, -1.0);
        tableLayout.insertRow(++rowIndex, -2.0);
        tableLayout.insertRow(++rowIndex, -2.0);
        tableLayout.insertRow(++rowIndex, -2.0);
        tableLayout.insertRow(++rowIndex, -2.0);
        tableLayout.insertRow(++rowIndex, -2.0);
        tableLayout.insertRow(++rowIndex, -2.0);
        tableLayout.insertRow(++rowIndex, -2.0);
        tableLayout.insertRow(++rowIndex, -2.0);
        this.add((Component)new JLabel("Filename : "), "1,1");
        this.add((Component)this.currFilenameTextField, "2,1,4,1");
        this.add((Component)new JLabel("Filter value : "), "1,2");
        this.add((Component)this.filterValueTextfield, "2,2,3,2");
        this.add((Component)this.setFilterValueButton, "4,2");
        this.add((Component)new JLabel("Count : "), "1,3");
        this.add((Component)this.currNumberOfRawDataRecord, "2,3,4,3");
        this.add((Component)this.dataListPanel, "1,4,4,4");
        this.add((Component)new JLabel("Sort by : "), "1,5");
        this.add((Component)this.snpName1RadioButton, "2,5, 4,5");
        this.add((Component)this.snpName2RadioButton, "2,6,4,6");
        this.add((Component)this.boostValueRadioButton, "2,7,4,7");
        this.add((Component)new JLabel("Select Top : "), "1,8");
        this.add((Component)this.selectNumTextField, "2,8,3,8");
        this.add((Component)this.selectNumButton, "4,8");
        this.add((Component)this.selectHighlightedButton, "1,9,2,9");
        this.add((Component)this.deselectHighlightedButton, "3,9,4,9");
        this.add((Component)this.selectAllButton, "1,10,2,10");
        this.add((Component)this.deselectAllButton, "3,10,4,10");
        this.add((Component)this.searchTextField, "1,11,3,11");
        this.add((Component)this.searchButton, "4,11");
        this.add((Component)this.resetListSelectionButton, "1,12,2,12");
        this.add((Component)this.updateGraphButton, "3,12,4,12");
        for (Component c : this.getComponents()) {
            c.setEnabled(false);
        }
        this.dataList.setEnabled(false);
    }

    public BOOSTResultFile getFile() {
        return this.parentFile;
    }

    public void setFile(BOOSTResultFile file) {
        if (file != null) {
            this.parentFile = file;
            this.currFilenameTextField.setText(file.getBOOSTResultFilename());
            this.filteredItemList = this.parentFile.getFilteredResultItemList(RuntimeVariables.RawDataFilterValue);
            this.setSelectedCount();
            this.sortDataList(RuntimeVariables.RawDataSortOrder, true);
            for (Component c : this.getComponents()) {
                c.setEnabled(true);
            }
            this.dataList.setEnabled(true);
        }
    }

    public void resetDataList() {
        if (this.filteredItemList != null) {
            this.selectListItem(this.filteredItemList.size(), false);
            this.setSelectedCount();
            this.boostValueRadioButton.setSelected(true);
            RuntimeVariables.RawDataSortOrder = SORT_ORDER.BOOSTVALUE;
            this.sortDataList(SORT_ORDER.BOOSTVALUE, true);
            this.searchTextField.setText("");
            RuntimeVariables.SelectCount = 50;
            this.selectNumTextField.setText("50");
        }
        if (this.dataList != null) {
            this.dataList.clearSelection();
        }
    }

    protected void setSelectedCount() {
        if (this.filteredItemList != null) {
            int selectedCount = 0;
            for (BOOSTResultItem item : this.filteredItemList) {
                if (!item.selected) continue;
                ++selectedCount;
            }
            this.currNumberOfRawDataRecord.setText(selectedCount + " / " + this.filteredItemList.size());
        } else {
            this.currNumberOfRawDataRecord.setText("0 / 0");
        }
    }

    protected void updateThresholdValue(double value) {
        if (this.parentFile != null) {
            if (this.filteredItemList != null) {
                for (BOOSTResultItem item : this.filteredItemList) {
                    item.selected = false;
                }
            }
            this.filteredItemList = this.parentFile.getFilteredResultItemList(RuntimeVariables.RawDataFilterValue);
            this.setSelectedCount();
            this.sortDataList(RuntimeVariables.RawDataSortOrder, true);
        }
    }

    protected void sortDataList(SORT_ORDER sortOrder, boolean addToDataList) {
        if (this.filteredItemList != null) {
            BOOSTResultItemComparator comparator = null;
            switch (sortOrder) {
                case SNPNAME1: {
                    comparator = new BOOSTResultItemComparator(BOOSTResultItemComparator.SNPNAME1);
                    break;
                }
                case SNPNAME2: {
                    comparator = new BOOSTResultItemComparator(BOOSTResultItemComparator.SNPNAME2);
                    break;
                }
                case BOOSTVALUE: {
                    comparator = new BOOSTResultItemComparator(BOOSTResultItemComparator.BOOSTVALUE);
                    break;
                }
            }
            Collections.sort(this.filteredItemList, comparator);
            if (sortOrder == SORT_ORDER.BOOSTVALUE) {
                Collections.reverse(this.filteredItemList);
            }
            if (addToDataList) {
                DefaultListModel<BOOSTResultItem> listModel = new DefaultListModel<BOOSTResultItem>();
                for (BOOSTResultItem item : this.filteredItemList) {
                    listModel.addElement(item);
                }
                this.dataList.setModel(listModel);
            }
        }
    }

    protected void selectHighlightedListItem(boolean select) {
        if (this.dataList != null) {
            int[] selectedIndices;
            for (int index : selectedIndices = this.dataList.getSelectedIndices()) {
                this.filteredItemList.get((int)index).selected = select;
            }
            this.setSelectedCount();
            this.dataListPanel.repaint();
        }
    }

    protected void selectListItem(int count, boolean select) {
        if (this.filteredItemList != null) {
            int selectCount = Math.min(this.filteredItemList.size(), count);
            for (int i = 0; i < selectCount; ++i) {
                this.filteredItemList.get((int)i).selected = select;
            }
            this.setSelectedCount();
            this.dataListPanel.repaint();
        }
    }

    protected boolean searchListItem(String searchString) {
        if (this.filteredItemList != null && this.dataList != null) {
            int startIndex = 0;
            int[] indices = this.dataList.getSelectedIndices();
            if (indices.length != 0) {
                this.dataList.clearSelection();
                startIndex = indices[0] + 1;
            } else {
                startIndex = 0;
            }
            for (int i = startIndex; i < this.filteredItemList.size(); ++i) {
                if (!this.filteredItemList.get(i).toString().contains(searchString)) continue;
                this.dataList.setSelectedIndex(i);
                this.dataList.ensureIndexIsVisible(i);
                return true;
            }
        }
        return false;
    }

    protected List<BOOSTResultItem> getSelectedItemList() {
        if (this.filteredItemList != null) {
            Vector<BOOSTResultItem> itemList = new Vector<BOOSTResultItem>();
            for (BOOSTResultItem item : this.filteredItemList) {
                if (!item.selected) continue;
                itemList.add(item);
            }
            return itemList;
        }
        return null;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        AbstractButton source = (AbstractButton)e.getSource();
        if (source == this.setFilterValueButton) {
            try {
                double value;
                RuntimeVariables.RawDataFilterValue = value = Double.parseDouble(this.filterValueTextfield.getText());
                this.updateThresholdValue(value);
            }
            catch (NumberFormatException ex) {
                JOptionPane.showMessageDialog(null, "Unable to parse the filter value!", "Error Messages", 0);
                this.filterValueTextfield.setText(Double.toString(RuntimeVariables.RawDataFilterValue));
            }
        } else if (source == this.snpName1RadioButton) {
            if (source.isSelected()) {
                this.sortDataList(SORT_ORDER.SNPNAME1, true);
                RuntimeVariables.RawDataSortOrder = SORT_ORDER.SNPNAME1;
            }
        } else if (source == this.snpName2RadioButton) {
            if (source.isSelected()) {
                this.sortDataList(SORT_ORDER.SNPNAME2, true);
                RuntimeVariables.RawDataSortOrder = SORT_ORDER.SNPNAME2;
            }
        } else if (source == this.boostValueRadioButton) {
            if (source.isSelected()) {
                this.sortDataList(SORT_ORDER.BOOSTVALUE, true);
                RuntimeVariables.RawDataSortOrder = SORT_ORDER.BOOSTVALUE;
            }
        } else if (source == this.selectNumButton) {
            try {
                int value;
                RuntimeVariables.SelectCount = value = Integer.parseInt(this.selectNumTextField.getText());
                this.selectListItem(value, true);
            }
            catch (NumberFormatException ex) {
                JOptionPane.showMessageDialog(null, "Unable to parse the select num!", "Error Messages", 0);
                this.filterValueTextfield.setText(Double.toString(RuntimeVariables.RawDataFilterValue));
            }
        } else if (source == this.selectHighlightedButton) {
            this.selectHighlightedListItem(true);
        } else if (source == this.deselectHighlightedButton) {
            this.selectHighlightedListItem(false);
        } else if (source == this.selectAllButton) {
            if (this.filteredItemList != null) {
                this.selectListItem(this.filteredItemList.size(), true);
            }
        } else if (source == this.deselectAllButton) {
            if (this.filteredItemList != null) {
                this.selectListItem(this.filteredItemList.size(), false);
            }
        } else if (source == this.searchButton) {
            if (!this.searchListItem(this.searchTextField.getText())) {
                JOptionPane.showMessageDialog(null, "Unable to find the string!", "Information Messages", 1);
            }
        } else if (source == this.resetListSelectionButton) {
            this.resetDataList();
        } else if (source == this.updateGraphButton) {
            RuntimeVariables.PathwayGraphPanel.setGraph(this.getSelectedItemList());
        }
    }

    private class BOOSTResultItemListCellRenderer
    extends DefaultListCellRenderer
    implements ListCellRenderer {
        private BOOSTResultItemListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            BOOSTResultItem item = (BOOSTResultItem)value;
            if (item.selected) {
                Component component = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (isSelected) {
                    this.setBackground(Color.GRAY);
                    this.setForeground(list.getSelectionForeground());
                } else {
                    this.setBackground(Color.LIGHT_GRAY);
                    this.setForeground(list.getForeground());
                }
                return component;
            }
            return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SORT_ORDER {
        SNPNAME1,
        SNPNAME2,
        BOOSTVALUE;

    }
}

