/*
 * Decompiled with CFR 0.152.
 */
package gboost_gui;

import Graph.GraphPanel;
import Graph.Tool.GraphNodePropertyPanel;
import Graph.Tool.GraphOptionPanel;
import Plot.MarginalAssociationChartPanel;
import Utility.Magnifier.MagnifierAction;
import Utility.MemoryUsage.MemoryMonitorDockableDescriptor;
import gboost_gui.Dialog.GBOOSTTaskDialog;
import gboost_gui.RuntimeVariables;
import gboost_gui.ToolPanel.RawDataToolPanel;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.noos.xing.mydoggy.AggregationPosition;
import org.noos.xing.mydoggy.Content;
import org.noos.xing.mydoggy.ContentManager;
import org.noos.xing.mydoggy.ContentManagerUI;
import org.noos.xing.mydoggy.ContentManagerUIListener;
import org.noos.xing.mydoggy.DockedTypeDescriptor;
import org.noos.xing.mydoggy.MultiSplitConstraint;
import org.noos.xing.mydoggy.TabbedContentManagerUI;
import org.noos.xing.mydoggy.TabbedContentUI;
import org.noos.xing.mydoggy.ToolWindow;
import org.noos.xing.mydoggy.ToolWindowAnchor;
import org.noos.xing.mydoggy.ToolWindowGroup;
import org.noos.xing.mydoggy.ToolWindowType;
import org.noos.xing.mydoggy.event.ContentManagerUIEvent;
import org.noos.xing.mydoggy.plaf.MyDoggyToolWindowManager;
import org.noos.xing.mydoggy.plaf.ui.cmp.ExtendedTableLayout;
import org.noos.xing.mydoggy.plaf.ui.content.MyDoggyMultiSplitContentManagerUI;

class MainFrame
extends JFrame
implements ContentManagerUIListener {
    private JFrame framePointer = this;
    private ContentManager contentManager = null;
    private MyDoggyToolWindowManager toolWindowManager = null;
    private JPanel toolWindowPanel = null;
    private GraphPanel graphPanel = null;
    private MarginalAssociationChartPanel marginalAssociationChartPanel = null;
    private RawDataToolPanel rawDataToolPanel = null;
    private GraphNodePropertyPanel nodePropertyPanel = null;
    private GraphOptionPanel graphOptionPanel = null;

    public MainFrame() {
        super("GBoost GUI");
        this.initMenuBar();
        this.initToolWindowPanel();
        this.contentManager = this.toolWindowManager.getContentManager();
        this.initContentManager();
        this.setDefaultCloseOperation(3);
        this.setLocationRelativeTo(null);
        this.getContentPane().add(this.toolWindowPanel);
        this.pack();
    }

    protected void initMenuBar() {
        JMenuBar programMenu = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        JMenuItem newGBOOSTTaskItem = new JMenuItem("New GBOOST task / Import BOOST result file...");
        newGBOOSTTaskItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GBOOSTTaskDialog taskDialog = new GBOOSTTaskDialog();
            }
        });
        JMenuItem savePathwayGraph = new JMenuItem("Save Pathway Graph to bmp...");
        savePathwayGraph.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JFileChooser fc = new JFileChooser();
                int returnVal = fc.showSaveDialog(null);
                if (returnVal == 0) {
                    File file = fc.getSelectedFile();
                    int result = RuntimeVariables.PathwayGraphPanel.writeImage(file.getAbsolutePath(), "bmp");
                    if (result == -1) {
                        JOptionPane.showMessageDialog(null, "Unable to save the Pathway Graph.", "Error Message", 0);
                    } else {
                        JOptionPane.showMessageDialog(null, "Save Pathway Graph to " + file.getAbsolutePath(), "Info Message", 1);
                    }
                }
            }
        });
        JMenuItem saveMarginalAssociationPlot = new JMenuItem("Save Marginal Assoication Plot to bmp...");
        saveMarginalAssociationPlot.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JFileChooser fc = new JFileChooser();
                int returnVal = fc.showSaveDialog(null);
                if (returnVal == 0) {
                    File file = fc.getSelectedFile();
                    int result = RuntimeVariables.MarginalAssoicationPanel.writeImage(file.getAbsolutePath(), "bmp");
                    if (result == -1) {
                        JOptionPane.showMessageDialog(null, "Unable to save the Marginal Assoication Plot.", "Error Message", 0);
                    } else {
                        JOptionPane.showMessageDialog(null, "Save Marginal Assoication Plot to " + file.getAbsolutePath(), "Info Message", 1);
                    }
                }
            }
        });
        JMenuItem exitItem = new JMenuItem("Exit");
        exitItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int result = JOptionPane.showConfirmDialog(MainFrame.this.framePointer, "Confirm to leave", "Exit...", 1);
                if (result == 0) {
                    System.exit(0);
                }
            }
        });
        fileMenu.add(newGBOOSTTaskItem);
        fileMenu.add(savePathwayGraph);
        fileMenu.add(saveMarginalAssociationPlot);
        fileMenu.add(exitItem);
        JMenu toolMenu = new JMenu("Tool");
        MagnifierAction magnifier = new MagnifierAction(this);
        toolMenu.add(magnifier);
        programMenu.add(fileMenu);
        programMenu.add(toolMenu);
        this.setJMenuBar(programMenu);
    }

    protected void initToolWindowPanel() {
        this.toolWindowManager = new MyDoggyToolWindowManager();
        this.toolWindowPanel = new JPanel();
        this.toolWindowPanel.setLayout((LayoutManager)new ExtendedTableLayout((double[][])new double[][]{{0.0, -1.0, 0.0}, {0.0, -1.0, 0.0}}));
        this.toolWindowPanel.add((Component)this.toolWindowManager, "1,1,");
        ToolWindowGroup mainGroup = this.toolWindowManager.getToolWindowGroup("main");
        this.rawDataToolPanel = new RawDataToolPanel();
        ToolWindow rawDataToolWindow = this.toolWindowManager.registerToolWindow("DataToolWindow", "Data Tool Window", null, (Component)this.rawDataToolPanel, ToolWindowAnchor.LEFT);
        this.nodePropertyPanel = new GraphNodePropertyPanel();
        ToolWindow nodePropertyToolWindow = this.toolWindowManager.registerToolWindow("NodeProperty", "Node Property", null, (Component)this.nodePropertyPanel, ToolWindowAnchor.RIGHT);
        RuntimeVariables.NodePropertyPanel = this.nodePropertyPanel;
        this.graphOptionPanel = new GraphOptionPanel();
        ToolWindow graphOptionToolWindow = this.toolWindowManager.registerToolWindow("PathwayGraphOption", "Pathway Graph Option", null, (Component)this.graphOptionPanel, ToolWindowAnchor.RIGHT);
        MemoryMonitorDockableDescriptor memoryMonitorDescriptor = new MemoryMonitorDockableDescriptor(this.toolWindowManager, ToolWindowAnchor.BOTTOM);
        memoryMonitorDescriptor.setAvailable(true);
        for (ToolWindow window : this.toolWindowManager.getToolWindows()) {
            window.setAvailable(true);
            window.setType(ToolWindowType.DOCKED);
            ((DockedTypeDescriptor)window.getTypeDescriptor(ToolWindowType.DOCKED)).setDockLength(250);
        }
    }

    protected void initContentManager() {
        MyDoggyMultiSplitContentManagerUI contentManagerUI = new MyDoggyMultiSplitContentManagerUI();
        this.contentManager.setContentManagerUI((ContentManagerUI)contentManagerUI);
        contentManagerUI.setShowAlwaysTab(true);
        contentManagerUI.setTabPlacement(TabbedContentManagerUI.TabPlacement.TOP);
        contentManagerUI.addContentManagerUIListener((ContentManagerUIListener)this);
        try {
            this.graphPanel = new GraphPanel();
        }
        catch (SQLException ex) {
            Logger.getLogger(MainFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
        Content graphPanelContent = this.contentManager.addContent("PathwayGraph", "PathwayGraph", null, (Component)this.graphPanel, null, new Object[]{new MultiSplitConstraint(AggregationPosition.DEFAULT)});
        this.marginalAssociationChartPanel = new MarginalAssociationChartPanel();
        this.contentManager.addContent("Marginal Association Chart", "Marginal Association Chart", null, (Component)this.marginalAssociationChartPanel, null, new Object[]{new MultiSplitConstraint(graphPanelContent)});
        TabbedContentUI contentUI = (TabbedContentUI)contentManagerUI.getContentUI(this.contentManager.getContent(0));
        contentUI.setCloseable(false);
        contentUI.setDetachable(true);
        contentUI.setTransparentMode(true);
        contentUI.setTransparentRatio(0.7f);
        contentUI.setTransparentDelay(1000);
        contentUI = (TabbedContentUI)contentManagerUI.getContentUI(this.contentManager.getContent(1));
        contentUI.setCloseable(false);
        contentUI.setDetachable(true);
        contentUI.setTransparentMode(true);
        contentUI.setTransparentRatio(0.7f);
        contentUI.setTransparentDelay(1000);
    }

    public boolean contentUIRemoving(ContentManagerUIEvent event) {
        return JOptionPane.showConfirmDialog(this, "Are you sure?") == 0;
    }

    public void contentUIDetached(ContentManagerUIEvent event) {
    }

    public RawDataToolPanel getRawDataToolPanel() {
        return this.rawDataToolPanel;
    }

    public GraphPanel getPathwayGraphPanel() {
        return this.graphPanel;
    }

    public GraphNodePropertyPanel getNodePropertyPanel() {
        return this.nodePropertyPanel;
    }

    public MarginalAssociationChartPanel getMarginalAssoicationChartPanel() {
        return this.marginalAssociationChartPanel;
    }
}

