/*
 * Decompiled with CFR 0.152.
 */
package gboost_gui.Dialog;

import Data.BOOST.BOOSTMarginalAssociationFile;
import Data.BOOST.BOOSTResultFile;
import Utility.Process.ProcessLauncher;
import gboost_gui.Configuration;
import gboost_gui.RuntimeVariables;
import info.clearthought.layout.TableLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class GBOOSTTaskDialog
extends JDialog
implements ActionListener {
    public static final String OPEN_INPUT_FILE_COMMAND = "OPEN_INPUT_FILE";
    public static final String EXECUTE_GBOOST_TASK_COMMAND = "EXECUTE_GBOOST";
    public static final String IMPORT_BOOST_FILE_COMMAND = "IMPORT_FILE";
    private TableLayout dialogTableLayout = null;
    private JPanel optionPanel = null;
    private JPanel programOptionPanel = null;
    private JTextField thresholdTextField = new JTextField(Double.toString(Configuration.GBOOST_Threshold));
    private JPanel infoPanel = null;
    private JPanel workModePanel = null;
    private JRadioButton cpuRadioButton = new JRadioButton("CPU");
    private JRadioButton gpuJRadioButton = new JRadioButton("GPU");
    private JPanel fileOptionPanel = null;
    private JTextField inputFilePath = new JTextField();
    private JTextField outputFilePath = new JTextField();
    private JTextField outputPrefix = new JTextField("output_");
    private JPanel logPanel = null;
    private JTextArea logTextArea = null;
    private JProgressBar progressBar = null;
    private JButton importButton = new JButton("Import");
    private JButton executeButton = new JButton("Execute");
    private ProcessLauncher launcher = null;

    public GBOOSTTaskDialog() {
        super(new JFrame(), "New GBOOST Task...", true);
        double tableLayoutBorderSize = 10.0;
        double tableLayoutFillSize = -1.0;
        double tableLayoutPreferredSize = -2.0;
        double tableLayoutVGap = 2.0;
        double tableLayoutHGap = 5.0;
        double tableLayoutEmptySpace = 10.0;
        TableLayout tableLayout = null;
        int rowIndex = 0;
        Border loweredetched = BorderFactory.createEtchedBorder(1);
        TitledBorder titleBorder = null;
        this.infoPanel = new JPanel();
        tableLayout = new TableLayout(new double[]{tableLayoutBorderSize, -1.0, tableLayoutBorderSize}, new double[]{0.0});
        this.infoPanel.setLayout((LayoutManager)tableLayout);
        rowIndex = 0;
        tableLayout.insertRow(++rowIndex, tableLayoutPreferredSize);
        tableLayout.insertRow(++rowIndex, tableLayoutPreferredSize);
        this.infoPanel.add((Component)new JLabel("Operating System : " + System.getProperty("os.name")), "1,1");
        this.infoPanel.add((Component)new JLabel("Architecture : " + System.getProperty("os.arch")), "1,2");
        titleBorder = BorderFactory.createTitledBorder(loweredetched, "System Information");
        titleBorder.setTitleJustification(1);
        this.infoPanel.setBorder(titleBorder);
        this.workModePanel = new JPanel();
        ButtonGroup workModeButtonGroup = new ButtonGroup();
        workModeButtonGroup.add(this.cpuRadioButton);
        workModeButtonGroup.add(this.gpuJRadioButton);
        this.cpuRadioButton.setSelected(true);
        tableLayout = new TableLayout(new double[]{tableLayoutBorderSize, 0.3333333333333333, 0.3333333333333333, -1.0, tableLayoutBorderSize}, new double[]{0.0});
        this.workModePanel.setLayout((LayoutManager)tableLayout);
        rowIndex = 0;
        tableLayout.insertRow(++rowIndex, tableLayoutPreferredSize);
        this.workModePanel.add((Component)this.cpuRadioButton, "1, 1");
        this.workModePanel.add((Component)this.gpuJRadioButton, "2, 1");
        titleBorder = BorderFactory.createTitledBorder(loweredetched, "Work Mode");
        titleBorder.setTitleJustification(1);
        this.workModePanel.setBorder(titleBorder);
        this.fileOptionPanel = new JPanel();
        JButton inputFileOpenButton = new JButton("Open");
        inputFileOpenButton.setActionCommand(OPEN_INPUT_FILE_COMMAND);
        inputFileOpenButton.addActionListener(this);
        this.inputFilePath.setEditable(false);
        this.outputFilePath.setEditable(false);
        tableLayout = new TableLayout(new double[]{tableLayoutBorderSize, 0.2, -1.0, 0.2, tableLayoutBorderSize}, new double[]{0.0});
        this.fileOptionPanel.setLayout((LayoutManager)tableLayout);
        rowIndex = 0;
        tableLayout.insertRow(++rowIndex, tableLayoutPreferredSize);
        tableLayout.insertRow(++rowIndex, tableLayoutPreferredSize);
        tableLayout.insertRow(++rowIndex, tableLayoutPreferredSize);
        this.fileOptionPanel.add((Component)new JLabel("Input List File : "), "1, 1");
        this.fileOptionPanel.add((Component)this.inputFilePath, "2, 1");
        this.fileOptionPanel.add((Component)inputFileOpenButton, "3, 1");
        this.fileOptionPanel.add((Component)new JLabel("Output File Path : "), "1, 2");
        this.fileOptionPanel.add((Component)this.outputFilePath, "2, 2");
        this.fileOptionPanel.add((Component)new JLabel("Output File Prefix : "), "1, 3");
        this.fileOptionPanel.add((Component)this.outputPrefix, "2, 3");
        titleBorder = BorderFactory.createTitledBorder(loweredetched, "File Option");
        titleBorder.setTitleJustification(1);
        this.fileOptionPanel.setBorder(titleBorder);
        this.programOptionPanel = new JPanel();
        tableLayout = new TableLayout(new double[]{tableLayoutBorderSize, 0.2, 0.2, -1.0, tableLayoutBorderSize}, new double[]{0.0});
        this.programOptionPanel.setLayout((LayoutManager)tableLayout);
        rowIndex = 0;
        tableLayout.insertRow(++rowIndex, tableLayoutPreferredSize);
        this.programOptionPanel.add((Component)new JLabel("Threshold : "), "1,1");
        this.programOptionPanel.add((Component)this.thresholdTextField, "2,1");
        titleBorder = BorderFactory.createTitledBorder(loweredetched, "GBOOST Program Option");
        titleBorder.setTitleJustification(1);
        this.programOptionPanel.setBorder(titleBorder);
        this.logPanel = new JPanel();
        this.logTextArea = new JTextArea();
        this.logTextArea.setEditable(false);
        this.logTextArea.setColumns(60);
        this.logTextArea.setLineWrap(true);
        JScrollPane logScrollPane = new JScrollPane(this.logTextArea);
        this.progressBar = new JProgressBar(0, 100);
        this.progressBar.setValue(0);
        this.progressBar.setStringPainted(true);
        tableLayout = new TableLayout(new double[]{tableLayoutBorderSize, 0.2, -1.0, tableLayoutBorderSize}, new double[]{0.0});
        this.logPanel.setLayout((LayoutManager)tableLayout);
        rowIndex = 0;
        tableLayout.insertRow(++rowIndex, tableLayoutFillSize);
        tableLayout.insertRow(++rowIndex, tableLayoutPreferredSize);
        this.logPanel.add((Component)logScrollPane, "1, 1, 2, 1");
        this.logPanel.add((Component)new JLabel("Progress"), "1, 2");
        this.logPanel.add((Component)this.progressBar, "2, 2");
        titleBorder = BorderFactory.createTitledBorder(loweredetched, "GBOOST Program Log");
        titleBorder.setTitleJustification(1);
        this.logPanel.setBorder(titleBorder);
        this.optionPanel = new JPanel();
        this.dialogTableLayout = new TableLayout(new double[]{tableLayoutBorderSize, -1.0, tableLayoutBorderSize}, new double[]{0.0});
        this.optionPanel.setLayout((LayoutManager)this.dialogTableLayout);
        rowIndex = 0;
        this.dialogTableLayout.insertRow(++rowIndex, tableLayoutPreferredSize);
        this.dialogTableLayout.insertRow(++rowIndex, tableLayoutPreferredSize);
        this.dialogTableLayout.insertRow(++rowIndex, tableLayoutPreferredSize);
        this.dialogTableLayout.insertRow(++rowIndex, tableLayoutPreferredSize);
        this.dialogTableLayout.insertRow(++rowIndex, tableLayoutFillSize);
        this.optionPanel.add((Component)this.infoPanel, "1,1");
        this.optionPanel.add((Component)this.workModePanel, "1,2");
        this.optionPanel.add((Component)this.fileOptionPanel, "1,3");
        this.optionPanel.add((Component)this.programOptionPanel, "1,4");
        this.optionPanel.add((Component)this.logPanel, "1,5");
        JPanel executePanel = new JPanel();
        tableLayout = new TableLayout(new double[]{tableLayoutBorderSize, -1.0, 0.2, 0.2, tableLayoutBorderSize}, new double[]{0.0});
        executePanel.setLayout((LayoutManager)tableLayout);
        this.importButton.setActionCommand(IMPORT_BOOST_FILE_COMMAND);
        this.importButton.addActionListener(this);
        this.executeButton.setActionCommand(EXECUTE_GBOOST_TASK_COMMAND);
        this.executeButton.addActionListener(this);
        rowIndex = 0;
        tableLayout.insertRow(++rowIndex, tableLayoutPreferredSize);
        executePanel.add((Component)this.importButton, "2,1");
        executePanel.add((Component)this.executeButton, "3,1");
        this.setSize(new Dimension(640, 480));
        this.setLayout(new BorderLayout());
        this.add((Component)this.optionPanel, "Center");
        this.add((Component)executePanel, "South");
        this.setDefaultCloseOperation(2);
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (OPEN_INPUT_FILE_COMMAND.equals(command)) {
            JFileChooser fc = new JFileChooser();
            int returnVal = fc.showOpenDialog(null);
            if (returnVal == 0) {
                this.inputFilePath.setText(fc.getSelectedFile().getAbsolutePath());
                this.outputFilePath.setText(fc.getCurrentDirectory().getAbsolutePath());
            }
        } else if (EXECUTE_GBOOST_TASK_COMMAND.equals(command)) {
            if (!this.inputFilePath.getText().equals("")) {
                Vector<String> commandStringList = new Vector<String>();
                File boostExecutable = new File("./x64/GBOOST.exe");
                if (boostExecutable.exists()) {
                    commandStringList.add(boostExecutable.getAbsolutePath());
                }
                commandStringList.add("-l");
                commandStringList.add(this.inputFilePath.getText());
                commandStringList.add("-m");
                if (this.cpuRadioButton.isSelected()) {
                    commandStringList.add("CPU");
                } else {
                    commandStringList.add("GPU");
                }
                commandStringList.add("-o");
                commandStringList.add(this.outputPrefix.getText());
                commandStringList.add("-t");
                commandStringList.add(this.thresholdTextField.getText());
                this.launcher = new ProcessLauncher(this, commandStringList, this.logTextArea, new File(this.inputFilePath.getText()).getParentFile().getAbsolutePath());
                this.launcher.addPropertyChangeListener(new GBOOSTTaskProgressListener(this));
                this.progressBar.setIndeterminate(true);
                this.progressBar.setString("Initializing...");
                this.launcher.execute();
                this.executeButton.setEnabled(false);
            } else {
                JOptionPane.showMessageDialog(null, "No input list file is selected!", "Error Messages", 0);
            }
        } else if (IMPORT_BOOST_FILE_COMMAND.equals(command)) {
            if (!this.inputFilePath.getText().equals("")) {
                BOOSTResultFile interactionFile = new BOOSTResultFile(this.outputFilePath.getText() + "\\" + this.outputPrefix.getText() + "InteractionRecords.txt", this.inputFilePath.getText());
                BOOSTMarginalAssociationFile marginalAssociationFile = new BOOSTMarginalAssociationFile(this.outputFilePath.getText() + "\\" + this.outputPrefix.getText() + "MarginalAssociation.txt", this.inputFilePath.getText());
                RuntimeVariables.RawDataPanel.setFile(interactionFile);
                RuntimeVariables.MarginalAssoicationPanel.setMarginalAssociationPlot(marginalAssociationFile);
                this.dispose();
            } else {
                JOptionPane.showMessageDialog(null, "No input list file is selected!", "Error Messages", 0);
            }
        }
    }

    private class GBOOSTTaskProgressListener
    implements PropertyChangeListener {
        private JDialog parent = null;

        public GBOOSTTaskProgressListener(JDialog parent) {
            this.parent = parent;
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if ("progress".equals(evt.getPropertyName())) {
                Integer newValue = (Integer)evt.getNewValue();
                if (newValue >= 100) {
                    GBOOSTTaskDialog.this.executeButton.setEnabled(true);
                    if (GBOOSTTaskDialog.this.progressBar.isIndeterminate()) {
                        GBOOSTTaskDialog.this.progressBar.setIndeterminate(false);
                        GBOOSTTaskDialog.this.progressBar.setString(null);
                    }
                    GBOOSTTaskDialog.this.progressBar.setValue(100);
                    if (GBOOSTTaskDialog.this.launcher.getExitCode() == 0) {
                        BOOSTResultFile interactionFile = new BOOSTResultFile(GBOOSTTaskDialog.this.outputFilePath.getText() + "\\" + GBOOSTTaskDialog.this.outputPrefix.getText() + "InteractionRecords.txt", GBOOSTTaskDialog.this.inputFilePath.getText());
                        BOOSTMarginalAssociationFile marginalAssociationFile = new BOOSTMarginalAssociationFile(GBOOSTTaskDialog.this.outputFilePath.getText() + "\\" + GBOOSTTaskDialog.this.outputPrefix.getText() + "MarginalAssociation.txt", GBOOSTTaskDialog.this.inputFilePath.getText());
                        RuntimeVariables.RawDataPanel.setFile(interactionFile);
                        RuntimeVariables.MarginalAssoicationPanel.setMarginalAssociationPlot(marginalAssociationFile);
                        ((JFrame)this.parent.getParent()).dispose();
                    } else {
                        JOptionPane.showMessageDialog(null, "Encounter errors during GBOOST execution!", "Error Messages", 0);
                    }
                } else {
                    if (GBOOSTTaskDialog.this.progressBar.isIndeterminate()) {
                        GBOOSTTaskDialog.this.progressBar.setIndeterminate(false);
                        GBOOSTTaskDialog.this.progressBar.setString(null);
                    }
                    GBOOSTTaskDialog.this.progressBar.setValue((Integer)evt.getNewValue());
                }
            }
        }
    }
}

