/*
 * Decompiled with CFR 0.152.
 */
package Utility.Progress;

import Utility.Progress.ProgressSubDialog;
import java.awt.Component;
import java.awt.Toolkit;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ProgressMonitor;
import javax.swing.SwingWorker;

public class ProgressDialog
implements PropertyChangeListener {
    private String taskName = null;
    private ProgressSubDialog progressFrame = null;
    private ProgressMonitor progressMonitor = null;
    private SwingWorker worker = null;
    private boolean canCancel = false;

    public ProgressDialog(Component anchorComponenet, SwingWorker worker, String taskName, boolean canCancel) {
        this.worker = worker;
        this.taskName = taskName;
        this.canCancel = canCancel;
        worker.addPropertyChangeListener(this);
        if (this.canCancel) {
            this.progressMonitor = new ProgressMonitor(anchorComponenet, taskName, "", 0, 100);
            this.progressMonitor.setProgress(0);
            this.progressMonitor.setNote("Initializing...");
        } else {
            this.progressFrame = new ProgressSubDialog(anchorComponenet, taskName, 0, 100);
            this.progressFrame.setProgress(0);
            this.progressFrame.setNote("Initializing...");
        }
    }

    public String getTaskName() {
        return this.taskName;
    }

    public boolean canCancel() {
        return this.canCancel;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if ("progress".equals(evt.getPropertyName())) {
            int progress = (Integer)evt.getNewValue();
            String message = String.format("Completed %d%%.\n", progress);
            if (this.canCancel) {
                this.progressMonitor.setProgress(progress);
                this.progressMonitor.setNote(message);
                if (this.canCancel && this.progressMonitor.isCanceled()) {
                    Toolkit.getDefaultToolkit().beep();
                    this.worker.cancel(true);
                }
            } else {
                this.progressFrame.setProgress(progress);
                this.progressFrame.setNote(message);
            }
        }
    }
}

