/*
 * Decompiled with CFR 0.152.
 */
package Utility.Process;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.JDialog;
import javax.swing.JTextArea;
import javax.swing.SwingWorker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessLauncher
extends SwingWorker {
    private JDialog parent = null;
    private List<String> command = null;
    private JTextArea textArea = null;
    private String workingDirectory = null;
    private static Process process = null;
    private int exitCode = -1;

    public ProcessLauncher(JDialog parent, List<String> command, JTextArea textArea, String workingDirectory) {
        this.parent = parent;
        this.command = command;
        this.textArea = textArea;
        this.workingDirectory = workingDirectory;
    }

    protected Object doInBackground() throws Exception {
        this.parent.setDefaultCloseOperation(0);
        ProcessBuilder builder = new ProcessBuilder(this.command);
        Map<String, String> environ = builder.environment();
        File currentDirectory = new File(".");
        builder.directory(new File(this.workingDirectory));
        int textAreaWidth = this.textArea.getColumns();
        for (int i = 0; i < textAreaWidth; ++i) {
            this.textArea.append("=");
        }
        this.textArea.append("\n");
        this.textArea.append("Current Directory : " + currentDirectory.getCanonicalPath() + "\n");
        builder.redirectErrorStream(true);
        process = builder.start();
        StreamGobbler outputGobbler = new StreamGobbler(this, process.getInputStream(), this.textArea);
        outputGobbler.start();
        this.exitCode = process.waitFor();
        this.parent.setDefaultCloseOperation(2);
        return "All Completed";
    }

    @Override
    protected void done() {
        super.done();
        this.textArea.append("Program completed!\n\n");
        this.setProgress(100);
    }

    public int getExitCode() {
        return this.exitCode;
    }

    private class StreamGobbler
    extends Thread {
        ProcessLauncher parent;
        InputStream is;
        OutputStream os;
        JTextArea textArea;

        public StreamGobbler(ProcessLauncher parent, InputStream is, JTextArea textArea) {
            this.parent = parent;
            this.is = is;
            this.textArea = textArea;
            this.os = null;
        }

        public StreamGobbler(ProcessLauncher parent, InputStream is, OutputStream redirect, JTextArea textArea) {
            this.parent = parent;
            this.is = is;
            this.os = redirect;
            this.textArea = textArea;
        }

        public void run() {
            try {
                PrintWriter pw = null;
                if (this.os != null) {
                    pw = new PrintWriter(this.os);
                }
                InputStreamReader isr = new InputStreamReader(this.is);
                BufferedReader br = new BufferedReader(isr);
                String line = null;
                while ((line = br.readLine()) != null) {
                    if (line.contains("Progress")) {
                        StringTokenizer tokenizer = new StringTokenizer(line, ":");
                        tokenizer.nextToken();
                        int progress = Integer.parseInt(new StringTokenizer(tokenizer.nextToken(), "%%").nextToken());
                        this.parent.setProgress(progress);
                    }
                    this.textArea.append(line + "\n");
                    this.textArea.setCaretPosition(this.textArea.getDocument().getLength());
                }
                if (pw != null) {
                    pw.flush();
                }
                br.close();
                isr.close();
                this.is.close();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }
}

