/*
 * Decompiled with CFR 0.152.
 */
package Utility.MemoryUsage;

import Utility.MemoryUsage.MonitorSource;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;

public class MonitorPanel
extends JPanel {
    public Surface surf;

    public MonitorPanel(MonitorSource monitorSource) {
        this.setLayout(new BorderLayout());
        this.surf = this.createSurface();
        this.add(this.surf);
        this.setMonitorSource(monitorSource);
    }

    public void start() {
        this.surf.start();
    }

    public void stop() {
        this.surf.stop();
    }

    public MonitorSource getMonitorSource() {
        return this.surf.getMonitorSource();
    }

    public void setMonitorSource(MonitorSource monitorSource) {
        this.surf.setMonitorSource(monitorSource);
    }

    protected Surface createSurface() {
        return new Surface(null);
    }

    protected class Surface
    extends JPanel
    implements Runnable {
        private Thread thread;
        private MonitorSource monitorSource;
        private long sleepAmount = 100L;
        private int w;
        private int h;
        private BufferedImage backImage;
        private Graphics2D backImageGrfx;
        private Font font = new Font("Times New Roman", 0, 11);
        private int columnInc;
        private double[] points;
        private int validPoints;
        private int ascent;
        private int descent;
        private Rectangle2D mfRect = new Rectangle2D.Float();
        private Rectangle2D muRect = new Rectangle2D.Float();
        private Line2D graphLine = new Line2D.Float();
        private Color graphColor = new Color(46, 139, 87);
        private Color mfColor = new Color(0, 100, 0);

        public Surface(MonitorSource monitorSource) {
            this.monitorSource = monitorSource;
            this.setBackground(Color.black);
        }

        public void paint(Graphics g) {
            int i;
            Dimension size = this.getSize();
            if (size.width != this.w || size.height != this.h) {
                this.w = size.width;
                this.h = size.height;
                this.backImage = new BufferedImage(this.w, this.h, 1);
                this.backImageGrfx = this.backImage.createGraphics();
                this.backImageGrfx.setFont(this.font);
                FontMetrics fm = this.backImageGrfx.getFontMetrics(this.font);
                this.ascent = fm.getAscent();
                this.descent = fm.getDescent();
            }
            this.backImageGrfx.setBackground(this.getBackground());
            this.backImageGrfx.clearRect(0, 0, this.w, this.h);
            float totalMemory = this.monitorSource.getTotal();
            float usedMemory = this.monitorSource.getUsed();
            float freeMemory = totalMemory - usedMemory;
            this.backImageGrfx.setColor(Color.green);
            this.backImageGrfx.drawString(String.valueOf((int)totalMemory >> 10) + "K allocated", 4.0f, (float)this.ascent + 0.5f);
            String usedStr = String.valueOf((int)usedMemory >> 10) + "K used";
            this.backImageGrfx.drawString(usedStr, 4, this.h - this.descent);
            float ssH = this.ascent + this.descent;
            float remainingHeight = (float)this.h - ssH * 2.0f - 0.5f;
            float blockHeight = remainingHeight / 10.0f;
            float blockWidth = 20.0f;
            this.backImageGrfx.setColor(this.mfColor);
            int MemUsage = (int)(freeMemory / totalMemory * 10.0f);
            for (i = 0; i < MemUsage; ++i) {
                this.mfRect.setRect(5.0, ssH + (float)i * blockHeight, blockWidth, blockHeight - 1.0f);
                this.backImageGrfx.fill(this.mfRect);
            }
            this.backImageGrfx.setColor(Color.green);
            while (i < 10) {
                this.muRect.setRect(5.0, ssH + (float)i * blockHeight, blockWidth, blockHeight - 1.0f);
                this.backImageGrfx.fill(this.muRect);
                ++i;
            }
            this.backImageGrfx.setColor(this.graphColor);
            int graphX = 30;
            int graphY = (int)ssH;
            int graphW = this.w - graphX - 5;
            if (graphW < 0) {
                graphW = 100;
            }
            int graphH = (int)(ssH + 9.0f * blockHeight + blockHeight - 1.0f);
            for (i = 0; i < 10; ++i) {
                this.muRect.setRect(graphX, ssH + (float)i * blockHeight - 1.0f, graphW, blockHeight);
                this.backImageGrfx.draw(this.muRect);
            }
            int graphColumn = graphW / 15;
            if (this.columnInc == 0) {
                this.columnInc = graphColumn;
            }
            for (int j = graphX + this.columnInc; j < graphW + graphX; j += graphColumn) {
                this.graphLine.setLine(j, graphY, j, ssH + (float)i * blockHeight - 1.0f);
                this.backImageGrfx.draw(this.graphLine);
            }
            --this.columnInc;
            if (this.points == null) {
                this.points = new double[graphW];
                this.validPoints = 0;
            } else if (this.points.length != graphW) {
                double[] tmp;
                if (this.validPoints < graphW) {
                    tmp = new double[this.validPoints];
                    System.arraycopy(this.points, 0, tmp, 0, tmp.length);
                } else {
                    tmp = new double[graphW];
                    System.arraycopy(this.points, this.points.length - tmp.length, tmp, 0, tmp.length);
                    this.validPoints = tmp.length - 2;
                }
                this.points = new double[graphW];
                System.arraycopy(tmp, 0, this.points, 0, tmp.length);
            } else {
                this.backImageGrfx.setColor(Color.yellow);
                int x = this.w - 5;
                int sum = graphH - (this.ascent + this.descent);
                int j = x - this.validPoints;
                int k = 0;
                while (k < this.validPoints) {
                    if (k != 0) {
                        if (this.points[k] != this.points[k - 1]) {
                            this.backImageGrfx.drawLine(j - 1, graphY + (int)((double)sum * this.points[k - 1]), j, graphY + (int)((double)sum * this.points[k]));
                        } else {
                            this.backImageGrfx.fillRect(j, graphY + (int)((double)sum * this.points[k]), 1, 1);
                        }
                    }
                    ++k;
                    ++j;
                }
            }
            g.drawImage(this.backImage, 0, 0, this);
        }

        public void run() {
            while (this.thread != null) {
                float totalMemory = this.monitorSource.getTotal();
                float usedMemory = this.monitorSource.getUsed();
                float freeMemory = totalMemory - usedMemory;
                if (this.points == null) {
                    this.points = new double[1];
                    this.validPoints = 0;
                } else if (this.points.length < this.validPoints + 1) {
                    double[] tmp;
                    int graphW = this.validPoints + 1;
                    if (this.validPoints < graphW) {
                        tmp = new double[this.validPoints];
                        System.arraycopy(this.points, 0, tmp, 0, tmp.length);
                    } else {
                        tmp = new double[graphW];
                        System.arraycopy(this.points, this.points.length - tmp.length, tmp, 0, tmp.length);
                        this.validPoints = tmp.length - 2;
                    }
                    this.points = new double[graphW];
                    System.arraycopy(tmp, 0, this.points, 0, tmp.length);
                } else {
                    this.points[this.validPoints] = freeMemory / totalMemory;
                    if (this.validPoints + 2 == this.points.length) {
                        System.arraycopy(this.points, 1, this.points, 0, this.validPoints);
                        --this.validPoints;
                    } else {
                        ++this.validPoints;
                    }
                }
                this.repaint();
                try {
                    Thread.sleep(this.sleepAmount);
                }
                catch (InterruptedException e) {
                    break;
                }
            }
        }

        public void start() {
            if (this.monitorSource == null) {
                throw new IllegalStateException("Monitor Source cannot be null.");
            }
            this.thread = new Thread(this);
            this.thread.setPriority(1);
            this.thread.setDaemon(true);
            this.thread.setName("MemoryMonitor");
            this.thread.start();
        }

        public synchronized void stop() {
            this.thread = null;
            this.notify();
        }

        public MonitorSource getMonitorSource() {
            return this.monitorSource;
        }

        public void setMonitorSource(MonitorSource monitorSource) {
            this.monitorSource = monitorSource;
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        public Dimension getPreferredSize() {
            return new Dimension(135, 80);
        }
    }
}

