/*
 * Decompiled with CFR 0.152.
 */
package Utility.MemoryUsage;

import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import org.noos.xing.mydoggy.ToolWindowAnchor;
import org.noos.xing.mydoggy.plaf.MyDoggyToolWindowManager;
import org.noos.xing.mydoggy.plaf.ui.CustomDockableDescriptor;
import org.noos.xing.mydoggy.plaf.ui.util.StringUtil;

public class MemoryMonitorDockableDescriptor
extends CustomDockableDescriptor {
    public MemoryMonitorDockableDescriptor(MyDoggyToolWindowManager manager, ToolWindowAnchor anchor) {
        super(manager, anchor);
    }

    public void updateRepresentativeAnchor() {
    }

    public JComponent getRepresentativeAnchor(Component parent) {
        if (this.representativeAnchor == null) {
            this.representativeAnchor = new MemoryMonitorPanel(this.anchor);
        }
        return this.representativeAnchor;
    }

    public class MemoryMonitorPanel
    extends JPanel {
        int sleepTime = 1000;

        public MemoryMonitorPanel(ToolWindowAnchor anchor) {
            final JProgressBar memoryUsage = new JProgressBar();
            memoryUsage.setStringPainted(true);
            Thread memoryThread = new Thread(new Runnable(){

                public void run() {
                    while (true) {
                        String grabbed = StringUtil.bytes2MBytes((long)(Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()));
                        String max = StringUtil.bytes2MBytes((long)Runtime.getRuntime().maxMemory());
                        memoryUsage.setMaximum(Integer.parseInt(max));
                        memoryUsage.setValue(Integer.parseInt(grabbed));
                        memoryUsage.setString(grabbed + " MB of " + max + " MB");
                        try {
                            Thread.sleep(MemoryMonitorPanel.this.sleepTime);
                        }
                        catch (InterruptedException interruptedException) {
                        }
                    }
                }
            });
            memoryThread.setDaemon(true);
            memoryThread.setPriority(1);
            memoryThread.start();
            switch (anchor) {
                case BOTTOM: 
                case TOP: {
                    memoryUsage.setOrientation(0);
                    this.setLayout((LayoutManager)new TableLayout((double[][])new double[][]{{120.0, 1.0, 17.0}, {-1.0}}));
                    this.add((Component)memoryUsage, "0,0,FULL,FULL");
                    break;
                }
                case LEFT: {
                    memoryUsage.setOrientation(1);
                    this.setLayout((LayoutManager)new TableLayout((double[][])new double[][]{{-1.0}, {120.0, 1.0, 17.0}}));
                    this.add((Component)memoryUsage, "0,0,FULL,FULL");
                    break;
                }
                case RIGHT: {
                    memoryUsage.setOrientation(1);
                    this.setLayout((LayoutManager)new TableLayout((double[][])new double[][]{{-1.0}, {17.0, 1.0, 120.0}}));
                    this.add((Component)memoryUsage, "0,2,FULL,FULL");
                }
            }
            MemoryMonitorDockableDescriptor.this.registerDragGesture(memoryUsage);
            MemoryMonitorDockableDescriptor.this.registerDragGesture(this);
        }

        public void setSleepTime(int sleepTime) {
            this.sleepTime = sleepTime;
        }
    }
}

