/*
 * Decompiled with CFR 0.152.
 */
package Utility.Magnifier;

import Utility.Magnifier.JImage;
import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.image.BufferedImage;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;

public class PreviewPanel
extends JPanel {
    protected JImage image;
    protected SpinnerModel widthModel;
    protected SpinnerModel heightModel;

    public PreviewPanel() {
        super((LayoutManager)new TableLayout((double[][])new double[][]{{-2.0, -1.0}, {3.0, 20.0, 3.0, 20.0, 3.0, -1.0}}));
        this.setBorder(new TitledBorder("Preview"));
        this.image = new JImage();
        this.add((Component)this.image, "0,5,1,5,FULL,FULL");
        this.image.setPreferredSize(new Dimension(150, 113));
        this.add((Component)new JLabel("Width :"), "0,1,FULL,FULL");
        this.widthModel = new SpinnerNumberModel();
        this.add((Component)new JSpinner(this.widthModel), "1,1,FULL,FULL");
        this.add((Component)new JLabel("Height :"), "0,3,FULL,FULL");
        this.heightModel = new SpinnerNumberModel();
        this.add((Component)new JSpinner(this.heightModel), "1,3,FULL,FULL");
    }

    public void setImage(BufferedImage bufferedImage) {
        this.image.setImage(bufferedImage);
        this.widthModel.setValue(bufferedImage.getWidth());
        this.heightModel.setValue(bufferedImage.getHeight());
    }

    public int getImageWidth() {
        return (Integer)this.widthModel.getValue();
    }

    public int getImageHeight() {
        return (Integer)this.heightModel.getValue();
    }

    public void setImageWidth(int width) {
        this.widthModel.setValue(width);
    }

    public void setImageHeight(int height) {
        this.heightModel.setValue(height);
    }

    public BufferedImage getImage() {
        BufferedImage bufferedImage = this.image.getImage();
        if (bufferedImage.getWidth() == this.getImageWidth() && bufferedImage.getHeight() == this.getImageHeight()) {
            return bufferedImage;
        }
        Image scaledImage = bufferedImage.getScaledInstance(this.getImageWidth(), this.getImageHeight(), 4);
        BufferedImage scaled = new BufferedImage(this.getImageWidth(), this.getImageHeight(), 1);
        scaled.getGraphics().drawImage(scaledImage, 0, 0, null);
        return scaled;
    }
}

