/*
 * Decompiled with CFR 0.152.
 */
package Utility.Magnifier;

import Utility.Magnifier.PreviewPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.KeyEventPostProcessor;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Robot;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.JLayeredPane;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import org.noos.xing.mydoggy.plaf.ui.cmp.event.FloatingMoveMouseInputHandler;
import org.noos.xing.mydoggy.plaf.ui.util.GraphicsUtil;
import org.noos.xing.mydoggy.plaf.ui.util.SwingUtil;

public class MagnifierAction
extends AbstractAction {
    protected Component parentComponent;
    protected JFileChooser fileChooser;
    protected Preferences preferences;
    protected LensPanel lensPanel;
    protected PreviewPanel previewPanel;
    protected Rectangle boundsToShot;

    public MagnifierAction(Component parentComponent) {
        super("Magnifier");
        this.parentComponent = parentComponent;
        this.lensPanel = new LensPanel();
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(new Character('m'), 2));
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventPostProcessor(new KeyEventPostProcessor(){

            public boolean postProcessKeyEvent(KeyEvent e) {
                switch (e.getID()) {
                    case 400: {
                        if (!e.isControlDown() || e.getKeyChar() != '\n') break;
                        MagnifierAction.this.actionPerformed(null);
                    }
                }
                return false;
            }
        });
    }

    public void actionPerformed(ActionEvent e) {
        this.lensPanel.mount();
        SwingUtil.repaint((Component)this.parentComponent);
    }

    protected class LensPanel
    extends JPanel {
        protected JLayeredPane layeredPane;
        protected boolean restore;
        protected Ellipse2D bigLen = new Ellipse2D.Double(3.0, 3.0, 144.0, 144.0);
        protected Ellipse2D smallLen = new Ellipse2D.Double(125.0, 125.0, 40.0, 40.0);
        protected int zoomLevel;
        protected int lensPosition;

        public LensPanel() {
            this.setOpaque(false);
            FloatingMoveMouseInputHandler floatingMoveMouseInputHandler = new FloatingMoveMouseInputHandler(this){

                public void mouseReleased(MouseEvent ev) {
                    super.mouseReleased(ev);
                    SwingUtil.repaint((Component)LensPanel.this);
                }
            };
            this.addMouseListener((MouseListener)floatingMoveMouseInputHandler);
            this.addMouseMotionListener((MouseMotionListener)floatingMoveMouseInputHandler);
            LensMouseInput lensMouseInput = new LensMouseInput();
            this.addMouseListener(lensMouseInput);
            this.addMouseWheelListener(lensMouseInput);
            this.layeredPane = ((RootPaneContainer)((Object)MagnifierAction.this.parentComponent)).getLayeredPane();
            this.lensPosition = 0;
            this.zoomLevel = 0;
        }

        protected void processMouseEvent(MouseEvent e) {
            switch (e.getID()) {
                case 500: 
                case 501: {
                    if (!this.bigLen.contains(e.getX(), e.getY()) && !this.smallLen.contains(e.getX(), e.getY())) break;
                    super.processMouseEvent(e);
                    break;
                }
                default: {
                    super.processMouseEvent(e);
                }
            }
        }

        protected void processMouseWheelEvent(MouseWheelEvent e) {
            switch (e.getID()) {
                case 507: {
                    if (!this.bigLen.contains(e.getX(), e.getY()) && !this.smallLen.contains(e.getX(), e.getY())) break;
                    super.processMouseWheelEvent(e);
                    break;
                }
                default: {
                    super.processMouseWheelEvent(e);
                }
            }
        }

        public void mount() {
            int x = MagnifierAction.this.parentComponent.getWidth() / 2 - 50;
            int y = MagnifierAction.this.parentComponent.getHeight() / 2 - 50;
            this.setBounds(x, y, 171, 171);
            this.layeredPane.remove(this);
            this.layeredPane.setLayer(this, JLayeredPane.DEFAULT_LAYER + 3);
            this.layeredPane.add(this);
            SwingUtil.repaint((Component)this.layeredPane);
        }

        public void unmount() {
            this.layeredPane.remove(this);
            SwingUtil.repaint((Component)this.layeredPane);
        }

        public void unmount(Runnable runnable) {
            this.layeredPane.remove(this);
            SwingUtil.repaint((Component)this.layeredPane, (Runnable)runnable);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected void paintComponent(Graphics g) {
            Graphics scratchGraphics = g == null ? null : g.create();
            try {
                Graphics2D g2D = (Graphics2D)g;
                g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                Rectangle bounds = this.smallLen.getBounds();
                Point location = bounds.getLocation();
                SwingUtilities.convertPointToScreen(location, this);
                bounds.setLocation(location);
                Robot robot = new Robot();
                int extra = this.zoomLevel * 10;
                BufferedImage image = GraphicsUtil.scale((BufferedImage)robot.createScreenCapture(bounds), (int)(144 + extra), (int)(144 + extra));
                g.setColor(Color.BLACK);
                switch (this.lensPosition) {
                    case 0: {
                        g.drawOval(0, 0, 150, 150);
                        g.drawOval(1, 1, 148, 148);
                        g.drawOval(2, 2, 146, 146);
                        g.drawOval(3, 3, 144, 144);
                        g.drawOval(120, 120, 50, 50);
                        g.drawOval(121, 121, 48, 48);
                        g.drawOval(122, 122, 46, 46);
                        Shape oldClip = g.getClip();
                        g.setClip(this.bigLen);
                        g.drawImage(image, 3 - extra / 2, 3 - extra / 2, this);
                        g.setClip(oldClip);
                        return;
                    }
                    case 1: {
                        g.drawOval(20, 0, 150, 150);
                        g.drawOval(21, 1, 148, 148);
                        g.drawOval(22, 2, 146, 146);
                        g.drawOval(23, 3, 144, 144);
                        g.drawOval(0, 120, 50, 50);
                        g.drawOval(1, 121, 48, 48);
                        g.drawOval(2, 122, 46, 46);
                        Shape oldClip = g.getClip();
                        g.setClip(this.bigLen);
                        g.drawImage(image, 23 - extra / 2, 3 - extra / 2, this);
                        g.setClip(oldClip);
                        return;
                    }
                    case 2: {
                        g.drawOval(20, 20, 150, 150);
                        g.drawOval(21, 21, 148, 148);
                        g.drawOval(22, 22, 146, 146);
                        g.drawOval(23, 23, 144, 144);
                        g.drawOval(0, 0, 50, 50);
                        g.drawOval(1, 1, 48, 48);
                        g.drawOval(2, 2, 46, 46);
                        Shape oldClip = g.getClip();
                        g.setClip(this.bigLen);
                        g.drawImage(image, 23 - extra / 2, 23 - extra / 2, this);
                        g.setClip(oldClip);
                        return;
                    }
                    case 3: {
                        g.drawOval(0, 20, 150, 150);
                        g.drawOval(1, 21, 148, 148);
                        g.drawOval(2, 22, 146, 146);
                        g.drawOval(3, 23, 144, 144);
                        g.drawOval(120, 0, 50, 50);
                        g.drawOval(121, 1, 48, 48);
                        g.drawOval(122, 2, 46, 46);
                        Shape oldClip = g.getClip();
                        g.setClip(this.bigLen);
                        g.drawImage(image, 3 - extra / 2, 23 - extra / 2, this);
                        g.setClip(oldClip);
                        return;
                    }
                }
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
            finally {
                scratchGraphics.dispose();
            }
        }

        protected class LensMouseInput
        extends MouseAdapter
        implements ActionListener,
        MouseWheelListener {
            protected JPopupMenu popupMenu = new JPopupMenu();

            public LensMouseInput() {
                JMenuItem close = new JMenuItem("Close");
                close.setActionCommand("close");
                close.addActionListener(this);
                this.popupMenu.add(close);
            }

            public void mouseWheelMoved(MouseWheelEvent e) {
                if (LensPanel.this.bigLen.contains(e.getX(), e.getY())) {
                    LensPanel.this.zoomLevel += e.getWheelRotation();
                    if (LensPanel.this.zoomLevel < 0) {
                        LensPanel.this.zoomLevel = 0;
                    }
                    SwingUtil.repaint((Component)LensPanel.this);
                } else if (LensPanel.this.smallLen.contains(e.getX(), e.getY())) {
                    LensPanel.this.lensPosition = (LensPanel.this.lensPosition + e.getWheelRotation()) % 4;
                    switch (LensPanel.this.lensPosition) {
                        case 0: {
                            LensPanel.this.bigLen.setFrame(3.0, 3.0, 144.0, 144.0);
                            LensPanel.this.smallLen.setFrame(125.0, 125.0, 40.0, 40.0);
                            break;
                        }
                        case 1: {
                            LensPanel.this.bigLen.setFrame(23.0, 3.0, 144.0, 144.0);
                            LensPanel.this.smallLen.setFrame(5.0, 125.0, 40.0, 40.0);
                            break;
                        }
                        case 2: {
                            LensPanel.this.bigLen.setFrame(23.0, 23.0, 144.0, 144.0);
                            LensPanel.this.smallLen.setFrame(5.0, 5.0, 40.0, 40.0);
                            break;
                        }
                        case 3: {
                            LensPanel.this.bigLen.setFrame(3.0, 23.0, 144.0, 144.0);
                            LensPanel.this.smallLen.setFrame(125.0, 5.0, 40.0, 40.0);
                        }
                    }
                    SwingUtil.repaint((Component)LensPanel.this);
                }
            }

            public void actionPerformed(ActionEvent e) {
                String actionCommand = e.getActionCommand();
                if ("close".equals(actionCommand)) {
                    LensPanel.this.unmount();
                }
            }

            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        }
    }
}

